/* jce - 2.9.2 | 2021-01-28 | https://www.joomlacontenteditor.net | Copyright (C) 2006 - 2020 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function(window){var WebGLProgram=function(gl,vertexSource,fragmentSource){var _collect=function(source,prefix,collection){var r=new RegExp("\\b"+prefix+" \\w+ (\\w+)","ig");source.replace(r,function(match,name){return collection[name]=0,match})},_compile=function(gl,source,type){var shader=gl.createShader(type);return gl.shaderSource(shader,source),gl.compileShader(shader),gl.getShaderParameter(shader,gl.COMPILE_STATUS)?shader:(console.log(gl.getShaderInfoLog(shader)),null)};this.uniform={},this.attribute={};var _vsh=_compile(gl,vertexSource,gl.VERTEX_SHADER),_fsh=_compile(gl,fragmentSource,gl.FRAGMENT_SHADER);this.id=gl.createProgram(),gl.attachShader(this.id,_vsh),gl.attachShader(this.id,_fsh),gl.linkProgram(this.id),gl.getProgramParameter(this.id,gl.LINK_STATUS)||console.log(gl.getProgramInfoLog(this.id)),gl.useProgram(this.id),_collect(vertexSource,"attribute",this.attribute);for(var a in this.attribute)this.attribute[a]=gl.getAttribLocation(this.id,a);_collect(vertexSource,"uniform",this.uniform),_collect(fragmentSource,"uniform",this.uniform);for(var u in this.uniform)this.uniform[u]=gl.getUniformLocation(this.id,u)};window.WebGLImageFilter=function(){var gl=null,_drawCount=0,_sourceTexture=null,_lastInChain=!1,_currentFramebufferIndex=-1,_tempFramebuffers=[null,null],_filterChain=[],_width=-1,_height=-1,_vertexBuffer=null,_currentProgram=null,_canvas=document.createElement("canvas");try{gl=_canvas.getContext("webgl")||_canvas.getContext("experimental-webgl")}catch(e){return!1}this.addFilter=function(name){var args=Array.prototype.slice.call(arguments,1),filter=_filter[name];_filterChain.push({func:filter,args:args})},this.reset=function(){_filterChain=[]},this.apply=function(image){if(_resize(image.width,image.height),_drawCount=0,_sourceTexture=gl.createTexture(),gl.bindTexture(gl.TEXTURE_2D,_sourceTexture),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST),gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,gl.RGBA,gl.UNSIGNED_BYTE,image),0==_filterChain.length){_compileShader(SHADER.FRAGMENT_IDENTITY);return _draw(),_canvas}for(var i=0;i<_filterChain.length;i++){_lastInChain=i==_filterChain.length-1;var f=_filterChain[i];f.func.apply(this,f.args||[])}return _canvas};var _resize=function(width,height){if(width!=_width||height!=_height){if(_canvas.width=_width=width,_canvas.height=_height=height,!_vertexBuffer){var vertices=new Float32Array([-1,-1,0,1,1,-1,1,1,-1,1,0,0,-1,1,0,0,1,-1,1,1,1,1,1,0]);_vertexBuffer=gl.createBuffer(),gl.bindBuffer(gl.ARRAY_BUFFER,_vertexBuffer),gl.bufferData(gl.ARRAY_BUFFER,vertices,gl.STATIC_DRAW),gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!0)}gl.viewport(0,0,_width,_height),_tempFramebuffers=[null,null]}},_getTempFramebuffer=function(index){return _tempFramebuffers[index]=_tempFramebuffers[index]||_createFramebufferTexture(_width,_height),_tempFramebuffers[index]},_createFramebufferTexture=function(width,height){var fbo=gl.createFramebuffer();gl.bindFramebuffer(gl.FRAMEBUFFER,fbo);var renderbuffer=gl.createRenderbuffer();gl.bindRenderbuffer(gl.RENDERBUFFER,renderbuffer);var texture=gl.createTexture();return gl.bindTexture(gl.TEXTURE_2D,texture),gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,width,height,0,gl.RGBA,gl.UNSIGNED_BYTE,null),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE),gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,texture,0),gl.bindTexture(gl.TEXTURE_2D,null),gl.bindFramebuffer(gl.FRAMEBUFFER,null),{fbo:fbo,texture:texture}},_draw=function(flags){var source=null,target=null,flipY=!1;source=0==_drawCount?_sourceTexture:_getTempFramebuffer(_currentFramebufferIndex).texture,_drawCount++,!_lastInChain||flags&DRAW.INTERMEDIATE?(_currentFramebufferIndex=(_currentFramebufferIndex+1)%2,target=_getTempFramebuffer(_currentFramebufferIndex).fbo):(target=null,flipY=_drawCount%2==0),gl.bindTexture(gl.TEXTURE_2D,source),gl.bindFramebuffer(gl.FRAMEBUFFER,target),gl.uniform1f(_currentProgram.uniform.flipY,flipY?-1:1),gl.drawArrays(gl.TRIANGLES,0,6)},_compileShader=function(fragmentSource){if(fragmentSource.__program)return _currentProgram=fragmentSource.__program,gl.useProgram(_currentProgram.id),_currentProgram;_currentProgram=new WebGLProgram(gl,SHADER.VERTEX_IDENTITY,fragmentSource);var floatSize=Float32Array.BYTES_PER_ELEMENT,vertSize=4*floatSize;return gl.enableVertexAttribArray(_currentProgram.attribute.pos),gl.vertexAttribPointer(_currentProgram.attribute.pos,2,gl.FLOAT,!1,vertSize,0*floatSize),gl.enableVertexAttribArray(_currentProgram.attribute.uv),gl.vertexAttribPointer(_currentProgram.attribute.uv,2,gl.FLOAT,!1,vertSize,2*floatSize),fragmentSource.__program=_currentProgram,_currentProgram},DRAW={INTERMEDIATE:1},SHADER={};SHADER.VERTEX_IDENTITY=["precision highp float;","attribute vec2 pos;","attribute vec2 uv;","varying vec2 vUv;","uniform float flipY;","void main(void) {","vUv = uv;","gl_Position = vec4(pos.x, pos.y*flipY, 0.0, 1.);","}"].join("\n"),SHADER.FRAGMENT_IDENTITY=["precision highp float;","varying vec2 vUv;","uniform sampler2D texture;","void main(void) {","gl_FragColor = texture2D(texture, vUv);","}"].join("\n");var _filter={};_filter.colorMatrix=function(matrix){var m=new Float32Array(matrix);m[4]/=255,m[9]/=255,m[14]/=255,m[19]/=255;var shader=1==m[18]&&0==m[3]&&0==m[8]&&0==m[13]&&0==m[15]&&0==m[16]&&0==m[17]&&0==m[19]?_filter.colorMatrix.SHADER.WITHOUT_ALPHA:_filter.colorMatrix.SHADER.WITH_ALPHA,program=_compileShader(shader);gl.uniform1fv(program.uniform.m,m),_draw()},_filter.colorMatrix.SHADER={},_filter.colorMatrix.SHADER.WITH_ALPHA=["precision highp float;","varying vec2 vUv;","uniform sampler2D texture;","uniform float m[20];","void main(void) {","vec4 c = texture2D(texture, vUv);","gl_FragColor.r = m[0] * c.r + m[1] * c.g + m[2] * c.b + m[3] * c.a + m[4];","gl_FragColor.g = m[5] * c.r + m[6] * c.g + m[7] * c.b + m[8] * c.a + m[9];","gl_FragColor.b = m[10] * c.r + m[11] * c.g + m[12] * c.b + m[13] * c.a + m[14];","gl_FragColor.a = m[15] * c.r + m[16] * c.g + m[17] * c.b + m[18] * c.a + m[19];","}"].join("\n"),_filter.colorMatrix.SHADER.WITHOUT_ALPHA=["precision highp float;","varying vec2 vUv;","uniform sampler2D texture;","uniform float m[20];","void main(void) {","vec4 c = texture2D(texture, vUv);","gl_FragColor.r = m[0] * c.r + m[1] * c.g + m[2] * c.b + m[4];","gl_FragColor.g = m[5] * c.r + m[6] * c.g + m[7] * c.b + m[9];","gl_FragColor.b = m[10] * c.r + m[11] * c.g + m[12] * c.b + m[14];","gl_FragColor.a = c.a;","}"].join("\n"),_filter.brightness=function(brightness){var b=(brightness||0)+1;_filter.colorMatrix([b,0,0,0,0,0,b,0,0,0,0,0,b,0,0,0,0,0,1,0])},_filter.saturation=function(amount){var x=2*(amount||0)/3+1,y=(x-1)*-.5;_filter.colorMatrix([x,y,y,0,0,y,x,y,0,0,y,y,x,0,0,0,0,0,1,0])},_filter.desaturate=function(){_filter.saturation(-1)},_filter.contrast=function(amount){var v=(amount||0)+1,o=-128*(v-1);_filter.colorMatrix([v,0,0,0,o,0,v,0,0,o,0,0,v,0,o,0,0,0,1,0])},_filter.negative=function(){_filter.contrast(-2)},_filter.hue=function(rotation){rotation=(rotation||0)/180*Math.PI;var cos=Math.cos(rotation),sin=Math.sin(rotation),lumR=.213,lumG=.715,lumB=.072;_filter.colorMatrix([lumR+cos*(1-lumR)+sin*-lumR,lumG+cos*-lumG+sin*-lumG,lumB+cos*-lumB+sin*(1-lumB),0,0,lumR+cos*-lumR+.143*sin,lumG+cos*(1-lumG)+.14*sin,lumB+cos*-lumB+sin*-.283,0,0,lumR+cos*-lumR+sin*-(1-lumR),lumG+cos*-lumG+sin*lumG,lumB+cos*(1-lumB)+sin*lumB,0,0,0,0,0,1,0])},_filter.desaturateLuminance=function(){_filter.colorMatrix([.2764723,.929708,.0938197,0,-37.1,.2764723,.929708,.0938197,0,-37.1,.2764723,.929708,.0938197,0,-37.1,0,0,0,1,0])},_filter.sepia=function(){_filter.colorMatrix([.393,.7689999,.18899999,0,0,.349,.6859999,.16799999,0,0,.272,.5339999,.13099999,0,0,0,0,0,1,0])},_filter.brownie=function(){_filter.colorMatrix([.5997023498159715,.34553243048391263,-.2708298674538042,0,47.43192855600873,-.037703249837783157,.8609577587992641,.15059552388459913,0,-36.96841498319127,.24113635128153335,-.07441037908422492,.44972182064877153,0,-7.562075277591283,0,0,0,1,0])},_filter.vintagePinhole=function(){_filter.colorMatrix([.6279345635605994,.3202183420819367,-.03965408211312453,0,9.651285835294123,.02578397704808868,.6441188644374771,.03259127616149294,0,7.462829176470591,.0466055556782719,-.0851232987247891,.5241648018700465,0,5.159190588235296,0,0,0,1,0])},_filter.kodachrome=function(){_filter.colorMatrix([1.1285582396593525,-.3967382283601348,-.03992559172921793,0,63.72958762196502,-.16404339962244616,1.0835251566291304,-.05498805115633132,0,24.732407896706203,-.16786010706155763,-.5603416277695248,1.6014850761964943,0,35.62982807460946,0,0,0,1,0])},_filter.technicolor=function(){_filter.colorMatrix([1.9125277891456083,-.8545344976951645,-.09155508482755585,0,11.793603434377337,-.3087833385928097,1.7658908555458428,-.10601743074722245,0,-70.35205161461398,-.231103377548616,-.7501899197440212,1.847597816108189,0,30.950940869491138,0,0,0,1,0])},_filter.polaroid=function(){_filter.colorMatrix([1.438,-.062,-.062,0,0,-.122,1.378,-.122,0,0,-.016,-.016,1.483,0,0,0,0,0,1,0])},_filter.shiftToBGR=function(){_filter.colorMatrix([0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0])},_filter.convolution=function(matrix){var m=new Float32Array(matrix),pixelSizeX=1/_width,pixelSizeY=1/_height,program=_compileShader(_filter.convolution.SHADER);gl.uniform1fv(program.uniform.m,m),gl.uniform2f(program.uniform.px,pixelSizeX,pixelSizeY),_draw()},_filter.convolution.SHADER=["precision highp float;","varying vec2 vUv;","uniform sampler2D texture;","uniform vec2 px;","uniform float m[9];","void main(void) {","vec4 c11 = texture2D(texture, vUv - px);","vec4 c12 = texture2D(texture, vec2(vUv.x, vUv.y - px.y));","vec4 c13 = texture2D(texture, vec2(vUv.x + px.x, vUv.y - px.y));","vec4 c21 = texture2D(texture, vec2(vUv.x - px.x, vUv.y) );","vec4 c22 = texture2D(texture, vUv);","vec4 c23 = texture2D(texture, vec2(vUv.x + px.x, vUv.y) );","vec4 c31 = texture2D(texture, vec2(vUv.x - px.x, vUv.y + px.y) );","vec4 c32 = texture2D(texture, vec2(vUv.x, vUv.y + px.y) );","vec4 c33 = texture2D(texture, vUv + px );","gl_FragColor = ","c11 * m[0] + c12 * m[1] + c22 * m[2] +","c21 * m[3] + c22 * m[4] + c23 * m[5] +","c31 * m[6] + c32 * m[7] + c33 * m[8];","gl_FragColor.a = c22.a;","}"].join("\n"),_filter.detectEdges=function(){_filter.convolution.call(this,[0,1,0,-3,1,0,1,0])},_filter.sobelX=function(){_filter.convolution.call(this,[-1,0,1,-2,0,2,-1,0,1])},_filter.sobelY=function(){_filter.convolution.call(this,[-1,-2,-1,0,0,0,1,2,1])},_filter.sharpen=function(amount){var a=amount||1;_filter.convolution.call(this,[0,-1*a,0,-1*a,1+4*a,-1*a,0,-1*a,0])},_filter.emboss=function(size){var s=size||1;_filter.convolution.call(this,[-2*s,-1*s,0,-1*s,1,1*s,0,1*s,2*s])},_filter.blur=function(size){var blurSizeX=size/7/_width,blurSizeY=size/7/_height,program=_compileShader(_filter.blur.SHADER);gl.uniform2f(program.uniform.px,0,blurSizeY),_draw(DRAW.INTERMEDIATE),gl.uniform2f(program.uniform.px,blurSizeX,0),_draw()},_filter.blur.SHADER=["precision highp float;","varying vec2 vUv;","uniform sampler2D texture;","uniform vec2 px;","void main(void) {","gl_FragColor = vec4(0.0);","gl_FragColor += texture2D(texture, vUv + vec2(-7.0*px.x, -7.0*px.y))*0.0044299121055113265;","gl_FragColor += texture2D(texture, vUv + vec2(-6.0*px.x, -6.0*px.y))*0.00895781211794;","gl_FragColor += texture2D(texture, vUv + vec2(-5.0*px.x, -5.0*px.y))*0.0215963866053;","gl_FragColor += texture2D(texture, vUv + vec2(-4.0*px.x, -4.0*px.y))*0.0443683338718;","gl_FragColor += texture2D(texture, vUv + vec2(-3.0*px.x, -3.0*px.y))*0.0776744219933;","gl_FragColor += texture2D(texture, vUv + vec2(-2.0*px.x, -2.0*px.y))*0.115876621105;","gl_FragColor += texture2D(texture, vUv + vec2(-1.0*px.x, -1.0*px.y))*0.147308056121;","gl_FragColor += texture2D(texture, vUv                             )*0.159576912161;","gl_FragColor += texture2D(texture, vUv + vec2( 1.0*px.x,  1.0*px.y))*0.147308056121;","gl_FragColor += texture2D(texture, vUv + vec2( 2.0*px.x,  2.0*px.y))*0.115876621105;","gl_FragColor += texture2D(texture, vUv + vec2( 3.0*px.x,  3.0*px.y))*0.0776744219933;","gl_FragColor += texture2D(texture, vUv + vec2( 4.0*px.x,  4.0*px.y))*0.0443683338718;","gl_FragColor += texture2D(texture, vUv + vec2( 5.0*px.x,  5.0*px.y))*0.0215963866053;","gl_FragColor += texture2D(texture, vUv + vec2( 6.0*px.x,  6.0*px.y))*0.00895781211794;","gl_FragColor += texture2D(texture, vUv + vec2( 7.0*px.x,  7.0*px.y))*0.0044299121055113265;","}"].join("\n"),_filter.gamma=function(amount){var program=_compileShader(_filter.gamma.SHADER);gl.uniform1f(program.uniform.gamma,amount),_draw()},_filter.gamma.SHADER=["varying vec2 texCoord;","uniform sampler2D texture;","uniform highp float gamma;","void main() {","vec4 color = texture2D(texture, texCoord);","color.r = pow(color.r, gamma);","color.g = pow(color.g, gamma);","color.b = pow(color.b, gamma);","gl_FragColor = color;","}"].join("\n"),_filter.exposure=function(amount){var program=_compileShader(_filter.exposure.SHADER);gl.uniform1f(program.uniform.exposure,amount),_draw()},_filter.exposure.SHADER=["varying vec2 texCoord;","uniform sampler2D texture;","uniform highp float exposure;","void main() {","vec4 textureColor = texture2D(texture, texCoord);","gl_FragColor = vec4(textureColor.rgb * pow(2.0, exposure), textureColor.a);","}"].join("\n"),_filter.dotscreen=function(angle,amount){var program=_compileShader(_filter.dotscreen.SHADER);gl.uniform1f(program.uniform.angle,1),_draw(DRAW.INTERMEDIATE),gl.uniform1f(program.uniform.scale,5),_draw(DRAW.INTERMEDIATE),gl.uniform4fv(program.uniform.dimensions,[0,0,0,0]),_draw()},_filter.dotscreen.SHADER=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform vec4 dimensions;","uniform sampler2D uSampler;","uniform float angle;","uniform float scale;","float pattern() {","float s = sin(angle), c = cos(angle);","vec2 tex = vTextureCoord * dimensions.xy;","vec2 point = vec2(","\tc * tex.x - s * tex.y,","\ts * tex.x + c * tex.y",") * scale;","return (sin(point.x) * sin(point.y)) * 4.0;","}","void main() {","vec4 color = texture2D(uSampler, vTextureCoord);","float average = (color.r + color.g + color.b) / 3.0;","gl_FragColor = vec4(vec3(average * 10.0 - 5.0 + pattern()), color.a);","}"].join("\n")}}(window),function(){function multiply(a,b){var i,j,k,col=[];for(i=0;i<5;i++){for(j=0;j<5;j++)col[j]=a[j+5*i];for(j=0;j<5;j++){var val=0;for(k=0;k<5;k++)val+=b[j+5*k]*col[k];a[j+5*i]=val}}return a}function adjustValue(value,limit){return Math.min(limit,Math.max(-limit,value))}var DELTA_INDEX=[0,.01,.02,.04,.05,.06,.07,.08,.1,.11,.12,.14,.15,.16,.17,.18,.2,.21,.22,.24,.25,.27,.28,.3,.32,.34,.36,.38,.4,.42,.44,.46,.48,.5,.53,.56,.59,.62,.65,.68,.71,.74,.77,.8,.83,.86,.89,.92,.95,.98,1,1.06,1.12,1.18,1.24,1.3,1.36,1.42,1.48,1.54,1.6,1.66,1.72,1.78,1.84,1.9,1.96,2,2.12,2.25,2.37,2.5,2.62,2.75,2.87,3,3.2,3.4,3.6,3.8,4,4.3,4.7,4.9,5,5.5,6,6.5,6.8,7,7.3,7.5,7.8,8,8.4,8.7,9,9.4,9.6,9.8,10],identity=[1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1],ColorMatrix=function(data){this.data=data};ColorMatrix.prototype={brightness:function(value){return value=adjustValue(value,255),this.apply(multiply(identity,[1,0,0,0,value,0,1,0,0,value,0,0,1,0,value,0,0,0,1,0,0,0,0,0,1]))},contrast:function(value){value=adjustValue(value,100);var x;return value<0?x=127+value/100*127:(x=value%1,x=0==x?DELTA_INDEX[value]:DELTA_INDEX[value<<0]*(1-x)+DELTA_INDEX[(value<<0)+1]*x,x=127*x+127),this.apply(multiply(identity,[x/127,0,0,0,.5*(127-x),0,x/127,0,0,.5*(127-x),0,0,x/127,0,.5*(127-x),0,0,0,1,0,0,0,0,0,1]))},saturate:function(value){value=adjustValue(value,100);var x=1+(value>0?3*value/100:value/100),lumR=.3086,lumG=.6094,lumB=.082;return this.apply(multiply(identity,[lumR*(1-x)+x,lumG*(1-x),lumB*(1-x),0,0,lumR*(1-x),lumG*(1-x)+x,lumB*(1-x),0,0,lumR*(1-x),lumG*(1-x),lumB*(1-x)+x,0,0,0,0,0,1,0,0,0,0,0,1]))},hue:function(value){value=adjustValue(value,180)/180*Math.PI;var cosVal=Math.cos(value),sinVal=Math.sin(value),lumR=.213,lumG=.715,lumB=.072;return this.apply(multiply(identity,[lumR+cosVal*(1-lumR)+sinVal*-lumR,lumG+cosVal*-lumG+sinVal*-lumG,lumB+cosVal*-lumB+sinVal*(1-lumB),0,0,lumR+cosVal*-lumR+.143*sinVal,lumG+cosVal*(1-lumG)+.14*sinVal,lumB+cosVal*-lumB+sinVal*-.283,0,0,lumR+cosVal*-lumR+sinVal*-(1-lumR),lumG+cosVal*-lumG+sinVal*lumG,lumB+cosVal*(1-lumB)+sinVal*lumB,0,0,0,0,0,1,0,0,0,0,0,1]))},polaroid:function(){return this.apply(multiply(identity,[1.438,-.062,-.062,0,0,-.122,1.378,-.122,0,0,-.016,-.016,1.483,0,0,0,0,0,1,0]))},filter:function(name,value){var fn=this[name];return fn?fn.apply(this,[value]):this},apply:function(matrix){for(var r,g,b,a,data=this.data,l=data.length,m0=matrix[0],m1=matrix[1],m2=matrix[2],m3=matrix[3],m4=matrix[4],m5=matrix[5],m6=matrix[6],m7=matrix[7],m8=matrix[8],m9=matrix[9],m10=matrix[10],m11=matrix[11],m12=matrix[12],m13=matrix[13],m14=matrix[14],m15=matrix[15],m16=matrix[16],m17=matrix[17],m18=matrix[18],m19=matrix[19],i=0;i<l;i+=4)r=data[i],g=data[i+1],b=data[i+2],a=data[i+3],data[i]=r*m0+g*m1+b*m2+a*m3+m4,data[i+1]=r*m5+g*m6+b*m7+a*m8+m9,data[i+2]=r*m10+g*m11+b*m12+a*m13+m14,data[i+3]=r*m15+g*m16+b*m17+a*m18+m19;return this}},window.ColorMatrix=ColorMatrix}(),function($){var ImageFilter=new WebGLImageFilter,Filter=function(canvas){return this.canvas=canvas,this.context=canvas.getContext("2d"),this.filters=[],this};Filter.prototype={apply:function(){for(var self=this,i=0;i<this.filters.length;i++){var item=self.filters[i],fn=self[item.name];fn&&fn.call(self,[item.values]),self.filters.splice(i)}return this},add:function(filter,values){return this.filters.push({name:filter,values:values}),this},reset:function(){return this.filters=[],this},_applyWebGlFilter:function(filter,value){ImageFilter.addFilter(filter,value);try{filteredImage=ImageFilter.apply(this.canvas)}catch(err){}filteredImage&&this.context.drawImage(filteredImage,0,0),ImageFilter.reset()},_applyColorMatrixFilter:function(filter,amount){var imageData=this.context.getImageData(0,0,this.canvas.width,this.canvas.height);new ColorMatrix(imageData.data).filter(filter,amount),this.context.putImageData(imageData,0,0)},grayscale:function(amount,save){this.context,this.canvas.width,this.canvas.height;this._filter(function(data){for(var i=0,len=data.length;i<len;i+=4){var v=.299*data[i]+.587*data[i+1]+.114*data[i+2];data[i]=v,data[i+1]=v,data[i+2]=v}})},sepia:function(amount,save){this.context,this.canvas.width,this.canvas.height;this._filter(function(data,start,end){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2];data[i]=.393*r+.769*g+.189*b,data[i+1]=.349*r+.686*g+.168*b,data[i+2]=.272*r+.534*g+.131*b}})},invert:function(amount,save){this.context,this.canvas.width,this.canvas.height;this._filter(function(data){for(var i=0,len=data.length;i<len;i+=4)data[i]=255-data[i],data[i+1]=255-data[i+1],data[i+2]=255-data[i+2]})},threshold:function(threshold,save){this.context,this.canvas.width,this.canvas.height;save&&this.save(),threshold=parseInt(threshold)||128,this._filter(function(data,start,end){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2],v=Math.round((r+g+b)/3)>=threshold?255:0;data[i]=v,data[i+1]=v,data[i+2]=v}},threshold)},brightness:function(amount,save){this.context,this.canvas.width,this.canvas.height;amount=Math.min(100,Math.max(-100,amount)),this._filter(function(data){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2];data[i]=Math.max(0,Math.min(255,Math.round(r+amount))),data[i+1]=Math.max(0,Math.min(255,Math.round(g+amount))),data[i+2]=Math.max(0,Math.min(255,Math.round(b+amount)))}})},contrast:function(amount,save){function n(x){return Math.max(0,Math.min(255,x))}this.context,this.canvas.width,this.canvas.height;amount=Math.max(-100,Math.min(100,amount));var factor=1;factor=amount>0?1+amount/100:(100-Math.abs(amount))/100,this._filter(function(data){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2];r=n(factor*(r-128)+128),g=n(factor*(g-128)+128),b=n(factor*(b-128)+128),data[i]=Math.min(255,Math.max(0,Math.round(r))),data[i+1]=Math.min(255,Math.max(0,Math.round(g))),data[i+2]=Math.min(255,Math.max(0,Math.round(b)))}})},saturate:function(amount,save){this.context,this.canvas.width,this.canvas.height;amount=parseFloat(amount)/100,amount=Math.max(-1,Math.min(1,amount)),this._filter(function(data){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2],average=(r+g+b)/3;r+=Math.round((r-average)*amount),g+=Math.round((g-average)*amount),b+=Math.round((b-average)*amount),data[i]=Math.min(255,Math.max(0,r)),data[i+1]=Math.min(255,Math.max(0,g)),data[i+2]=Math.min(255,Math.max(0,b))}})},desaturate:function(amount,save){return this.saturate(0-amount,save),this},hue:function(amount,save){this.context,this.canvas.width,this.canvas.height;return this._applyColorMatrixFilter("hue",amount),this},gamma:function(amount,save){return amount/=100,this._filter(function(data,start,end){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2];data[i]=255*Math.pow(r/255,1-amount),data[i+1]=255*Math.pow(g/255,1-amount),data[i+2]=255*Math.pow(b/255,1-amount)}}),this},exposure:function(amount,save){return amount/=10,this._filter(function(data,start,end){for(var i=0,len=data.length;i<len;i+=4){var r=data[i],g=data[i+1],b=data[i+2];data[i]=255*(1-Math.exp(-(r/255)*amount)),data[i+1]=255*(1-Math.exp(-(g/255)*amount)),data[i+2]=255*(1-Math.exp(-(b/255)*amount))}}),this},blur:function(amount,save){this.context,this.canvas.width,this.canvas.height;if(ImageFilter)return amount/=10,this._applyWebGlFilter("blur",amount);var matrix=[1/9,1/9,1/9,1/9,1/9,1/9,1/9,1/9,1/9];if(amount){amount=Math.floor(amount/10),amount=Math.max(1,amount);for(var i=0;i<amount;i++)this.convolution(matrix)}},sharpen:function(amount,save){if(ImageFilter)return amount/=100,this._applyWebGlFilter("sharpen",amount);var matrix=[0,-1,0,-1,5,-1,0,-1,0];if(amount){amount=Math.floor(amount/10),amount=Math.max(1,amount);for(var i=0;i<amount;i++)this.convolution(matrix)}},polaroid:function(save){if(ImageFilter)return this._applyWebGlFilter("polaroid")},vintage:function(save){if(ImageFilter)return this._applyWebGlFilter("vintagePinhole")},brownie:function(save){if(ImageFilter)return this._applyWebGlFilter("brownie")},kodachrome:function(save){if(ImageFilter)return this._applyWebGlFilter("kodachrome")},technicolor:function(save){if(ImageFilter)return this._applyWebGlFilter("technicolor")},convolution:function(matrix){for(var ctx=this.context,sw=this.canvas.width,sh=this.canvas.height,side=Math.round(Math.sqrt(matrix.length)),halfSide=Math.floor(side/2),w=sw,h=sh,input=ctx.getImageData(0,0,sw,sh),output=ctx.createImageData(sw,sh),src=input.data,dst=output.data,y=0;y<h;y++)for(var x=0;x<w;x++){for(var sy=y,sx=x,dstOff=4*(y*w+x),r=0,g=0,b=0,a=0,cy=0;cy<side;cy++)for(var cx=0;cx<side;cx++){var scy=sy+cy-halfSide,scx=sx+cx-halfSide;if(scy>=0&&scy<sh&&scx>=0&&scx<sw){var srcOff=4*(scy*sw+scx),wt=matrix[cy*side+cx];r+=src[srcOff]*wt,g+=src[srcOff+1]*wt,b+=src[srcOff+2]*wt,a+=src[srcOff+3]*wt}}dst[dstOff]=r,dst[dstOff+1]=g,dst[dstOff+2]=b,dst[dstOff+3]=a}ctx.putImageData(output,0,0)},_filter:function(fn,amount){function processNext(){var now,rect=rects[rectIndex++];rect&&(imageData=ctx.getImageData(rect.x,rect.y,rect.w,rect.h),fn(imageData.data),ctx.putImageData(imageData,rect.x,rect.y),now=(new Date).getTime(),now-lastTime<1e3?processNext():(lastTime=now,window.setTimeout(processNext,0)))}var rx,ry,imageData,lastTime,startTime,ctx=this.context,size=480,rects=[],rectIndex=0,x=0,y=0,w=this.canvas.width,h=this.canvas.height;for(ry=y;ry<h;ry+=size)for(rx=x;rx<w;rx+=size)rects.push({x:rx,y:ry,w:rx+size>w?w-rx:size,h:ry+size>h?h-ry:size});lastTime=startTime=(new Date).getTime(),processNext()}},window.Filter=Filter}(jQuery),function($,Wf){$.support.canvas=!!document.createElement("canvas").getContext,$.widget("ui.canvas",{stack:[],options:{onfilterstart:$.noop,onfilterprogress:$.noop},_create:function(){this.canvas=document.createElement("canvas"),this.context=this.canvas.getContext("2d"),this.draw()},getContext:function(){return this.context},getCanvas:function(){return this.canvas},setSize:function(w,h){$.extend(this.options,{width:w,height:h}),this.draw()},draw:function(el,w,h){el=el||$(this.element).get(0);var w=w||this.options.width||el.width,h=h||this.options.height||el.height;this.save(),$(this.canvas).attr({width:w,height:h}),this.context.drawImage(el,0,0,w,h)},free:function(n){n.getContext("2d").clearRect(0,0,0,0),$(n).remove()},clone:function(){return $(this.canvas).clone().get(0)},copy:function(){var copy=this.clone();return copy.getContext("2d").drawImage(this.canvas,0,0),copy},clear:function(){var ctx=this.context,w=$(this.element).width(),h=$(this.element).height();ctx&&ctx.clearRect(0,0,w,h)},resize:function(w,h,save){var ctx=this.context;w=parseInt(w),h=parseInt(h);this.canvas.width,this.canvas.height;if(ctx){save&&this.save(),ctx.imageSmoothingEnabled=ctx.mozImageSmoothingEnabled=ctx.webkitImageSmoothingEnabled=!0;var copy=this.copy();copy.getContext("2d").drawImage(this.canvas,0,0,w,h),$(this.canvas,copy).attr({width:w,height:h}),ctx.drawImage(copy,0,0),this.free(copy)}},crop:function(w,h,x,y,save){var ctx=this.context;if(w=parseInt(w),h=parseInt(h),x=parseInt(x),y=parseInt(y),ctx){save&&this.save(),x<0&&(x=0),x>this.canvas.width-1&&(x=this.canvas.width-1),y<0&&(y=0),y>this.canvas.height-1&&(y=this.canvas.height-1),w<1&&(w=1),x+w>this.canvas.width&&(w=this.canvas.width-x),h<1&&(h=1),y+h>this.canvas.height&&(h=this.canvas.height-y),ctx.imageSmoothingEnabled=ctx.mozImageSmoothingEnabled=ctx.webkitImageSmoothingEnabled=!0;var copy=this.copy();copy.getContext("2d").drawImage(this.canvas,0,0),$(this.canvas).attr({width:w,height:h}),ctx.drawImage(copy,x,y,w,h,0,0,w,h),this.free(copy)}},rotate:function(angle,save){var cw,ch,ctx=this.context,w=this.canvas.width,h=this.canvas.height;switch(angle<0&&(angle+=360),angle){case 90:case 270:cw=h,ch=w;break;case 180:cw=w,ch=h}if(ctx){save&&this.save();var copy=this.copy();$(this.canvas).attr({width:cw,height:ch}),ctx.translate(cw/2,ch/2),ctx.rotate(angle*Math.PI/180),ctx.drawImage(copy,-w/2,-h/2),this.free(copy)}},flip:function(axis,save){var ctx=this.context,w=this.canvas.width,h=this.canvas.height;if(ctx){save&&this.save();var copy=this.copy();copy.getContext("2d").drawImage(this.canvas,0,0,w,h,0,0,w,h),ctx.clearRect(0,0,w,h),$(this.canvas).attr({width:w,height:h}),"horizontal"==axis?(ctx.scale(-1,1),ctx.drawImage(copy,-w,0,w,h)):(ctx.scale(1,-1),ctx.drawImage(copy,0,-h,w,h)),this.free(copy)}},filter:function(filter,amount,save){save&&this.save(),new Filter(this.canvas).add(filter,amount).apply()},save:function(){var ctx=this.context,w=this.canvas.width,h=this.canvas.height;this.stack.push({width:w,height:h,data:ctx.getImageData(0,0,w,h)})},restore:function(){var ctx=this.context,img=$(this.element).get(0);ctx.restore(),ctx.drawImage(img,0,0)},undo:function(){var ctx=this.context,item=($(this.element).get(0),this.stack.pop());item&&($(this.canvas).attr({width:item.width,height:item.height}),item.data?ctx.putImageData(item.data,0,0):this.restore())},load:function(){var ctx=this.context,w=this.canvas.width,h=this.canvas.height,data=ctx.getImageData(0,0,w,h);ctx.clearRect(0,0,w,h),ctx.putImageData(data,0,0)},update:function(){this.load(),this.stack=[]},getMime:function(s){var mime="image/jpeg",ext=Wf.String.getExt(s);switch(ext){case"jpg":case"jpeg":mime="image/jpeg";break;case"png":mime="image/png";break;case"webp":mime="image/webp";break;case"bmp":mime="image/bmp"}return mime},resample:function(callback,nw,nh){var self=this,ctx=this.context,w=this.canvas.width,h=this.canvas.height,data1=ctx.getImageData(0,0,w,h),tmp=this.copy(),data2=tmp.getContext("2d").getImageData(0,0,w,h),worker=new Worker(Wf.getPath()+"/js/worker-hermite.js");Date.now();worker.onmessage=function(event){var out=event.data.data;self.clear(),self.context.putImageData(out,0,0),"function"==typeof callback&&callback()},worker.postMessage([data1,w,h,nw||w,nh||h,data2])},output:function(mime,quality,blob){function dataURItoBlob(dataURI,mime){var byteString,i,arrayBuffer,intArray;for(byteString=dataURI.split(",")[0].indexOf("base64")>=0?atob(dataURI.split(",")[1]):decodeURIComponent(dataURI.split(",")[1]),arrayBuffer=new ArrayBuffer(byteString.length),intArray=new Uint8Array(arrayBuffer),i=0;i<byteString.length;i+=1)intArray[i]=byteString.charCodeAt(i);return new Blob([arrayBuffer],{type:mime})}var self=this;return mime=mime||this.getMime($(this.element).get(0).src),quality=parseInt(quality)||100,quality=Math.max(Math.min(quality,100),10),quality/=100,this.load(),blob?dataURItoBlob(self.canvas.toDataURL(mime,quality),mime):self.canvas.toDataURL(mime,quality)},remove:function(){$(this.canvas).remove(),this.destroy()}})}(jQuery,Wf),function($,Wf){function uid(){var i,guid=(new Date).getTime().toString(32);for(i=0;i<5;i++)guid+=Math.floor(65535*Math.random()).toString(32);return"wf_"+guid+(counter++).toString(32)}function getRatio(o){function gcd(a,b){return 0==b?a:gcd(b,a%b)}var r=gcd(o.width,o.height);return o.width/r/(o.height/r)}function debounce(func,wait,immediate){var timeout;return function(){var context=this,args=arguments,later=function(){timeout=null,immediate||func.apply(context,args)},callNow=immediate&&!timeout;clearTimeout(timeout),timeout=setTimeout(later,wait),callNow&&func.apply(context,args)}}var $tmp=document.createElement("div"),prefixes=["-ms-","-moz-","-webkit-","-o-",""];$.support.Blob=!!window.Blob;var canvas=document.createElement("canvas");try{$.support.webgl=!(!canvas.getContext("webgl")&&!canvas.getContext("experimental-webgl"))}catch(e){$.support.webgl=!1}$.support.filter=function(){return!document.documentMode&&!window.opera&&($tmp.style.cssText=prefixes.join("filter:grayscale(1); "),!!$tmp.style.length)}(),$.fn.cssFilter=function(o){var prefixes=["","-moz-","-webkit-","-ms-",""],matrix=[],filter=o.filter||"",amount=o.amount||1;if(!filter)return this;switch(filter){case"desaturate":case"saturate":amount=(100+amount)/100,matrix[0]=.213+.787*amount,matrix[1]=.715-.715*amount,matrix[2]=1-(matrix[0]+matrix[1]),matrix[3]=matrix[4]=0,matrix[5]=.213-.213*amount,matrix[6]=.715+.285*amount,matrix[7]=1-(matrix[5]+matrix[6]),matrix[8]=matrix[9]=0,matrix[10]=.213-.213*amount,matrix[11]=.715-.715*amount,matrix[12]=1-(matrix[10]+matrix[11]),matrix[13]=matrix[14]=0,matrix[15]=matrix[16]=matrix[17]=matrix[19]=0,matrix[18]=1,filter="saturate";break;case"contrast":case"invert":case"grayscale":case"sepia":break;case"brightness":amount/=100,filter="brightness";break;case"blur":amount=amount/100+"px";break;case"sharpen":break;case"gamma":break;case"hue":amount+="deg",filter="hue-rotate"}return $(this).attr("style",prefixes.join("filter:"+filter+"("+amount+"); ")),this},$.fn.cssTransform=function(transform,amount){var keys=["transform","msTransform","Transform","WebkitTransform","OTransform"];return this.each(function(){var n=$(this).get(0);switch(transform){case"flip":transform="horizontal"==amount?"scaleX":"scaleY",amount=-1;break;case"rotate":amount+="deg"}$.each(keys,function(o,s){var transforms=n.style[s]||[];transforms.length&&(transforms=transforms.split(" ")),transforms.push(transform+"("+amount+")"),n.style[s]=transforms.join(" ")})}),this};var counter=0,ImageEditor={stack:[],fxstack:[],settings:{resize_quality:80,onsave:$.noop},_setLoader:function(){$('<div class="loading" />').appendTo("#editor-image"),$("canvas","#editor-image");this.working=!0},_removeLoader:function(){$("div.loading","#editor-image").remove(),this.working=!1},init:function(options){
var self=this;if(Wf.init(options),$("#editor").removeClass("offleft"),$(window).on("resize orientationchange",function(){self._resizeWin()}),this.src=tinyMCEPopup.getWindowArg("url"),!this._validatePath(this.src))return Wf.Modal.alert("Invalid image file"),!1;$.extend(this.settings,{width:tinyMCEPopup.getWindowArg("width"),height:tinyMCEPopup.getWindowArg("height"),onsave:tinyMCEPopup.getWindowArg("onsave")}),this._setLoader();var img="<img />";window.ActiveXObject&&(img=new Image),$(img).attr("src",this._loadImage(this.src)).one("load",function(){var n=this;$(n).data("width",n.width).data("height",n.height).appendTo("#editor-image"),$(n).canvas({width:n.width,height:n.height,onfilterprogress:function(e,n){1==n&&self._removeLoader()}});var canvas=$(n).canvas("getCanvas");$(canvas).insertAfter(n),self.position(),self._createToolBox(),self._createFX(),self._removeLoader()}).hide(),$("#transform_tab").accordion().on("accordion.activate",function(e,tab,panel){var action=$(tab).data("action");self.reset(!0),action&&self._initTransform(action)}).children(".uk-accordion-title").first().click,$("#tabs").tabs().on("tabs.activate",function(){self.reset(!0),self._resetFX()}),$("button.save").on("click",function(e){self.save(),e.preventDefault()}).prop("disabled",!0),$("button.revert").on("click",function(e){self.revert(e),e.preventDefault()}).prop("disabled",!0),$("button.undo").on("click",function(e){e.preventDefault(),self.undo(e)}).prop("disabled",!0),$("button.apply","#editor").on("click",function(e){e.preventDefault(),self._applyTransform($(this).data("function"))}),$("button.reset","#transform_tab").on("click",function(e){e.preventDefault(),self._resetTransform($(this).data("function"))}),$("#effects_apply").on("click",function(e){e.preventDefault(),self._resetFX(),$("img","#editor-image").canvas("update"),self.stack=[],$("button.undo").prop("disabled",!0)}),$("#effects_reset").on("click",function(e){e.preventDefault(),self._resetFX(),self.revert(e)})},_createToolBox:function(){var self=this,$img=$("img","#editor-image"),canvas=$img.canvas("getCanvas"),iw=canvas.width,ih=canvas.height;$(canvas).width(),$(canvas).height();$("#crop_presets option, #resize_presets option").each(function(){var v=$(this).val();if(v&&/[0-9]+x[0-9]+/.test(v)){v=v.split("x");var w=parseFloat(v[0]),h=parseFloat(v[1]);w>=$img.data("width")&&h>=$img.data("height")&&$(this).remove()}}),$("#resize_presets").on("change",function(){var v=($img.get(0),$(this).val());if(v){if(v.indexOf(":")!=-1){var r=v.split(":"),r1=parseInt($.trim(r[0])),r2=parseInt($.trim(r[1])),ratio=r1/r2;r2>r1&&(ratio=r2/r1),iw>ih&&r2>r1&&(ratio=r2/r1),w=Math.round(iw/ratio),h=Math.round(ih/ratio)}else{v=v.split("x");var w=parseFloat($.trim(v[0])),h=parseFloat($.trim(v[1]))}$("#resize_width").val(w).data("tmp",w),$("#resize_height").val(h).data("tmp",h);var ratio=!!$("#resize_constrain").prop("checked")&&w/h;$(canvas).resize("setRatio",ratio),$(canvas).resize("setSize",w,h)}}),$("option","#resize_presets").first().text(function(i,txt){return""+iw+" x "+ih+" ("+txt+")"}),$("#resize_width").val(iw).data("tmp",iw).on("change",function(){var w=$(this).val(),$height=$("#resize_height");if(w=w||$(this).data("tmp"),$("#resize_constrain").prop("checked")){var tw=$(this).data("tmp"),h=$height.val(),temp=(h/tw*w).toFixed(0);$height.val(temp).data("tmp",temp)}$(this).data("tmp",w),$(canvas).resize("setSize",w,$height.val())}),$("#resize_height").val(ih).data("tmp",ih).on("change",function(){var h=$(this).val(),$width=$("#resize_width");if(h=h||$(this).data("tmp"),$("#resize_constrain").prop("checked")){var th=$(this).data("tmp"),w=$width.val(),temp=(w/th*h).toFixed(0);$width.val(temp).data("tmp",temp)}$(this).data("tmp",h),$(canvas).resize("setSize",$width.val(),h)}),$("#resize_constrain").on("click",function(){var ratio=!!this.checked&&{width:$("#resize_width").val(),height:$("#resize_height").val()};$(canvas).resize("setConstrain",ratio)}),$("#crop_width").val(iw).data("tmp",iw).on("change",function(){var w=$(this).val(),h=$("#crop_height").val(),x=$("#crop_x").val(),y=$("#crop_y").val(),s={width:w,height:h,x:x,y:y},ratio=s.width/s.height;$("#crop_constrain").is(":checked")&&$(canvas).crop("setRatio",ratio),$("#crop_presets").val(w+"x"+h),$(canvas).crop("setArea",s)}),$("#crop_height").val(ih).data("tmp",ih).on("change",function(){var h=$(this).val(),w=$("#crop_width").val(),x=$("#crop_x").val(),y=$("#crop_y").val(),s={width:w,height:h,x:x,y:y},ratio=s.width/s.height;$("#crop_constrain").is(":checked")&&$(canvas).crop("setRatio",ratio),$("#crop_presets").val(w+"x"+h),$(canvas).crop("setArea",s)}),$("#crop_x").val(0).on("change",function(){var x=$(this).val(),w=$("#crop_width").val(),h=$("#crop_height").val(),y=$("#crop_y").val(),s={width:w,height:h,x:x,y:y},ratio=s.width/s.height;$("#crop_constrain").is(":checked")&&$(canvas).crop("setRatio",ratio),$(canvas).crop("setArea",s)}),$("#crop_y").val(0).on("change",function(){var y=$(this).val(),w=$("#crop_width").val(),h=$("#crop_height").val(),x=$("#crop_x").val(),s={width:w,height:h,x:x,y:y},ratio=s.width/s.height;$("#crop_constrain").is(":checked")&&$(canvas).crop("setRatio",ratio),$(canvas).crop("setArea",s)}),$("#crop_constrain").on("click",function(){$(this).toggleClass("checked"),$(this).is(":checked")?$("#crop_presets").trigger("change"):$(canvas).crop("setConstrain",!1)}),$("#crop_presets").on("change",function(){var img=$img.get(0),v=$(this).val();if(v){var s={width:img.width,height:img.height};if($.extend(s,$(canvas).crop("getArea")),v.indexOf(":")!=-1){var r=v.split(":"),r1=parseInt($.trim(r[0])),r2=parseInt($.trim(r[1])),ratio=r1/r2;r2>r1&&(ratio=r2/r1),s.width>s.height?(r2>r1&&(ratio=r2/r1),s.height=Math.round(s.width/ratio)):s.width=Math.round(s.height/ratio)}else{v=v.split("x"),s.width=parseInt($.trim(v[0])),s.height=parseInt($.trim(v[1]));var ratio=s.width/s.height}$("#crop_constrain").is(":checked")&&$(canvas).crop("setRatio",ratio),$(canvas).crop("setArea",s)}}),$("option","#crop_presets").first().text(function(i,txt){return""+iw+" x "+ih+" ("+txt+")"}).val(iw+"x"+ih),$("#transform-crop-cancel").on("click",function(){self.reset()}),$("#rotate-angle-clockwise").on("click",function(){self._applyTransform("rotate",90)}),$("#rotate-angle-anticlockwise").on("click",function(){self._applyTransform("rotate",-90)}),$("#rotate-flip-vertical").on("click",function(){self._applyTransform("flip","vertical")}),$("#rotate-flip-horizontal").on("click",function(){self._applyTransform("flip","horizontal")})},_createFX:function(){var self=this,$img=$("img","#editor-image");$("#editor_effects").empty();var debounceApply=debounce(function(fx,amount){self._applyFx(fx,amount)},500);if($.support.canvas){Wf.sizeToFit($img.get(0),{width:70,height:70});$.each({brightness:{factor:10,preview:150},contrast:{factor:10,preview:2},hue:{factor:1,preview:90,min:-180,max:180},saturation:{factor:10,preview:200,filter:"saturate",min:-10,max:10,step:1,value:0},sharpen:{factor:10,preview:70,min:0,webgl:!0},blur:{factor:10,preview:70,min:0,webgl:!0},gamma:{factor:1,preview:50,min:-100,max:100,value:0,step:1}},function(k,v){if(!v.webgl||$.support.webgl){var canvas,fx=$img.clone().addClass("uk-responsive-width").appendTo("#editor_effects").wrap('<div class="editor_effect uk-width-1-1 uk-grid uk-grid-small" />').wrap('<div class="editor_effect_preview uk-width-1-4 uk-float-left" />'),filter=v.filter||k;v=$.extend({step:1,min:-10,max:10,value:0},v),$.support.filter?($(fx).show().cssFilter({filter:filter,amount:v.preview}),canvas=fx):($(fx).canvas().canvas("filter",[filter,v.preview]),canvas=$(fx).canvas("getCanvas"),$(canvas).insertAfter(fx));var controls=$('<div class="uk-form-row uk-width-3-4 uk-float-left"><label class="uk-form-label uk-width-7-10 uk-text-left uk-text-bold">'+tinyMCEPopup.getLang("dlg.fx_"+k,k)+'</label><div class="uk-width-3-10"><input type="number" class="uk-width-1-1" value="" /></div><div class="uk-width-1-1 uk-margin-small-top"><input type="range" class="uk-width-1-1" value="" /></div></div>').insertAfter($(fx).parent());$('input[type="number"], input[type="range"]',controls).on("change",function(event){var x=parseInt(this.value);$("input",controls).not(this).val(x),debounceApply(filter,x*v.factor)}),$('input[type="range"]',controls).on("input",function(event){$('input[type="number"]',controls).val(parseInt(this.value))}),$.each(v,function(attr,value){"preview"!==attr&&"factor"!==attr&&"filter"!==attr&&$('input[type="number"], input[type="range"]',controls).attr(attr,value)})}}),$.each({grayscale:1,invert:1,sepia:1,polaroid:1,vintage:1,brownie:1,kodachrome:1,technicolor:1},function(k,v){if($.support.webgl||!/(polaroid|vintage|brownie|kodachrome|technicolor)/.test(k)){var canvas,fx=$img.clone().addClass("uk-responsive-width");fx.appendTo("#editor_effects").wrap('<div class="editor_effect uk-width-1-3 uk-flex uk-flex-column uk-margin-top" role="button" aria-label="'+tinyMCEPopup.getLang("dlg.fx_"+k,k)+'"></div>').after('<span class="uk-label uk-text-small">'+tinyMCEPopup.getLang("dlg.fx_"+k,k)+"</span>").wrap('<div class="editor_effect_preview" role="presentation" />'),fx.on("load",function(){$.support.filter&&$.inArray(k,["grayscale","invert","sepia"])>=0?($(fx).show().cssFilter({filter:k}),canvas=fx):($(fx).canvas(),$(fx).canvas("filter",k),canvas=$(fx).canvas("getCanvas"),$(canvas).insertAfter(fx)),$(canvas).on("click",function(){self._applyFx(k,v)})})}})}},_resetFX:function(){$('input[type="range"], input[type="number"]',"#editor_effects").val(0)},_resizeWin:function(){},_initTransform:function(fn){var img=$("img","#editor-image").get(0),canvas=$(img).canvas("getCanvas");switch(this.position(),fn){case"resize":$(canvas).resize({width:canvas.width,height:canvas.height,ratio:!!$("span.checkbox","#resize_constrain").is(".checked")&&getRatio(canvas),resize:function(e,size){$("#resize_width").val(size.width).data("tmp",size.width),$("#resize_height").val(size.height).data("tmp",size.height)},stop:function(){$("#resize_reset").prop("disabled",!1)}});break;case"crop":$(canvas).crop({width:canvas.width,height:canvas.height,ratio:!!$("#crop_constrain").is(":checked")&&getRatio(canvas),clone:$(img).canvas("copy"),start:function(){$("#crop_presets").val("")},stop:function(e,props){$("#crop_reset").prop("disabled",!1),$("#crop_presets").val(props.width+"x"+props.height)},change:function(e,props){$("#crop_width").val(props.width),$("#crop_height").val(props.height),$("#crop_x").val(props.x),$("#crop_y").val(props.y)}});break;case"rotate":}},_resetTransform:function(fn){var img=$("img","#editor-image").get(0),canvas=$(img).canvas("getCanvas"),w=canvas.width||$(canvas).width(),h=canvas.height||$(canvas).height();switch(fn){case"resize":this.position(),$.data(canvas,"uiResize")&&$(canvas).resize("reset"),$("#resize_reset").prop("disabled",!0),$("#resize_width").val(w).data("tmp",w),$("#resize_height").val(h).data("tmp",h),$("#resize_presets").val($("#resize_presets option:first").val());break;case"crop":$.data(canvas,"uiCrop")&&$(canvas).crop("reset"),$("#crop_reset").prop("disabled",!0),$("#crop_presets").val($("#crop_presets option:first").val()),$("#crop_width").val(w).data("tmp",w),$("#crop_height").val(h).data("tmp",h),$("#crop_x, #crop_y").val(0);break;case"rotate":}},updateCSSTransform:function(k,v){$("#rotate_angle img, #rotate_flip img, #editor_effects img, #editor_effects canvas").cssTransform(k,v)},undoCSSTransform:function(revert){var keys=["transform","msTransform","Transform","WebkitTransform","OTransform"];$("#rotate_angle img, #rotate_flip img").each(function(){var n=$(this).get(0);$.each(keys,function(i,s){var transforms=n.style[s]||[];transforms.length&&(transforms=transforms.split(" ")),revert?transforms=[transforms.shift()]:transforms.pop(),n.style[s]=transforms.join(" ")})}),$("#editor_effects img, #editor_effects canvas").each(function(){var n=$(this).get(0);$.each(keys,function(i,s){var transforms=n.style[s]||[];transforms.length&&(transforms=transforms.split(" ")),revert?transforms=[]:transforms.pop(),n.style[s]=transforms.join(" ")})})},undo:function(e){this.stack.pop(),$("img","#editor-image").canvas("undo"),this.stack.length||$("button.undo, button.revert, button.save").prop("disabled",!0),this.position(),e&&this._resetFX()},revert:function(e){var $img=$("img","#editor-image"),img=$img.get(0);$img.canvas("clear").canvas("draw",img,img.width,img.height),this.stack=[],$("button.undo, button.revert, button.save").prop("disabled",!0),e&&this._resetFX(),this.reset(!0)},reset:function(rw){var self=this,$img=$("img","#editor-image"),canvas=$img.canvas("getCanvas");$.each(["resize","crop","rotate"],function(i,fn){self._resetTransform(fn)}),rw&&($.data(canvas,"uiResize")&&$(canvas).resize("remove"),$.data(canvas,"uiCrop")&&$(canvas).crop("remove"),$.data(canvas,"uiRotate")&&$(canvas).rotate("remove")),this.position()},position:function(){var w,h,$img=$("img","#editor-image"),canvas=$img.canvas("getCanvas"),pw=$("#editor-image").width()-20,ph=$("#editor-image").height()-20,pct=10;$(canvas).css({width:"",height:""}),$(canvas).width()>pw&&(w=Math.round(pw-pw/100*pct),h=canvas.height*(w/canvas.width),$(canvas).width(w).height(h),pct+=10),$(canvas).height()>ph&&(h=ph-ph/100*pct,w=canvas.width*(h/canvas.height),$(canvas).height(h).width(w),pct+=10);var ch=$(canvas).height()||canvas.height;$(canvas).css({top:(ph-ch)/2})},_apply:function(k,v){function cleanTemp(src){Wf.JSON.request("cleanEditorTmp",{json:[src]})}var self=this,deferred=$.Deferred(),$img=$("img","#editor-image"),name=($img.canvas("getCanvas"),Wf.String.basename(self.src)),src=tinyMCEPopup.getWindowArg("src"),data=$img.canvas("output",self.getMime(name),100,!0);return self.sendBinary(data,{method:"applyImageEdit",id:uid(),params:[src,k,v]}).then(function(o){if(o.files){var img=new Image;img.onload=function(){return $img.canvas("draw",img,img.width,img.height),self.position(),self._removeLoader(),cleanTemp(src),deferred.resolve(),!0},img.onerror=function(){return self._removeLoader(),Wf.Modal.alert('Action "'+k+'" failed. Temp image could not be loaded.'),cleanTemp(src),deferred.reject(),!1};var tmp=o.files[0]||"";if(tmp=tmp.replace(/[^\w\.\-\/\\\\\s ]/gi,""),!tmp)return cleanTemp(src),!1;img.src=self._loadImage(Wf.String.path(Wf.getURI(),tmp))}}).fail(function(s){return s&&Wf.Modal.alert(s),deferred.reject(),cleanTemp(src),!1}).always(function(){self._removeLoader()}),deferred},_applyFx:function(){var self=this,length=this.stack.length,$img=$("img","#editor-image"),args=$.makeArray(arguments),filter=args.shift(),amount=args.shift();if(self._setLoader(),length){var last=this.stack[length-1];args&&last.task===filter&&this.undo()}self.addUndo({task:filter,args:amount}),$img.canvas("filter",filter,amount,!0),this._removeLoader(),$("button.undo, button.revert, button.save").prop("disabled",!1)},addUndo:function(data){this.stack.push(data)},_applyTransform:function(){function done(fn){$("button.undo, button.revert, button.save").prop("disabled",!1),self.reset(!0),self._initTransform(fn)}var self=this,$img=$("img","#editor-image"),canvas=$img.canvas("getCanvas"),args=$.makeArray(arguments),fn=args.shift(),amount=args.shift();switch(self._setLoader(),fn){case"resize":var w=$("#resize_width").val(),h=$("#resize_height").val();this._apply("resize",{width:w,height:h}).then(function(){args=[w,h],self.addUndo({task:fn,args:args})}).always(function(){done(fn)});break;case"crop":var s=$(canvas).crop("getArea");this._apply("crop",s).then(function(){args=[s.width,s.height,s.x,s.y],self.addUndo({task:fn,args:args})}).always(function(){done(fn)});break;case"rotate":$img.canvas("rotate",amount,!0),self.position(),self._removeLoader(),this.addUndo({task:fn,args:amount}),done(fn);break;case"flip":$img.canvas("flip",amount,!0),self.position(),self._removeLoader(),this.addUndo({task:fn,args:amount}),done(fn)}},getMime:function(s){var mime="image/jpeg",ext=Wf.String.getExt(s);switch(ext){case"jpg":case"jpeg":mime="image/jpeg";break;case"png":mime="image/png";break;case"webp":mime="image/webp";break;case"bmp":mime="image/bmp"}return mime},save:function(name){var self=this,$img=$("img","#editor-image"),extras=($img.canvas("getCanvas"),'<div class="uk-form-row uk-grid"><label for="image_quality" class="uk-form-label uk-width-3-10">'+tinyMCEPopup.getLang("dlg.quality","Quality")+'</label><div class="uk-form-controls uk-width-7-10 uk-margin-remove"><input type="range" min="1" max="100" id="image_quality_slider" value="100" class="uk-width-3-5" /><input type="number" id="image_quality" min="1" max="100" value="100" class="quality" /> %</div></div>'),name=Wf.String.basename(this.src);name=Wf.String.stripExt(name);var ext=Wf.String.getExt(this.src),options=FileBrowser.options;Wf.Modal.prompt(tinyMCEPopup.getLang("dlg.save_image","Save Image"),function(name){name=Wf.String.safe(name,options.websafe_mode,options.websafe_spaces,options.websafe_textcase);var quality=$("#image_quality").val()||100;self._setLoader(),name=name+"."+ext||Wf.String.basename(self.src);var src=tinyMCEPopup.getWindowArg("src");if($.support.Blob){var data=$img.canvas("output",self.getMime(name),quality,!0);data&&self.sendBinary(data,{method:"saveImageEdit",id:uid(),params:[src,name]}).then(function(o){if(o.files){if(self.src=o.files[0]||"",!self.src||!self._validatePath(self.src))return Wf.Modal.alert("Invalid image file"),!1;var img=new Image;img.onload=function(){$("img","#editor-image").attr("src",img.src).on("load",function(){self._createFX(),$(this).canvas("draw",img,img.width,img.height)})},img.src=self._loadImage(Wf.getURI()+self.src);var s=self.settings;s.onsave.apply(s.scope||self,[self.src]),self.stack=[],$("button.undo, button.revert, button.save").prop("disabled",!0)}}).fail(function(s){Wf.Modal.alert(s)}).always(function(){self._removeLoader()})}else{for(var stack=self.stack,args=[],i=0;i<stack.length;i++){var s=stack[i],n=args[args.length-1];n&&s.task===n.task&&1===s.args.length?n.args[0]+=s.args[0]:args.push(s)}Wf.JSON.request("saveImageEdit",{json:[src,name,args,quality]},cb)}},{text:tinyMCEPopup.getLang("dlg.name","Name"),elements:extras,height:240,value:name,open:function(){$("#dialog-prompt-input").parent().addClass("uk-form-icon uk-form-icon-flip").append('<span class="uk-text-muted uk-icon-none">.'+ext+"</span>"),$("#image_quality_slider").on("change",function(){$("#image_quality").val(this.value)}),$("#image_quality").on("change",function(){$("#image_quality_slider").val(this.value)})},validate:function(value){return!!value&&Wf.String.safe(value,options.websafe_mode,options.websafe_spaces,options.websafe_textcase)}})},sendBinary:function(data,json,cb){var ed=tinyMCEPopup.editor,deferred=$.Deferred(),url=document.location.href;url=url.replace(/&wf([a-z0-9]+)=1/,"");var args={context:ed.settings.context};args[ed.settings.token]="1";var fd=new FormData,xhr=new XMLHttpRequest;xhr.open("POST",url,!0),xhr.setRequestHeader("X-Requested-With","XMLHttpRequest"),xhr.onload=function(){var r={},error="An error occured processing this image.";if(data=fd=null,200==this.status)try{r=JSON.parse(this.response)}catch(e){return deferred.reject("The server returned an invalid JSON response."),!1}if($.isPlainObject(r)){if(r.error)return deferred.reject(r.error.message||error),!1;if(!r.result)return deferred.reject(error),!1;deferred.resolve(r.result)}else/[{}]/.test(r)&&(error="The server returned an invalid JSON response."),deferred.reject(error)},$.each(args,function(k,v){"string"==$.type(v)&&fd.append(k,v)}),fd.append("json",JSON.stringify(json));var name=Wf.String.basename(json.params[0]);return fd.append("file",data,name),xhr.send(fd),deferred},_validatePath:function(s){function _toUnicode(c){for(c=c.toString(16).toUpperCase();c.length<4;)c="0"+c;return"\\u"+c}if(/\.{2,}/.test(s)||/:\/\//.test(s)&&s.indexOf(Wf.getURI(!0))==-1)return!1;if(/:\/\//.test(s)&&(s=Wf.URL.toRelative(s)),/[^\w\.\-\s \/\\\\]/i.test(s))for(var i=0,ln=s.length;i<ln;i++){var ch=s[i];if(/[^\w\.\-\s \/\\\\]/i.test(ch)&&_toUnicode(ch.charCodeAt(0))<"\\u007F")return!1}return!0},_loadImage:function(src){return src+"?"+(new Date).getTime()}};window.ImageEditor=ImageEditor}(jQuery,Wf);