/**ABDB**/CREATE TABLE `#__wf_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `users` text NOT NULL,
  `types` text NOT NULL,
  `components` text NOT NULL,
  `area` tinyint(3) NOT NULL,
  `device` varchar(255) NOT NULL,
  `rows` text NOT NULL,
  `plugins` text NOT NULL,
  `published` tinyint(3) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` tinyint(3) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__wf_profiles`  VALUES 
('1', 'Default', 'Default Profile for all users', '', '6,7,3,4,5,8', '', '0', 'phone,tablet,desktop', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,blockquote,formatselect,styleselect,removeformat,cleanup;fontselect,fontsizeselect,forecolor,backcolor,spacer,clipboard,indent,outdent,lists,sub,sup,textcase,charmap,hr;directionality,fullscreen,preview,source,print,searchreplace,spacer,table;visualaid,visualchars,visualblocks,nonbreaking,style,xhtmlxtras,anchor,unlink,link,imgmanager,spellchecker,article', 'formatselect,styleselect,cleanup,fontselect,fontsizeselect,clipboard,lists,textcase,charmap,hr,directionality,fullscreen,print,searchreplace,table,visualchars,visualblocks,nonbreaking,style,xhtmlxtras,anchor,link,imgmanager,spellchecker,article,browser,contextmenu,inlinepopups,media,source', '1', '1', '0', '0000-00-00 00:00:00', '{\"source\":{\"theme\":\"monokai\",\"highlight\":\"1\"},\"editor\":{\"verify_html\":\"0\",\"allow_javascript\":\"1\",\"allow_css\":\"1\",\"allow_php\":\"1\",\"toolbar_theme\":\"default\"},\"media\":{\"iframes\":\"1\"}}'),
('2', 'Front End', 'Sample Front-end Profile', '', '3,4,5', '', '1', 'desktop,tablet,phone', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,formatselect,styleselect;clipboard,searchreplace,indent,outdent,lists,cleanup,charmap,removeformat,hr,sub,sup,textcase,nonbreaking,visualchars,visualblocks;fullscreen,preview,print,visualaid,style,xhtmlxtras,anchor,unlink,link,imgmanager,spellchecker,article', 'charmap,contextmenu,inlinepopups,help,clipboard,searchreplace,fullscreen,preview,print,style,textcase,nonbreaking,visualchars,visualblocks,xhtmlxtras,imgmanager,anchor,link,spellchecker,article,lists,formatselect,styleselect,hr', '0', '2', '0', '0000-00-00 00:00:00', '{\"editor\":{\"toolbar_theme\":\"default\"}}'),
('3', 'Blogger', 'Simple Blogging Profile', '', '3,4,5,6,8,7', '', '0', 'desktop,tablet,phone', 'bold,italic,strikethrough,lists,blockquote,spacer,justifyleft,justifycenter,justifyright,spacer,link,unlink,imgmanager,article,spellchecker,fullscreen,kitchensink;formatselect,styleselect,underline,justifyfull,clipboard,removeformat,charmap,indent,outdent,undo,redo,help', 'link,imgmanager,article,spellchecker,fullscreen,kitchensink,clipboard,contextmenu,inlinepopups,lists,formatselect,styleselect', '0', '3', '0', '0000-00-00 00:00:00', '{\"editor\":{\"toggle\":\"0\",\"toolbar_theme\":\"default\"}}'),
('4', 'Mobile', 'Sample Mobile Profile', '', '3,4,5,6,8,7', '', '0', 'tablet,phone', 'undo,redo,spacer,bold,italic,underline,formatselect,spacer,justifyleft,justifycenter,justifyfull,justifyright,spacer,fullscreen,kitchensink;styleselect,lists,spellchecker,article,link,unlink', 'fullscreen,kitchensink,spellchecker,article,link,inlinepopups,lists,formatselect,styleselect', '0', '4', '0', '0000-00-00 00:00:00', '{\"editor\":{\"toolbar_theme\":\"mobile\",\"resizing\":\"0\",\"resize_horizontal\":\"0\",\"resizing_use_cookie\":\"0\",\"toggle\":\"0\",\"links\":{\"popups\":{\"default\":\"\",\"jcemediabox\":{\"enable\":\"0\"},\"window\":{\"enable\":\"0\"}}}}}');
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__utf8_conversion`  VALUES 
('5');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('413', '42theme', '42theme', 'info@42theme.com', '$2y$10$yH9K2C61PwvmqyZbyFX7S.tgyTsPfGj1axSZ1coozzpiiFGCPh1Gi', '0', '1', '2016-08-21 13:01:10', '2021-02-15 18:44:08', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('414', 'admin', 'admin', 'admin@example.com', '$2y$10$RqOLtIeAS4Owu5WO7JzmUOPWnnoNeUG/12H8wHG4vkfxembd.X9/2', '0', '1', '2017-11-13 09:14:58', '2021-02-15 18:42:15', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('413', '8'),
('414', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('1', '3', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
('2', '3', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', ''),
('3', '3', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '3.9.22.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
('4', '3', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
('5', '3', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
('6', '3', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
('7', '3', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
('8', '3', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
('9', '3', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
('10', '3', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
('11', '3', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
('12', '3', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
('13', '3', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
('14', '3', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
('15', '3', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/ar-AA_details.xml', '', ''),
('16', '3', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
('17', '3', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
('18', '3', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
('19', '3', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
('20', '3', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
('21', '3', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
('22', '3', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
('23', '3', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
('24', '3', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
('25', '3', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
('26', '3', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
('27', '3', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
('28', '3', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
('29', '3', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.7.3.1', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
('30', '3', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', ''),
('31', '3', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
('32', '3', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '3.9.24.2', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
('33', '3', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
('34', '3', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
('35', '3', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
('36', '3', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
('37', '3', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
('38', '3', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
('39', '3', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
('40', '3', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
('41', '3', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
('42', '3', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
('43', '3', '0', 'Tamil', '', 'pkg_ta-IN', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
('44', '3', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
('45', '3', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '3.9.4.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
('46', '3', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
('47', '3', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
('48', '3', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
('49', '3', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
('50', '3', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
('51', '3', '0', 'German DE', '', 'pkg_de-DE', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
('52', '3', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
('53', '3', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
('54', '3', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '3.9.18.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
('55', '3', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
('56', '3', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
('57', '3', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
('58', '3', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
('59', '3', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
('60', '3', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', ''),
('61', '3', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
('62', '3', '0', 'English CA', '', 'pkg_en-CA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
('63', '3', '0', 'French CA', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
('64', '3', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
('65', '3', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
('66', '3', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
('67', '3', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
('68', '3', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
('69', '3', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
('70', '3', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
('71', '3', '0', 'Spanish CO', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
('72', '3', '0', 'German CH', '', 'pkg_de-CH', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
('73', '3', '0', 'German AT', '', 'pkg_de-AT', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
('74', '3', '0', 'German LI', '', 'pkg_de-LI', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
('75', '3', '0', 'German LU', '', 'pkg_de-LU', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
('76', '3', '0', 'English NZ', '', 'pkg_en-NZ', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
('77', '3', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', ''),
('78', '69', '0', 'Akeeba Frontend Framework (FEF)', '', 'file_fef', 'file', '', '1', '1.1.3', '', 'http://cdn.akeebabackup.com/updates/fef.xml', 'https://www.akeeba.com/download/fef/1-1-3.html', ''),
('79', '73', '0', 'FOF 3.x Stable', '', 'lib_fof30', 'library', '', '1', '3.7.3', '', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', 'https://www.akeeba.com/download/fof3/3-7-3.html', ''),
('81', '77', '0', 'Regular Labs - What? Nothing!', '', 'whatnothing', 'plugin', 'system', '0', '15.0.1FREE', '', 'https://download.regularlabs.com/updates.xml?e=XXX&type=.xml', 'https://www.regularlabs.com/extensions/whatnothing/features', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('3', '802'),
('4', '28'),
('49', '10000'),
('50', '10025'),
('51', '10152'),
('52', '10049'),
('53', '10033'),
('53', '10035'),
('53', '10329'),
('54', '10038'),
('55', '10028'),
('56', '10041'),
('57', '10017'),
('57', '10018'),
('57', '10322'),
('58', '10020'),
('58', '10021'),
('58', '10324'),
('59', '10030'),
('59', '10031'),
('60', '10153'),
('61', '10011'),
('61', '10319'),
('62', '10014'),
('69', '10286'),
('71', '10189'),
('72', '10316'),
('72', '10331'),
('73', '10339'),
('74', '10152'),
('75', '10202'),
('76', '10189'),
('77', '10028'),
('77', '10031'),
('77', '10038'),
('78', '10339'),
('79', '10286'),
('80', '10006'),
('81', '10152');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1613413813', ''),
('3', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', '1', '1613413813', ''),
('4', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1613413813', ''),
('49', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1613413814', ''),
('50', 'Regular Labs - Articles Anywhere', 'extension', 'https://download.regularlabs.com/updates.xml?e=articlesanywhere&type=.xml', '1', '1613413814', ''),
('52', 'Regular Labs - Dummy Content', 'extension', 'https://download.regularlabs.com/updates.xml?e=dummycontent&type=.xml', '1', '1613413814', ''),
('53', 'Regular Labs - Content Templater', 'extension', 'https://download.regularlabs.com/updates.xml?e=contenttemplater&type=.xml', '1', '1613413814', ''),
('54', 'Regular Labs - Modules Anywhere', 'extension', 'https://download.regularlabs.com/updates.xml?e=modulesanywhere&type=.xml', '1', '1613413815', ''),
('55', 'Regular Labs - Better Preview', 'extension', 'https://download.regularlabs.com/updates.xml?e=betterpreview&type=.xml', '1', '1613413815', ''),
('56', 'Regular Labs - Sourcerer', 'extension', 'https://download.regularlabs.com/updates.xml?e=sourcerer&type=.xml', '1', '1613413815', ''),
('57', 'Regular Labs - Advanced Module Manager', 'extension', 'https://download.regularlabs.com/updates.xml?e=advancedmodulemanager&type=.xml', '1', '1613413815', ''),
('58', 'Regular Labs - Advanced Template Manager', 'extension', 'https://download.regularlabs.com/updates.xml?e=advancedtemplatemanager&type=.xml', '1', '1613413815', ''),
('59', 'Regular Labs - Cache Cleaner', 'extension', 'https://download.regularlabs.com/updates.xml?e=cachecleaner&type=.xml', '1', '1613413816', ''),
('60', 'JoomShopping', 'extension', 'https://www.webdesigner-profi.de/joomla-webdesign/update/shop.xml', '1', '1613413816', ''),
('61', 'Regular Labs - Extension Manager', 'extension', 'https://download.regularlabs.com/updates.xml?e=extensionmanager&type=.xml', '1', '1613413816', ''),
('62', 'Regular Labs - Add to Menu', 'extension', 'https://download.regularlabs.com/updates.xml?e=addtomenu&type=.xml', '1', '1613413816', ''),
('69', 'Akeeba FEF', 'extension', 'http://cdn.akeebabackup.com/updates/fef.xml', '1', '1613413816', ''),
('72', 'Regular Labs - DB Replacer', 'extension', 'https://download.regularlabs.com/updates.xml?e=dbreplacer&type=.xml', '1', '1613413817', ''),
('73', 'FOF 3.x', 'extension', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', '1', '1613413817', ''),
('75', 'JCE Editor Package', 'extension', 'https://cdn.joomlacontenteditor.net/updates/xml/editor/pkg_jce_pro.xml', '1', '1613413818', ''),
('76', 'Quix Update Site', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=116', '0', '0', ''),
('77', 'Regular Labs - Better Preview', 'extension', 'https://download.regularlabs.com/updates.xml?e=XXX&type=.xml', '1', '1613413819', ''),
('78', 'FOF 3.x', 'extension', 'http://cdn.akeeba.com/updates/fof3_file.xml', '1', '1613413819', ''),
('79', 'Akeeba FEF', 'extension', 'http://cdn.akeeba.com/updates/fef.xml', '1', '1613413819', ''),
('80', 'Akeeba Backup Core', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebacore.xml', '1', '1613413819', ''),
('81', 'jQuery Easy auto updater', 'extension', 'https://updates.simplifyyourweb.com/free/jqueryeasy/jqueryeasy-v4-update.xml', '1', '1613414455', '');
/**ABDB**/CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB AUTO_INCREMENT=651 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_history`  VALUES 
('1', '8', '5', '', '2016-08-21 19:39:30', '413', '545', '28d5e64cf1ed018160a385b6108e1812501cf569', '{\"id\":8,\"asset_id\":79,\"parent_id\":\"1\",\"lft\":\"11\",\"rgt\":12,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Demo\",\"alias\":\"demo\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"413\",\"created_time\":\"2016-08-21 19:39:30\",\"modified_user_id\":null,\"modified_time\":\"2016-08-21 19:39:30\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('4', '2', '1', '', '2016-08-21 19:48:35', '413', '5119', '27d3414307330ca621554cf965db9c8561972d44', '{\"id\":2,\"asset_id\":81,\"title\":\"Layouts\",\"alias\":\"layouts\",\"introtext\":\"<p>Posuere nisi per ante lorem nulla nostra malesuada lacus nostra aptent mattis porta fusce massa class consectetur nisl. Quisque inceptos per gravida nam tempus inceptos interdum turpis netus curabitur est. Ultrices primis ad himenaeos dapibus, urna condimentum posuere ullamcorper vehicula augue ante urna fermentum aenean! Lorem vel suspendisse viverra sagittis gravida odio sed amet phasellus fermentum.<\\/p>\\r\\n<p>Aenean primis, dapibus curae curae ante, eros pharetra donec sem viverra elit tempus. Lacinia venenatis ac elementum eros mollis congue.<\\/p>\\r\\n<p>Tincidunt donec aliquet litora netus nostra, integer pulvinar nunc ultrices urna posuere a nisl lacinia; Sociosqu fermentum felis ligula cursus est etiam libero fermentum litora pharetra potenti tortor.<\\/p>\\r\\n<p>Est semper mauris ligula cursus vulputate. Integer fusce, tellus nisl augue condimentum, nisi neque ornare. Nisi luctus interdum nisi pulvinar donec, at imperdiet congue inceptos sollicitudin magna feugiat massa. Porta phasellus a iaculis, elit sociosqu tortor pharetra. Donec tempor nam inceptos, augue malesuada proin, gravida orci imperdiet elementum vestibulum vel vestibulum hendrerit. Scelerisque maecenas lacinia porttitor ipsum consectetur laoreet, urna adipiscing consequat aliquet class praesent integer eros netus dui hendrerit. Scelerisque ad pellentesque rhoncus, nisl metus congue semper, dui sagittis inceptos imperdiet duis curae. Litora pulvinar ultricies class aptent amet varius condimentum nulla sollicitudin.<\\/p>\\r\\n<p>Felis ullamcorper porttitor habitasse placerat eleifend viverra nullam; Blandit congue lorem lacus curabitur sit volutpat eleifend condimentum sit dapibus vitae ullamcorper. Dapibus interdum hac sapien curabitur sagittis metus risus dolor morbi vel auctor conubia torquent commodo eu nostra tristique; Senectus placerat rhoncus tellus ut nostra, amet vitae donec elementum urna justo leo congue turpis. Quam lorem himenaeos sodales potenti nostra amet, justo hac ullamcorper nisi pharetra scelerisque neque mauris. Erat phasellus, in neque torquent nulla, sociosqu scelerisque magna netus urna. Tincidunt duis fusce blandit duis laoreet risus felis viverra bibendum elementum nunc volutpat consequat in.<\\/p>\\r\\n<p>Libero fermentum ac egestas massa curae porttitor non risus tempus tincidunt. Et duis eu sapien etiam non ut tincidunt tempor curae volutpat porta. Enim vitae dui, tempor non iaculis, imperdiet nibh dui ante praesent primis! Dictumst nulla convallis mauris, ipsum quisque hac class nullam ac. Quisque pulvinar sociosqu phasellus cras nunc morbi vestibulum primis lacinia litora aliquam aenean est mattis ligula vel fusce dictumst.<\\/p>\\r\\n<p>Phasellus scelerisque, nam tortor fringilla et, sociosqu convallis faucibus sociosqu. Fusce cubilia leo bibendum leo libero fames himenaeos, suspendisse laoreet dapibus proin odio odio nulla tristique hendrerit litora in.<\\/p>\\r\\n<p>Nunc turpis scelerisque lacus sapien sollicitudin pellentesque in nulla ac; Nunc vehicula, cursus eros magna vulputate, phasellus suspendisse elementum accumsan sed lobortis odio neque. Nulla amet id lacinia sapien, malesuada mollis egestas litora class conubia suscipit vehicula imperdiet auctor nam pellentesque. Maecenas eu praesent lacus arcu sed imperdiet hac habitant vitae et tempor. Nunc et taciti fermentum morbi nibh rhoncus, litora convallis venenatis sollicitudin ullamcorper. Nullam id hac fames malesuada.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2016-08-21 19:48:35\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":2,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('5', '9', '5', '', '2017-01-05 18:59:13', '413', '560', 'a60ded25a3f101cc9ec6d0648c8ea5b84b3e8124', '{\"id\":9,\"asset_id\":137,\"parent_id\":\"8\",\"lft\":\"12\",\"rgt\":13,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Home slider\",\"alias\":\"home-slider\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"413\",\"created_time\":\"2017-01-05 18:59:13\",\"modified_user_id\":null,\"modified_time\":\"2017-01-05 18:59:13\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('9', '10', '5', '', '2017-01-05 19:24:10', '413', '547', '11263d9f8c4a2f5a8c6cf2075ed8dd8333f51e59', '{\"id\":10,\"asset_id\":152,\"parent_id\":\"8\",\"lft\":\"14\",\"rgt\":15,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Blog\",\"alias\":\"blog\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"413\",\"created_time\":\"2017-01-05 19:24:10\",\"modified_user_id\":null,\"modified_time\":\"2017-01-05 19:24:10\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('36', '9', '5', '', '2017-01-09 14:56:53', '413', '599', '3adbe356a845ecab41e017b9a072d6a4a2ec5440', '{\"id\":9,\"asset_id\":\"137\",\"parent_id\":\"8\",\"lft\":\"12\",\"rgt\":\"13\",\"level\":\"2\",\"path\":\"demo\\/home-slider\",\"extension\":\"com_content\",\"title\":\"Home Slider\",\"alias\":\"home-slider\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-01-09 14:56:48\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"413\",\"created_time\":\"2017-01-05 18:59:13\",\"modified_user_id\":\"413\",\"modified_time\":\"2017-01-09 14:56:53\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}', '0'),
('180', '30', '1', '', '2017-01-25 18:30:06', '413', '1947', 'c20c83af8d27252ef86f809efb87ebe65b30094e', '{\"id\":30,\"asset_id\":321,\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"http:\\/\\/www.youtube.com\\/embed\\/PnICxgGHXno?autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-25 18:30:06\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('181', '30', '1', '', '2017-01-25 18:31:12', '413', '1968', '73c00b4b20691c77112f128264568bc3086f4f90', '{\"id\":\"30\",\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"http:\\/\\/www.youtube.com\\/embed\\/PnICxgGHXno?autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-25 18:31:12\",\"modified_by\":\"413\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":3,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('190', '30', '1', '', '2017-01-27 18:02:42', '413', '1967', '6fafd9e62128ef87701246a7e243aafe5f43b6da', '{\"id\":30,\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"https:\\/\\/www.youtube.com\\/embed\\/2YBtspm8j8M?autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-27 18:02:42\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-01-27 18:02:22\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('191', '30', '1', '', '2017-01-27 18:03:38', '413', '1971', '26fe9884e8d505edb8652eaa449124d478eb988a', '{\"id\":30,\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"https:\\/\\/www.youtube.com\\/embed\\/2YBtspm8j8M?t=9&autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-27 18:03:38\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-01-27 18:02:42\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('192', '30', '1', '', '2017-01-27 18:05:23', '413', '1971', '326cbf3271aa8bdb76d2685842c214b5c963ec0e', '{\"id\":30,\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"https:\\/\\/www.youtube.com\\/embed\\/2YBtspm8j8M?t=9&autoplay=1&loop=1&controls=1&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-27 18:05:23\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-01-27 18:04:59\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('193', '30', '1', '', '2017-01-27 18:06:32', '413', '1968', 'df293bc3363f28bb801b3040d7da1cf439cbf677', '{\"id\":30,\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"https:\\/\\/www.youtube.com\\/embed\\/2YBtspm8j8M?&autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-01-27 18:06:32\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-01-27 18:06:18\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('230', '30', '1', '', '2017-02-04 15:19:08', '413', '1968', '8b162aef0d88c85392f9bb8fc5cac55f15b624ef', '{\"id\":30,\"asset_id\":\"321\",\"title\":\"Video Slide\",\"alias\":\"video-slide\",\"introtext\":\"<iframe src=\\\"https:\\/\\/www.youtube.com\\/embed\\/YLN1Argi7ik?&autoplay=1&loop=1&controls=0&showinfo=0&start=0&playlist=FoRmhWxmj70&wmode=transparent&vq=hd1080\\\"\\r\\n        width=\\\"480\\\" \\r\\n        height=\\\"270\\\"\\r\\n        allowfullscreen >\\r\\n<\\/iframe>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-25 18:30:06\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-02-04 15:19:08\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-02-04 15:18:57\",\"publish_up\":\"2017-01-25 18:30:06\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('304', '41', '1', '', '2017-07-18 15:35:26', '413', '2156', '996e15080ad6e654d515712d81b9ca825d07e677', '{\"id\":41,\"asset_id\":\"396\",\"title\":\"Welcome to Acamar\",\"alias\":\"welcome-to-acamar\",\"introtext\":\"<img src=\\\"images\\/visuals\\/slider\\/slide-1_.jpg\\\" alt=\\\"Welcome to Acamar!\\\" \\/>\\r\\n<div class=\\\"uk-overlay-panel uk-overlay-fade uk-flex uk-flex-center uk-flex-middle\\\">\\r\\n  \\t<div class=\\\"uk-text-center t42-slide-1\\\">\\r\\n    \\t<p>Welcome to<\\/p>\\r\\n      \\t<p><img src=\\\"images\\/visuals\\/logo.svg\\\" alt=\\\"Acamar Logo\\\" data-uk-svg=\\\"\\\" \\/><\\/p>\\r\\n  \\t<\\/div>\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-05 18:59:39\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-07-18 15:35:26\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-07-18 15:33:58\",\"publish_up\":\"2017-01-05 18:59:39\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":24,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('305', '41', '1', '', '2017-07-18 15:35:44', '413', '2158', '3fed820f6fbadfac021e4d77097949847d7b2ee9', '{\"id\":41,\"asset_id\":\"396\",\"title\":\"Welcome to Acamar\",\"alias\":\"welcome-to-acamar\",\"introtext\":\"<img src=\\\"images\\/visuals\\/slider\\/slide-1_.jpg\\\" alt=\\\"Welcome to Acamar!\\\" \\/>\\r\\n<div class=\\\"uk-overlay-panel uk-overlay-fade uk-flex uk-flex-center uk-flex-middle\\\">\\r\\n  \\t<div class=\\\"uk-text-center t42-slide-1\\\">\\r\\n    \\t<h4>Welcome to<\\/h4>\\r\\n      \\t<p><img src=\\\"images\\/visuals\\/logo.svg\\\" alt=\\\"Acamar Logo\\\" data-uk-svg=\\\"\\\" \\/><\\/p>\\r\\n  \\t<\\/div>\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-05 18:59:39\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-07-18 15:35:44\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-07-18 15:35:26\",\"publish_up\":\"2017-01-05 18:59:39\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":25,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('306', '41', '1', '', '2017-07-18 15:36:13', '413', '2158', 'b7f6e6da232ae6e9a7f625fda0d83db75a626604', '{\"id\":41,\"asset_id\":\"396\",\"title\":\"Welcome to Acamar\",\"alias\":\"welcome-to-acamar\",\"introtext\":\"<img src=\\\"images\\/visuals\\/slider\\/slide-1_.jpg\\\" alt=\\\"Welcome to Acamar!\\\" \\/>\\r\\n<div class=\\\"uk-overlay-panel uk-overlay-fade uk-flex uk-flex-center uk-flex-middle\\\">\\r\\n  \\t<div class=\\\"uk-text-center t42-slide-1\\\">\\r\\n    \\t<h3>Welcome to<\\/h3>\\r\\n      \\t<p><img src=\\\"images\\/visuals\\/logo.svg\\\" alt=\\\"Acamar Logo\\\" data-uk-svg=\\\"\\\" \\/><\\/p>\\r\\n  \\t<\\/div>\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"9\",\"created\":\"2017-01-05 18:59:39\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-07-18 15:36:13\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-07-18 15:35:44\",\"publish_up\":\"2017-01-05 18:59:39\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":26,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('323', '41', '1', '', '2017-08-21 08:44:30', '413', '2160', '23d8e16c9cefbdf470925d5c5f4c61e03315e21b', '{\"id\":\"41\",\"asset_id\":\"396\",\"title\":\"Welcome to Acamar\",\"alias\":\"welcome-to-acamar\",\"introtext\":\"<img src=\\\"images\\/visuals\\/slider\\/slide-1_.jpg\\\" alt=\\\"Welcome to Acamar!\\\" \\/>\\r\\n<div class=\\\"uk-overlay-panel uk-overlay-fade uk-flex uk-flex-center uk-flex-middle\\\">\\r\\n  \\t<div class=\\\"uk-text-center t42-slide-1\\\">\\r\\n    \\t<h3>Welcome to<\\/h3>\\r\\n      \\t<p><img src=\\\"images\\/visuals\\/logo.svg\\\" alt=\\\"Acamar Logo\\\" data-uk-svg=\\\"\\\" \\/><\\/p>\\r\\n  \\t<\\/div>\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":\"9\",\"created\":\"2017-01-05 18:59:39\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-08-21 08:44:30\",\"modified_by\":\"413\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2017-01-05 18:59:39\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":\"26\",\"ordering\":2,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('406', '2', '8', '', '2017-09-12 15:13:48', '413', '554', 'cea71175fd375e0d32e753d4064dbeda97a9fe30', '{\"id\":2,\"parent_id\":\"1\",\"lft\":\"1\",\"rgt\":2,\"level\":1,\"path\":\"joomla\",\"title\":\"Joomla\",\"alias\":\"joomla\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('407', '3', '8', '', '2017-09-12 15:13:48', '413', '548', 'e9d0b364162aa20c37fa8783531f5df55c5a44c9', '{\"id\":3,\"parent_id\":\"1\",\"lft\":\"3\",\"rgt\":4,\"level\":1,\"path\":\"site\",\"title\":\"Site\",\"alias\":\"site\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('408', '4', '8', '', '2017-09-12 15:13:48', '413', '563', 'a48d79189ff9b98b24e38785126b0b51b6265ac7', '{\"id\":4,\"parent_id\":\"1\",\"lft\":\"5\",\"rgt\":6,\"level\":1,\"path\":\"portfolio\",\"title\":\"Portfolio\",\"alias\":\"portfolio\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('410', '6', '8', '', '2017-09-12 15:13:48', '413', '558', '87c0813e8b69e889416d04f41b0a3e206d3fe835', '{\"id\":6,\"parent_id\":\"1\",\"lft\":\"9\",\"rgt\":10,\"level\":1,\"path\":\"42theme\",\"title\":\"42Theme\",\"alias\":\"42theme\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('411', '7', '8', '', '2017-09-12 15:13:48', '413', '547', '2b578af70b7c0a0a1f9ea9ecff4ad438b9ea1d71', '{\"id\":7,\"parent_id\":\"1\",\"lft\":\"11\",\"rgt\":12,\"level\":1,\"path\":\"web\",\"title\":\"Web\",\"alias\":\"web\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('412', '8', '8', '', '2017-09-12 15:13:48', '413', '556', 'f3b3182a62d79932a0fe2a3074243aa08fca5e80', '{\"id\":8,\"parent_id\":\"1\",\"lft\":\"13\",\"rgt\":14,\"level\":1,\"path\":\"design\",\"title\":\"Design\",\"alias\":\"design\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('413', '9', '8', '', '2017-09-12 15:13:48', '413', '553', '1a3d7d177b43a363bf3a2a68904b74a1f2f7e723', '{\"id\":9,\"parent_id\":\"1\",\"lft\":\"15\",\"rgt\":16,\"level\":1,\"path\":\"promo\",\"title\":\"Promo\",\"alias\":\"promo\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2017-09-12 15:13:48\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"413\",\"created_time\":\"2017-09-12 15:13:48\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2017-09-12 15:13:48\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2017-09-12 15:13:48\",\"publish_down\":\"2017-09-12 15:13:48\"}', '0'),
('417', '58', '1', '', '2017-09-12 15:45:36', '413', '34063', '929378d733deb309b0b249e8bffadf717afb901b', '{\"id\":58,\"asset_id\":486,\"title\":\"All HTML elements\",\"alias\":\"all-html-elements\",\"introtext\":\" <div class=\\\"uk-grid\\\">\\r\\n            <div class=\\\"uk-width-1-1\\\" data-uk-margin>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button\\\">Button<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-width-2\\\">\\r\\n\\r\\n                            <div class=\\\"uk-grid uk-dropdown-grid\\\">\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-primary\\\">Primary<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-primary\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-small\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-success\\\">Success<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-success\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-danger\\\">Danger<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-danger\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <button class=\\\"uk-button\\\" disabled>Disabled<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-tooltip title=\\\"Bazinga!\\\">Tooltip<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-modal=\\\"{target:\'#modal-1\'}\\\">Modal<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-offcanvas=\\\"{target:\'#offcanvas-1\'}\\\">Off-canvas<\\/button>\\r\\n                <button class=\\\"uk-button uk-button-link\\\">Button link<\\/button>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-breadcrumb\\\">\\r\\n                            <li><a href=\\\"#\\\">Home<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Blog<\\/a><\\/li>\\r\\n                            <li><span>Category<\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>Post<\\/span><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n\\r\\n                        <article class=\\\"uk-article\\\">\\r\\n\\r\\n                            <h1 class=\\\"uk-article-title\\\">Article title<\\/h1>\\r\\n\\r\\n                            <p class=\\\"uk-article-meta\\\">Written by Super User on 12 April. Posted in Blog<\\/p>\\r\\n\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-icon uk-overlay-background uk-overlay-fade\\\"><\\/div>\\r\\n                                        <\\/div>\\r\\n                                        <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-bottom uk-overlay-background uk-overlay-fade\\\">Caption<\\/div>\\r\\n                                        <\\/div>\\r\\n                                    <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n\\r\\n                            <p class=\\\"uk-article-lead\\\">Lorem ipsum dolor sit amet.<\\/p>\\r\\n                            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                            <pre><code>&lt;div class=\\\"myclass\\\"&gt;...&lt;\\/div&gt;<\\/code><\\/pre>\\r\\n                            <hr class=\\\"uk-article-divider\\\">\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-5\\\">\\r\\n                                    <span class=\\\"uk-text-muted\\\">text-muted<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-primary\\\">text-primary<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-success\\\">text-success<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-warning\\\">text-warning<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-danger\\\">text-danger<\\/span>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-3-10\\\">\\r\\n                                    <a href=\\\"#\\\">a element<\\/a><br>\\r\\n                                    <em>em element<\\/em><br>\\r\\n                                    <strong>strong<\\/strong><br>\\r\\n                                    <code>code element<\\/code><br>\\r\\n                                    <del>del element<\\/del>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-2-5\\\">\\r\\n                                    <ins>ins element<\\/ins><br>\\r\\n                                    <mark>mark element<\\/mark><br>\\r\\n                                    <q>q <q>inside<\\/q> a q element <\\/q><br>\\r\\n                                    <abbr title=\\\"Abbreviation Element\\\">abbr element<\\/abbr><br>\\r\\n                                    <dfn title=\\\"Defines a definition term\\\">dfn element<\\/dfn>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-1\\\">\\r\\n                                    <p class=\\\"uk-text-center\\\">\\r\\n                                        <span class=\\\"uk-badge\\\">Badge<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-notification\\\">1<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success\\\">Success<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success uk-badge-notification\\\">4<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning\\\">Warning<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning uk-badge-notification\\\">3<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger\\\">Danger<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger uk-badge-notification\\\">4<\\/span>\\r\\n                                    <\\/p>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <h1 class=\\\"uk-display-inline\\\">h1<\\/h1>\\r\\n                                    <h2 class=\\\"uk-display-inline\\\">h2<\\/h2>\\r\\n                                    <h3 class=\\\"uk-display-inline\\\">h3<\\/h3>\\r\\n                                    <h4 class=\\\"uk-display-inline\\\">h4<\\/h4>\\r\\n                                    <h5 class=\\\"uk-display-inline\\\">h5<\\/h5>\\r\\n                                    <h6 class=\\\"uk-display-inline\\\">h6<\\/h6>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <blockquote>\\r\\n                                        <p> Lorem ipsum dolor.<\\/p>\\r\\n                                        <small>Someone famous<\\/small>\\r\\n                                    <\\/blockquote>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/article>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-comment-list\\\">\\r\\n                            <li>\\r\\n                                <article class=\\\"uk-comment\\\">\\r\\n                                    <header class=\\\"uk-comment-header\\\">\\r\\n                                        <img class=\\\"uk-comment-avatar\\\" src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_avatar.svg\\\" width=\\\"50\\\" height=\\\"50\\\" alt=\\\"\\\">\\r\\n                                        <h4 class=\\\"uk-comment-title\\\">Author<\\/h4>\\r\\n                                        <p class=\\\"uk-comment-meta\\\">May 2, 2090 at 1:55 pm<\\/p>\\r\\n                                    <\\/header>\\r\\n                                    <div class=\\\"uk-comment-body\\\">\\r\\n                                        <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna.<\\/p>\\r\\n                                    <\\/div>\\r\\n                                <\\/article>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-pagination\\\">\\r\\n                            <li class=\\\"uk-disabled\\\"><span><i class=\\\"uk-icon-angle-double-left\\\"><\\/i><\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>1<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">2<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">3<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">4<\\/a><\\/li>\\r\\n                            <li><span>...<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">20<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\"><i class=\\\"uk-icon-angle-double-right\\\"><\\/i><\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-side uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-divider\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Divider<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-header\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Header<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-primary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box primary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-secondary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box secondary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Info message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-success\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Success message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-warning\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Warning message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-danger\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Danger message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-success\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-warning\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-danger\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form states<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"Text Input\\\" class=\\\"uk-width-1-1\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-success\\\" value=\\\"form-success\\\" class=\\\"uk-width-1-1 uk-form-success\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-danger\\\" value=\\\"form-danger\\\" class=\\\"uk-width-1-1 uk-form-danger\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form disabled\\\" class=\\\"uk-width-1-1\\\" disabled>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form styles<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-large\\\" class=\\\"uk-form-large uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-large\\\" type=\\\"reset\\\">Large<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-small\\\" class=\\\"uk-form-small uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-small\\\" type=\\\"reset\\\">Small<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-blank\\\" class=\\\"uk-form-width-small uk-form-blank\\\">\\r\\n                                <button class=\\\"uk-button uk-button-mini\\\" type=\\\"reset\\\">Mini<\\/button>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-line\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-pill\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-tab\\\" data-uk-tab>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-github\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-twitter\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-dribbble\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-html5\\\"><\\/a>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid uk-grid-divider\\\" data-uk-grid-margin>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-line\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-striped\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <table class=\\\"uk-table uk-table-striped uk-table-condensed uk-table-hover\\\">\\r\\n                    <caption>Table caption<\\/caption>\\r\\n                    <thead>\\r\\n                        <tr>\\r\\n                            <th>Table<\\/th>\\r\\n                            <th>Heading<\\/th>\\r\\n                        <\\/tr>\\r\\n                    <\\/thead>\\r\\n                    <tbody>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                    <\\/tbody>\\r\\n                <\\/table>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <dl class=\\\"uk-description-list uk-description-list-line\\\">\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                <\\/dl>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"offcanvas-1\\\" class=\\\"uk-offcanvas\\\">\\r\\n            <div class=\\\"uk-offcanvas-bar\\\">\\r\\n\\r\\n                <ul class=\\\"uk-nav uk-nav-offcanvas uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                <ul>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                <\\/ul>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-star\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-twitter\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-rss\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"modal-1\\\" class=\\\"uk-modal\\\">\\r\\n            <div class=\\\"uk-modal-dialog\\\">\\r\\n                <button type=\\\"button\\\" class=\\\"uk-modal-close uk-close\\\"><\\/button>\\r\\n                <h1>Headline<\\/h1>\\r\\n                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\/p>\\r\\n            <\\/div>\\r\\n        <\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-09-12 15:45:36\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-12 15:45:36\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2017-09-12 15:45:36\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('419', '58', '1', '', '2017-09-12 15:47:35', '413', '34074', '88ac31bc70ad45a0d31951b109e8a5bb4b0aec5a', '{\"id\":58,\"asset_id\":\"486\",\"title\":\"HTML elements\",\"alias\":\"html-elements\",\"introtext\":\" <div class=\\\"uk-grid\\\">\\r\\n            <div class=\\\"uk-width-1-1\\\" data-uk-margin>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button\\\">Button<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-width-2\\\">\\r\\n\\r\\n                            <div class=\\\"uk-grid uk-dropdown-grid\\\">\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-primary\\\">Primary<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-primary\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-small\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-success\\\">Success<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-success\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-danger\\\">Danger<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-danger\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <button class=\\\"uk-button\\\" disabled>Disabled<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-tooltip title=\\\"Bazinga!\\\">Tooltip<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-modal=\\\"{target:\'#modal-1\'}\\\">Modal<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-offcanvas=\\\"{target:\'#offcanvas-1\'}\\\">Off-canvas<\\/button>\\r\\n                <button class=\\\"uk-button uk-button-link\\\">Button link<\\/button>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-breadcrumb\\\">\\r\\n                            <li><a href=\\\"#\\\">Home<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Blog<\\/a><\\/li>\\r\\n                            <li><span>Category<\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>Post<\\/span><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n\\r\\n                        <article class=\\\"uk-article\\\">\\r\\n\\r\\n                            <h1 class=\\\"uk-article-title\\\">Article title<\\/h1>\\r\\n\\r\\n                            <p class=\\\"uk-article-meta\\\">Written by Super User on 12 April. Posted in Blog<\\/p>\\r\\n\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-icon uk-overlay-background uk-overlay-fade\\\"><\\/div>\\r\\n                                        <\\/div>\\r\\n                                        <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-bottom uk-overlay-background uk-overlay-fade\\\">Caption<\\/div>\\r\\n                                        <\\/div>\\r\\n                                    <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n\\r\\n                            <p class=\\\"uk-article-lead\\\">Lorem ipsum dolor sit amet.<\\/p>\\r\\n                            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                            <pre><code>&lt;div class=\\\"myclass\\\"&gt;...&lt;\\/div&gt;<\\/code><\\/pre>\\r\\n                            <hr class=\\\"uk-article-divider\\\">\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-5\\\">\\r\\n                                    <span class=\\\"uk-text-muted\\\">text-muted<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-primary\\\">text-primary<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-success\\\">text-success<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-warning\\\">text-warning<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-danger\\\">text-danger<\\/span>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-3-10\\\">\\r\\n                                    <a href=\\\"#\\\">a element<\\/a><br>\\r\\n                                    <em>em element<\\/em><br>\\r\\n                                    <strong>strong<\\/strong><br>\\r\\n                                    <code>code element<\\/code><br>\\r\\n                                    <del>del element<\\/del>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-2-5\\\">\\r\\n                                    <ins>ins element<\\/ins><br>\\r\\n                                    <mark>mark element<\\/mark><br>\\r\\n                                    <q>q <q>inside<\\/q> a q element <\\/q><br>\\r\\n                                    <abbr title=\\\"Abbreviation Element\\\">abbr element<\\/abbr><br>\\r\\n                                    <dfn title=\\\"Defines a definition term\\\">dfn element<\\/dfn>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-1\\\">\\r\\n                                    <p class=\\\"uk-text-center\\\">\\r\\n                                        <span class=\\\"uk-badge\\\">Badge<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-notification\\\">1<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success\\\">Success<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success uk-badge-notification\\\">4<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning\\\">Warning<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning uk-badge-notification\\\">3<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger\\\">Danger<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger uk-badge-notification\\\">4<\\/span>\\r\\n                                    <\\/p>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <h1 class=\\\"uk-display-inline\\\">h1<\\/h1>\\r\\n                                    <h2 class=\\\"uk-display-inline\\\">h2<\\/h2>\\r\\n                                    <h3 class=\\\"uk-display-inline\\\">h3<\\/h3>\\r\\n                                    <h4 class=\\\"uk-display-inline\\\">h4<\\/h4>\\r\\n                                    <h5 class=\\\"uk-display-inline\\\">h5<\\/h5>\\r\\n                                    <h6 class=\\\"uk-display-inline\\\">h6<\\/h6>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <blockquote>\\r\\n                                        <p> Lorem ipsum dolor.<\\/p>\\r\\n                                        <small>Someone famous<\\/small>\\r\\n                                    <\\/blockquote>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/article>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-comment-list\\\">\\r\\n                            <li>\\r\\n                                <article class=\\\"uk-comment\\\">\\r\\n                                    <header class=\\\"uk-comment-header\\\">\\r\\n                                        <img class=\\\"uk-comment-avatar\\\" src=\\\"\\/themes\\/joomla\\/2015\\/avion\\/images\\/yootheme\\/uikit_avatar.svg\\\" width=\\\"50\\\" height=\\\"50\\\" alt=\\\"\\\">\\r\\n                                        <h4 class=\\\"uk-comment-title\\\">Author<\\/h4>\\r\\n                                        <p class=\\\"uk-comment-meta\\\">May 2, 2090 at 1:55 pm<\\/p>\\r\\n                                    <\\/header>\\r\\n                                    <div class=\\\"uk-comment-body\\\">\\r\\n                                        <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna.<\\/p>\\r\\n                                    <\\/div>\\r\\n                                <\\/article>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-pagination\\\">\\r\\n                            <li class=\\\"uk-disabled\\\"><span><i class=\\\"uk-icon-angle-double-left\\\"><\\/i><\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>1<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">2<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">3<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">4<\\/a><\\/li>\\r\\n                            <li><span>...<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">20<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\"><i class=\\\"uk-icon-angle-double-right\\\"><\\/i><\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-side uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-divider\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Divider<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-header\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Header<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-primary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box primary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-secondary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box secondary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Info message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-success\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Success message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-warning\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Warning message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-danger\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Danger message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-success\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-warning\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-danger\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form states<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"Text Input\\\" class=\\\"uk-width-1-1\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-success\\\" value=\\\"form-success\\\" class=\\\"uk-width-1-1 uk-form-success\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-danger\\\" value=\\\"form-danger\\\" class=\\\"uk-width-1-1 uk-form-danger\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form disabled\\\" class=\\\"uk-width-1-1\\\" disabled>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form styles<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-large\\\" class=\\\"uk-form-large uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-large\\\" type=\\\"reset\\\">Large<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-small\\\" class=\\\"uk-form-small uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-small\\\" type=\\\"reset\\\">Small<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-blank\\\" class=\\\"uk-form-width-small uk-form-blank\\\">\\r\\n                                <button class=\\\"uk-button uk-button-mini\\\" type=\\\"reset\\\">Mini<\\/button>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-line\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-pill\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-tab\\\" data-uk-tab>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-github\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-twitter\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-dribbble\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-html5\\\"><\\/a>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid uk-grid-divider\\\" data-uk-grid-margin>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-line\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-striped\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <table class=\\\"uk-table uk-table-striped uk-table-condensed uk-table-hover\\\">\\r\\n                    <caption>Table caption<\\/caption>\\r\\n                    <thead>\\r\\n                        <tr>\\r\\n                            <th>Table<\\/th>\\r\\n                            <th>Heading<\\/th>\\r\\n                        <\\/tr>\\r\\n                    <\\/thead>\\r\\n                    <tbody>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                    <\\/tbody>\\r\\n                <\\/table>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <dl class=\\\"uk-description-list uk-description-list-line\\\">\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                <\\/dl>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"offcanvas-1\\\" class=\\\"uk-offcanvas\\\">\\r\\n            <div class=\\\"uk-offcanvas-bar\\\">\\r\\n\\r\\n                <ul class=\\\"uk-nav uk-nav-offcanvas uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                <ul>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                <\\/ul>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-star\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-twitter\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-rss\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"modal-1\\\" class=\\\"uk-modal\\\">\\r\\n            <div class=\\\"uk-modal-dialog\\\">\\r\\n                <button type=\\\"button\\\" class=\\\"uk-modal-close uk-close\\\"><\\/button>\\r\\n                <h1>Headline<\\/h1>\\r\\n                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\/p>\\r\\n            <\\/div>\\r\\n        <\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-09-12 15:45:36\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-12 15:47:35\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-12 15:46:11\",\"publish_up\":\"2017-09-12 15:45:36\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('420', '58', '1', '', '2017-09-13 08:06:56', '413', '33984', '32db97e4eb3a3ad3ea6b8e9ae357ca0855ef166c', '{\"id\":58,\"asset_id\":\"486\",\"title\":\"HTML elements\",\"alias\":\"html-elements\",\"introtext\":\" <div class=\\\"uk-grid\\\">\\r\\n            <div class=\\\"uk-width-1-1\\\" data-uk-margin>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button\\\">Button<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-width-2\\\">\\r\\n\\r\\n                            <div class=\\\"uk-grid uk-dropdown-grid\\\">\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-2\\\">\\r\\n                                    <ul class=\\\"uk-nav uk-nav-dropdown uk-panel\\\">\\r\\n                                        <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                        <li class=\\\"uk-parent\\\">\\r\\n                                            <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                            <ul class=\\\"uk-nav-sub\\\">\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                                    <ul>\\r\\n                                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                    <\\/ul>\\r\\n                                                <\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-primary\\\">Primary<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-primary\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown uk-dropdown-small\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-success\\\">Success<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-success\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-button-group\\\">\\r\\n                    <button class=\\\"uk-button uk-button-danger\\\">Danger<\\/button>\\r\\n                    <div data-uk-dropdown=\\\"{mode:\'click\'}\\\">\\r\\n                        <button class=\\\"uk-button uk-button-danger\\\"><i class=\\\"uk-icon-caret-down\\\"><\\/i><\\/button>\\r\\n                        <div class=\\\"uk-dropdown\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-dropdown\\\">\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li><a href=\\\"#\\\">Separated item<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n\\r\\n                <button class=\\\"uk-button\\\" disabled>Disabled<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-tooltip title=\\\"Bazinga!\\\">Tooltip<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-modal=\\\"{target:\'#modal-1\'}\\\">Modal<\\/button>\\r\\n                <button class=\\\"uk-button\\\" data-uk-offcanvas=\\\"{target:\'#offcanvas-1\'}\\\">Off-canvas<\\/button>\\r\\n                <button class=\\\"uk-button uk-button-link\\\">Button link<\\/button>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-breadcrumb\\\">\\r\\n                            <li><a href=\\\"#\\\">Home<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Blog<\\/a><\\/li>\\r\\n                            <li><span>Category<\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>Post<\\/span><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n\\r\\n                        <article class=\\\"uk-article\\\">\\r\\n\\r\\n                            <h1 class=\\\"uk-article-title\\\">Article title<\\/h1>\\r\\n\\r\\n                            <p class=\\\"uk-article-meta\\\">Written by Super User on 12 April. Posted in Blog<\\/p>\\r\\n\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/images\\/visuals\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-icon uk-overlay-background uk-overlay-fade\\\"><\\/div>\\r\\n                                        <\\/div>\\r\\n                                        <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <a class=\\\"uk-thumbnail uk-overlay-hover\\\" href=\\\"#\\\">\\r\\n                                        <div class=\\\"uk-overlay\\\">\\r\\n                                            <img src=\\\"\\/images\\/visuals\\/uikit_placeholder.svg\\\" width=\\\"300\\\" height=\\\"90\\\" alt=\\\"\\\">\\r\\n                                            <div class=\\\"uk-overlay-panel uk-overlay-bottom uk-overlay-background uk-overlay-fade\\\">Caption<\\/div>\\r\\n                                        <\\/div>\\r\\n                                    <div class=\\\"uk-thumbnail-caption\\\">Caption<\\/div>\\r\\n                                    <\\/a>\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n\\r\\n                            <p class=\\\"uk-article-lead\\\">Lorem ipsum dolor sit amet.<\\/p>\\r\\n                            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                            <pre><code>&lt;div class=\\\"myclass\\\"&gt;...&lt;\\/div&gt;<\\/code><\\/pre>\\r\\n                            <hr class=\\\"uk-article-divider\\\">\\r\\n                            <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-5\\\">\\r\\n                                    <span class=\\\"uk-text-muted\\\">text-muted<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-primary\\\">text-primary<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-success\\\">text-success<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-warning\\\">text-warning<\\/span><br>\\r\\n                                    <span class=\\\"uk-text-danger\\\">text-danger<\\/span>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-3-10\\\">\\r\\n                                    <a href=\\\"#\\\">a element<\\/a><br>\\r\\n                                    <em>em element<\\/em><br>\\r\\n                                    <strong>strong<\\/strong><br>\\r\\n                                    <code>code element<\\/code><br>\\r\\n                                    <del>del element<\\/del>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-2-5\\\">\\r\\n                                    <ins>ins element<\\/ins><br>\\r\\n                                    <mark>mark element<\\/mark><br>\\r\\n                                    <q>q <q>inside<\\/q> a q element <\\/q><br>\\r\\n                                    <abbr title=\\\"Abbreviation Element\\\">abbr element<\\/abbr><br>\\r\\n                                    <dfn title=\\\"Defines a definition term\\\">dfn element<\\/dfn>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-1-1\\\">\\r\\n                                    <p class=\\\"uk-text-center\\\">\\r\\n                                        <span class=\\\"uk-badge\\\">Badge<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-notification\\\">1<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success\\\">Success<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-success uk-badge-notification\\\">4<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning\\\">Warning<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-warning uk-badge-notification\\\">3<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger\\\">Danger<\\/span>\\r\\n                                        <span class=\\\"uk-badge uk-badge-danger uk-badge-notification\\\">4<\\/span>\\r\\n                                    <\\/p>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <h1 class=\\\"uk-display-inline\\\">h1<\\/h1>\\r\\n                                    <h2 class=\\\"uk-display-inline\\\">h2<\\/h2>\\r\\n                                    <h3 class=\\\"uk-display-inline\\\">h3<\\/h3>\\r\\n                                    <h4 class=\\\"uk-display-inline\\\">h4<\\/h4>\\r\\n                                    <h5 class=\\\"uk-display-inline\\\">h5<\\/h5>\\r\\n                                    <h6 class=\\\"uk-display-inline\\\">h6<\\/h6>\\r\\n                                <\\/div>\\r\\n\\r\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\r\\n                                    <blockquote>\\r\\n                                        <p> Lorem ipsum dolor.<\\/p>\\r\\n                                        <small>Someone famous<\\/small>\\r\\n                                    <\\/blockquote>\\r\\n                                <\\/div>\\r\\n\\r\\n                            <\\/div>\\r\\n\\r\\n                        <\\/article>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-comment-list\\\">\\r\\n                            <li>\\r\\n                                <article class=\\\"uk-comment\\\">\\r\\n                                    <header class=\\\"uk-comment-header\\\">\\r\\n                                        <img class=\\\"uk-comment-avatar\\\" src=\\\"\\/images\\/visuals\\/uikit_avatar.svg\\\" width=\\\"50\\\" height=\\\"50\\\" alt=\\\"\\\">\\r\\n                                        <h4 class=\\\"uk-comment-title\\\">Author<\\/h4>\\r\\n                                        <p class=\\\"uk-comment-meta\\\">May 2, 2090 at 1:55 pm<\\/p>\\r\\n                                    <\\/header>\\r\\n                                    <div class=\\\"uk-comment-body\\\">\\r\\n                                        <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna.<\\/p>\\r\\n                                    <\\/div>\\r\\n                                <\\/article>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-1\\\">\\r\\n                        <ul class=\\\"uk-pagination\\\">\\r\\n                            <li class=\\\"uk-disabled\\\"><span><i class=\\\"uk-icon-angle-double-left\\\"><\\/i><\\/span><\\/li>\\r\\n                            <li class=\\\"uk-active\\\"><span>1<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">2<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">3<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">4<\\/a><\\/li>\\r\\n                            <li><span>...<\\/span><\\/li>\\r\\n                            <li><a href=\\\"#\\\">20<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\"><i class=\\\"uk-icon-angle-double-right\\\"><\\/i><\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel\\\">\\r\\n                            <ul class=\\\"uk-nav uk-nav-side uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                                <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                                <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                                <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                                <li class=\\\"uk-parent\\\">\\r\\n                                    <a href=\\\"#\\\">Parent<\\/a>\\r\\n                                    <ul class=\\\"uk-nav-sub\\\">\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                        <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                            <ul>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                                <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                            <\\/ul>\\r\\n                                        <\\/li>\\r\\n                                    <\\/ul>\\r\\n                                <\\/li>\\r\\n                                <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                            <\\/ul>\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-divider\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Divider<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-header\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Header<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-medium-1-2\\\">\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-primary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box primary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                        <div class=\\\"uk-panel uk-panel-box uk-panel-box-secondary\\\">\\r\\n                            <h3 class=\\\"uk-panel-title\\\">Box secondary<\\/h3>\\r\\n                            Lorem ipsum <a href=\\\"#\\\">dolor<\\/a> sit amet, consectetur adipisicing elit.\\r\\n                        <\\/div>\\r\\n\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Info message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-success\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Success message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-warning\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Warning message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-alert uk-alert-danger\\\" data-uk-alert>\\r\\n                            <a class=\\\"uk-alert-close uk-close\\\"><\\/a>\\r\\n                            <p>Danger message<\\/p>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-success\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-warning\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2\\\">\\r\\n                        <div class=\\\"uk-progress uk-progress-danger\\\">\\r\\n                            <div class=\\\"uk-progress-bar\\\" style=\\\"width: 55%;\\\">55%<\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form states<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"Text Input\\\" class=\\\"uk-width-1-1\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-success\\\" value=\\\"form-success\\\" class=\\\"uk-width-1-1 uk-form-success\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-danger\\\" value=\\\"form-danger\\\" class=\\\"uk-width-1-1 uk-form-danger\\\">\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form disabled\\\" class=\\\"uk-width-1-1\\\" disabled>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\\"uk-width-1-2 uk-form\\\">\\r\\n                        <fieldset>\\r\\n                            <legend>Form styles<\\/legend>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-large\\\" class=\\\"uk-form-large uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-large\\\" type=\\\"reset\\\">Large<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-small\\\" class=\\\"uk-form-small uk-form-width-small\\\">\\r\\n                                <button class=\\\"uk-button uk-button-small\\\" type=\\\"reset\\\">Small<\\/button>\\r\\n                            <\\/div>\\r\\n                            <div class=\\\"uk-form-row\\\">\\r\\n                                <input type=\\\"text\\\" placeholder=\\\"form-blank\\\" class=\\\"uk-form-width-small uk-form-blank\\\">\\r\\n                                <button class=\\\"uk-button uk-button-mini\\\" type=\\\"reset\\\">Mini<\\/button>\\r\\n                            <\\/div>\\r\\n                        <\\/fieldset>\\r\\n                    <\\/div>\\r\\n\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid\\\" data-uk-grid-margin>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-line\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-subnav uk-subnav-pill\\\">\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-tab\\\" data-uk-tab>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-disabled\\\"><a href=\\\"#\\\">Disabled<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-github\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-twitter\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-dribbble\\\"><\\/a>\\r\\n                <a href=\\\"#\\\" class=\\\"uk-icon-button uk-icon-html5\\\"><\\/a>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <hr class=\\\"uk-grid-divider\\\">\\r\\n\\r\\n        <div class=\\\"uk-grid uk-grid-divider\\\" data-uk-grid-margin>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-line\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <ul class=\\\"uk-list uk-list-striped\\\">\\r\\n                    <li>List item 1<\\/li>\\r\\n                    <li>List item 2<\\/li>\\r\\n                    <li>List item 3<\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <table class=\\\"uk-table uk-table-striped uk-table-condensed uk-table-hover\\\">\\r\\n                    <caption>Table caption<\\/caption>\\r\\n                    <thead>\\r\\n                        <tr>\\r\\n                            <th>Table<\\/th>\\r\\n                            <th>Heading<\\/th>\\r\\n                        <\\/tr>\\r\\n                    <\\/thead>\\r\\n                    <tbody>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                        <tr>\\r\\n                            <td>Table<\\/td>\\r\\n                            <td>Data<\\/td>\\r\\n                        <\\/tr>\\r\\n                    <\\/tbody>\\r\\n                <\\/table>\\r\\n\\r\\n            <\\/div>\\r\\n            <div class=\\\"uk-width-medium-1-4\\\">\\r\\n\\r\\n                <dl class=\\\"uk-description-list uk-description-list-line\\\">\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                    <dt>Description lists<\\/dt>\\r\\n                    <dd>Description text.<\\/dd>\\r\\n                <\\/dl>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"offcanvas-1\\\" class=\\\"uk-offcanvas\\\">\\r\\n            <div class=\\\"uk-offcanvas-bar\\\">\\r\\n\\r\\n                <ul class=\\\"uk-nav uk-nav-offcanvas uk-nav-parent-icon\\\" data-uk-nav>\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-active\\\"><a href=\\\"#\\\">Active<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a>\\r\\n                                <ul>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                    <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                                <\\/ul>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-parent\\\">\\r\\n                        <a href=\\\"#\\\">Parent<\\/a>\\r\\n                        <ul class=\\\"uk-nav-sub\\\">\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                            <li><a href=\\\"#\\\">Sub item<\\/a><\\/li>\\r\\n                        <\\/ul>\\r\\n                    <\\/li>\\r\\n\\r\\n                    <li><a href=\\\"#\\\">Item<\\/a><\\/li>\\r\\n\\r\\n                    <li class=\\\"uk-nav-header\\\">Header<\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-star\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-twitter\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                    <li class=\\\"uk-nav-divider\\\"><\\/li>\\r\\n                    <li><a href=\\\"#\\\"><i class=\\\"uk-icon-rss\\\"><\\/i> Item<\\/a><\\/li>\\r\\n                <\\/ul>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n                <div class=\\\"uk-panel\\\">\\r\\n                    <h3 class=\\\"uk-panel-title\\\">Title<\\/h3>\\r\\n                    Lorem ipsum dolor sit amet, <a href=\\\"#\\\">consetetur<\\/a> sadipscing elitr.\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div id=\\\"modal-1\\\" class=\\\"uk-modal\\\">\\r\\n            <div class=\\\"uk-modal-dialog\\\">\\r\\n                <button type=\\\"button\\\" class=\\\"uk-modal-close uk-close\\\"><\\/button>\\r\\n                <h1>Headline<\\/h1>\\r\\n                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\/p>\\r\\n            <\\/div>\\r\\n        <\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-09-12 15:45:36\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-13 08:06:56\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-13 08:06:17\",\"publish_up\":\"2017-09-12 15:45:36\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('421', '2', '1', '', '2017-09-14 12:27:36', '413', '3996', '86f82572a51eb8e8390be1a03ce3f2c1ddb58f7d', '{\"id\":2,\"asset_id\":\"81\",\"title\":\"Layouts\",\"alias\":\"layouts\",\"introtext\":\"<p>Posuere nisi per ante lorem nulla nostra malesuada lacus nostra aptent mattis porta fusce massa class consectetur nisl. Quisque inceptos per gravida nam tempus inceptos interdum turpis netus curabitur est. Ultrices primis ad himenaeos dapibus, urna condimentum posuere ullamcorper vehicula augue ante urna fermentum aenean! Lorem vel suspendisse viverra sagittis gravida odio sed amet phasellus fermentum.<\\/p>\\r\\n<p>Aenean primis, dapibus curae curae ante, eros pharetra donec sem viverra elit tempus. Lacinia venenatis ac elementum eros mollis congue.<\\/p>\\r\\n<p>Tincidunt donec aliquet litora netus nostra, integer pulvinar nunc ultrices urna posuere a nisl lacinia; Sociosqu fermentum felis ligula cursus est etiam libero fermentum litora pharetra potenti tortor.<\\/p>\\r\\n<p>Est semper mauris ligula cursus vulputate. Integer fusce, tellus nisl augue condimentum, nisi neque ornare. Nisi luctus interdum nisi pulvinar donec, at imperdiet congue inceptos sollicitudin magna feugiat massa. Porta phasellus a iaculis, elit sociosqu tortor pharetra. Donec tempor nam inceptos, augue malesuada proin, gravida orci imperdiet elementum vestibulum vel vestibulum hendrerit. Scelerisque maecenas lacinia porttitor ipsum consectetur laoreet, urna adipiscing consequat aliquet class praesent integer eros netus dui hendrerit. Scelerisque ad pellentesque rhoncus, nisl metus congue semper, dui sagittis inceptos imperdiet duis curae. Litora pulvinar ultricies class aptent amet varius condimentum nulla sollicitudin.<\\/p>\\r\\n<p>Felis ullamcorper porttitor habitasse placerat eleifend viverra nullam; Blandit congue lorem lacus curabitur sit volutpat eleifend condimentum sit dapibus vitae ullamcorper. Dapibus interdum hac sapien curabitur sagittis metus risus dolor morbi vel auctor conubia torquent commodo eu nostra tristique; Senectus placerat rhoncus tellus ut nostra, amet vitae donec elementum urna justo leo congue turpis. Quam lorem himenaeos sodales potenti nostra amet, justo hac ullamcorper nisi pharetra scelerisque neque mauris. Erat phasellus, in neque torquent nulla, sociosqu scelerisque magna netus urna. Tincidunt duis fusce blandit duis laoreet risus felis viverra bibendum elementum nunc volutpat consequat in.<\\/p>\\r\\n\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:27:36\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:27:15\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"172\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('422', '2', '1', '', '2017-09-14 12:36:30', '413', '2618', 'f69056c2b165f8626db44458ed84e4c39f3bf8ba', '{\"id\":2,\"asset_id\":\"81\",\"title\":\"Layouts\",\"alias\":\"layouts\",\"introtext\":\"<p>Posuere nisi per ante lorem nulla nostra malesuada lacus nostra aptent mattis porta fusce massa class consectetur nisl. Quisque inceptos per gravida nam tempus inceptos interdum turpis netus curabitur est. Ultrices primis ad himenaeos dapibus, urna condimentum posuere ullamcorper vehicula augue ante urna fermentum aenean! Lorem vel suspendisse viverra sagittis gravida odio sed amet phasellus fermentum.<\\/p>\\r\\n<p>Aenean primis, dapibus curae curae ante, eros pharetra donec sem viverra elit tempus. Lacinia venenatis ac elementum eros mollis congue.<\\/p>\\r\\n<p>Tincidunt donec aliquet litora netus nostra, integer pulvinar nunc ultrices urna posuere a nisl lacinia; Sociosqu fermentum felis ligula cursus est etiam libero fermentum litora pharetra potenti tortor.<\\/p>\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:36:30\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:35:29\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"177\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('423', '2', '1', '', '2017-09-14 12:40:33', '413', '2923', '42f64aca88fe6e9b4701cc876fa1093ff4cd602d', '{\"id\":2,\"asset_id\":\"81\",\"title\":\"Layouts\",\"alias\":\"layouts\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:40:33\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:36:30\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"178\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('424', '60', '1', '', '2017-09-14 12:43:59', '413', '2891', '8a4a165b6ce85eeefa4cc46a8e11bca13c5470d4', '{\"id\":60,\"asset_id\":520,\"title\":\"Layouts (2)\",\"alias\":\"layouts-2\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":0,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:43:59\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('425', '60', '1', '', '2017-09-14 12:44:07', '413', '2945', '243a402c04aa46c2050a9be39a1fd6c34b0ae15d', '{\"id\":60,\"asset_id\":\"520\",\"title\":\"Left+Content+Right\",\"alias\":\"left-content-right\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:44:07\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:43:59\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('426', '61', '1', '', '2017-09-14 12:46:05', '413', '2913', '8e5abe519d00d9d4da6de6627b3013af4ad59bcd', '{\"id\":61,\"asset_id\":521,\"title\":\"Left+Content+Right (2)\",\"alias\":\"left-content-right-2\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":0,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:46:05\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('427', '61', '1', '', '2017-09-14 12:46:14', '413', '2945', 'd8a1c67879eb69a7eb79cf0851d187befd6d62ac', '{\"id\":61,\"asset_id\":\"521\",\"title\":\"Content+Left+Right\",\"alias\":\"content-left-right\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:46:14\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:46:05\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('428', '62', '1', '', '2017-09-14 12:46:26', '413', '2913', '73e2186df328baed8917b58807e4d536731855a2', '{\"id\":62,\"asset_id\":522,\"title\":\"Content+Left+Right (2)\",\"alias\":\"content-left-right-2\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":0,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:46:26\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('429', '62', '1', '', '2017-09-14 12:46:41', '413', '2945', '461032eef998feac8d5dbef0573b3860ca741d52', '{\"id\":62,\"asset_id\":\"522\",\"title\":\"Left+Right+Content\",\"alias\":\"left-right-content\",\"introtext\":\"<p>Acamar comes with a sophisticated layout system to create any kind of sidebar or module layout. You can easily manage the modules\'s positions and widths in the template settings. Modules can have different styles and be placed in any position offered by this template. Each position has its own layout. You can align modules side-by-side, stack them or choose your own grid layout. Show or hide modules on mobile devices, while the grid adapts perfectly to your layout.<\\/p>\\r\\n\\r\\n\\r\\n<h3>Module Layouts<\\/h3>\\r\\n\\r\\n<p>The blue module positions allow to choose a module layout which defines the module alignment and proportions: parallel, stacked, first doubled, last doubled and center doubled. You can easily add your own module layouts.<\\/p>\\r\\n\\r\\n<h3>Sidebar Layouts<\\/h3>\\r\\n\\r\\n<p>The two available sidebars, highlighted in red, can be switched to the left or right side and their widths can easily be set in the template settings.<\\/p>\\r\\n\\r\\n<h3>Module Style<\\/h3>\\r\\n\\r\\n<p>For moduless in the blue and red positions you can choose different module styles.<\\/p>\\r\\n\\r\\n<p>\\r\\n<img src=\\\"\\/images\\/visuals\\/layouts.png\\\" alt=\\\"Layouts\\\"\\/>\\r\\n<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2016-08-21 19:48:35\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 12:46:41\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 12:46:26\",\"publish_up\":\"2016-08-21 19:48:35\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('432', '40', '1', '', '2017-09-14 13:07:34', '413', '3685', '3467fd2354250ef62dc7ff90028a0841246a00ae', '{\"id\":40,\"asset_id\":\"395\",\"title\":\"Color Variations\",\"alias\":\"color-variations\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">\\r\\nAcamar Template Customizer allow create your own style. You can pick colors, modify sizes, select fonts and much more with a real time theme preview. We added 6 amazing color styles. And you can build your own color style just a minutes!\\r\\n<\\/p>\\r\\n\\r\\n<p>We provide lovingly crafted style variations to give you a glimpse of what is possible with this template. The built-in theme customizer allows you to modify colors, fonts, sizes and much more without any CSS knowledge. Just choose your colors with the color picker and adjust the theme with only a few clicks. Click on one of the images to see the style.<\\/p>\\r\\n\\r\\n<div class=\\\"uk-grid\\\" data-uk-grid-margin=\\\"\\\">\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=default\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/floral-red.png\\\" alt=\\\"Floral Red Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Floral Red Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=RichGreen\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/rich-green.png\\\" alt=\\\"Rich Green Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Rich Green Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=PolarBlue\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/polar-blue.png\\\" alt=\\\"Polar Blue Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Polar Blue Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n\\r\\nCharged Orange\\r\\nElectric Gray\\r\\nVampiric Midnight\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-02-09 19:54:57\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 13:07:34\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 13:02:49\",\"publish_up\":\"2017-02-09 19:54:57\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"41\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('433', '40', '1', '', '2017-09-14 13:11:11', '413', '3700', '2ba67194d8c71006bc3ad211255a2577327d654e', '{\"id\":40,\"asset_id\":\"395\",\"title\":\"Color Variations\",\"alias\":\"color-variations\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">\\r\\nAcamar Template Customizer allow create your own style. You can pick colors, modify sizes, select fonts and much more with a real time theme preview. We added 6 amazing color styles. And you can build your own color style just a minutes!\\r\\n<\\/p>\\r\\n\\r\\n<p>We provide lovingly crafted style variations to give you a glimpse of what is possible with this template. The built-in theme customizer allows you to modify colors, fonts, sizes and much more without any CSS knowledge. Just choose your colors with the color picker and adjust the theme with only a few clicks. Click on one of the images to see the style.<\\/p>\\r\\n\\r\\n<div class=\\\"uk-grid\\\" data-uk-grid-margin=\\\"\\\">\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=default\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/floral-red.png\\\" alt=\\\"Floral Red Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption uk-text-center\\\">Floral Red Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=RichGreen\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/rich-green.png\\\" alt=\\\"Rich Green Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Rich Green Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=PolarBlue\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/polar-blue.png\\\" alt=\\\"Polar Blue Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Polar Blue Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n\\r\\nCharged Orange\\r\\nElectric Gray\\r\\nVampiric Midnight\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-02-09 19:54:57\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 13:11:11\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 13:10:44\",\"publish_up\":\"2017-02-09 19:54:57\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"44\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('434', '40', '1', '', '2017-09-14 13:12:14', '413', '4061', '65490facd207b0ead67dd27d335fcb367ef70fae', '{\"id\":40,\"asset_id\":\"395\",\"title\":\"Color Variations\",\"alias\":\"color-variations\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">\\r\\nAcamar Template Customizer allow create your own style. You can pick colors, modify sizes, select fonts and much more with a real time theme preview. We added 6 amazing color styles. And you can build your own color style just a minutes!\\r\\n<\\/p>\\r\\n\\r\\n<p>We provide lovingly crafted style variations to give you a glimpse of what is possible with this template. The built-in theme customizer allows you to modify colors, fonts, sizes and much more without any CSS knowledge. Just choose your colors with the color picker and adjust the theme with only a few clicks. Click on one of the images to see the style.<\\/p>\\r\\n\\r\\n<div class=\\\"uk-grid\\\" data-uk-grid-margin=\\\"\\\">\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=default\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/floral-red.png\\\" alt=\\\"Floral Red Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Floral Red Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=RichGreen\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/rich-green.png\\\" alt=\\\"Rich Green Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Rich Green Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=PolarBlue\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/polar-blue.png\\\" alt=\\\"Polar Blue Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Polar Blue Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=ChargedOrange\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/charged-orange.png\\\" alt=\\\"Charged Orange Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Charged Orange Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n\\r\\nElectric Gray\\r\\nVampiric Midnight\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-02-09 19:54:57\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 13:12:14\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 13:11:11\",\"publish_up\":\"2017-02-09 19:54:57\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"45\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0');
/**ABDB**/INSERT INTO `#__ucm_history`  VALUES 
('435', '40', '1', '', '2017-09-14 13:15:05', '413', '4799', '3c2230deedbe11abfd52cd25b37d6ffc466df2d9', '{\"id\":40,\"asset_id\":\"395\",\"title\":\"Color Variations\",\"alias\":\"color-variations\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">\\r\\nAcamar Template Customizer allow create your own style. You can pick colors, modify sizes, select fonts and much more with a real time theme preview. We added 6 amazing color styles. And you can build your own color style just a minutes!\\r\\n<\\/p>\\r\\n\\r\\n<p>We provide lovingly crafted style variations to give you a glimpse of what is possible with this template. The built-in theme customizer allows you to modify colors, fonts, sizes and much more without any CSS knowledge. Just choose your colors with the color picker and adjust the theme with only a few clicks. Click on one of the images to see the style.<\\/p>\\r\\n\\r\\n<div class=\\\"uk-grid\\\" data-uk-grid-margin=\\\"\\\">\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=default\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/floral-red.png\\\" alt=\\\"Floral Red Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Floral Red Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=RichGreen\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/rich-green.png\\\" alt=\\\"Rich Green Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Rich Green Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=PolarBlue\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/polar-blue.png\\\" alt=\\\"Polar Blue Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Polar Blue Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=ChargedOrange\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/charged-orange.png\\\" alt=\\\"Charged Orange Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Charged Orange Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=ElectricGray\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/electric-gray.png\\\" alt=\\\"Electric Gray Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Electric Gray Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\\"uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-3\\\">\\r\\n      \\t<a class=\\\"uk-thumbnail uk-thumbnail-expand\\\" href=\\\"\\/?style=VampiricMidnight\\\">\\r\\n            <img src=\\\"\\/images\\/visuals\\/vampiric-midnight.png\\\" alt=\\\"Vampiric Midnight Style\\\">\\r\\n            <span class=\\\"uk-thumbnail-caption\\\">Vampiric Midnight Color Style<\\/span>\\r\\n      \\t<\\/a>\\r\\n    <\\/div>\\r\\n\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2017-02-09 19:54:57\",\"created_by\":\"413\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 13:15:05\",\"modified_by\":\"413\",\"checked_out\":\"413\",\"checked_out_time\":\"2017-09-14 13:12:14\",\"publish_up\":\"2017-02-09 19:54:57\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"45\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('436', '63', '1', '', '2017-09-14 14:38:22', '413', '7648', '046c09bb5da3fc6e01de631e33ac18bc96c1f56d', '{\"id\":63,\"asset_id\":527,\"title\":\"Timepicker\",\"alias\":\"timepicker\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Create a timepicker which can easily be used by selecting a time value from a pre filled dropdown.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To apply the timepicker, just add the <code>data-uk-timepicker<\\/code> attribute to an <code>&lt;input&gt;<\\/code> element. The timepicker will automatically display a pre filled dropdown on focus, which can be navigated by pressing the up or down button on the keyboard or by scrolling with the mouse.<\\/p>\\n\\n                            <p><span class=\\\"uk-badge uk-badge-danger\\\">IMPORTANT<\\/span> The timepicker component requires the <a href=\\\"autocomplete.html\\\">Autocomplete component<\\/a> in order to work. Please make sure that you always include them together.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <form class=\\\"uk-form\\\">\\n                                <input type=\\\"text\\\" id=\\\"form-time\\\" data-uk-timepicker=\\\"\\\">\\n                            <\\/form>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">form<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-form\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">input<\\/span> <span class=\\\"attribute\\\">type<\\/span>=<span class=\\\"value\\\">\\\"text\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-timepicker<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">form<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"display-meridian-time\\\"><a href=\\\"#display-meridian-time\\\" class=\\\"uk-link-reset\\\">Display meridian time<\\/a><\\/h2>\\n\\n                            <p>To display meridian time, just define the <em>format<\\/em> option and set it to <code>12h<\\/code><\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <form class=\\\"uk-form\\\">\\n                                <input type=\\\"text\\\" id=\\\"form-time-meridian\\\" data-uk-timepicker=\\\"{format:\'12h\'}\\\">\\n                            <\\/form>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">form<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-form\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">input<\\/span> <span class=\\\"attribute\\\">type<\\/span>=<span class=\\\"value\\\">\\\"text\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-timepicker<\\/span>=<span class=\\\"value\\\">\\\"{format:\'12h\'}\\\"<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">form<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <p>This is an example of how to set options via data attribute:<\\/p>\\n\\n                            <pre><code class=\\\"ini\\\"><span class=\\\"setting\\\">data-uk-timepicker=<span class=\\\"value\\\"><span class=\\\"string\\\">\\\"{format:\'12h\'}\\\"<\\/span><\\/span><\\/span><\\/code><\\/pre>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>format<\\/code><\\/td>\\n                                            <td>\'24h\' or \'12h\'<\\/td>\\n                                            <td>\'24h\'<\\/td>\\n                                            <td>Defines the preferred time notation<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>start<\\/code><\\/td>\\n                                            <td>Integer between 0 and 24<\\/td>\\n                                            <td>0<\\/td>\\n                                            <td>Start time<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>end<\\/code><\\/td>\\n                                            <td>Integer between 0 and 24<\\/td>\\n                                            <td>24<\\/td>\\n                                            <td>End time<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Init element manually<\\/h3>\\n\\n                            <pre><code class=\\\"javascript\\\"><span class=\\\"keyword\\\">var<\\/span> timepicker = UIkit.timepicker(element, { <span class=\\\"comment\\\">\\/* options *\\/<\\/span> });<\\/code><\\/pre>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:55:38+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:55:38+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"269\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('437', '64', '1', '', '2017-09-14 14:38:22', '413', '10243', '34e8280dbbf3c05a82b0d9172139b8c1f082c050', '{\"id\":64,\"asset_id\":528,\"title\":\"Datepicker\",\"alias\":\"datepicker\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Create a toggleable dropdown with an datepicker.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To create a datepicker, just add the <code>data-uk-datepicker<\\/code> attribute to an <code>&lt;input&gt;<\\/code> element. You also have the possibility of customizing the date format. Just add the <em>format<\\/em> option to the <code>data-uk-datepicker<\\/code> attribute.<\\/p>\\n\\n                            <p>The datepicker detects whether the JavaScript from the <a href=\\\"form-select.html\\\">Form select component<\\/a> is being loaded. This allows you to quickly toggle between years and months through a select form inside the datepicker.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <form class=\\\"uk-form\\\">\\n                                <input type=\\\"text\\\" data-uk-datepicker=\\\"{format:\'DD.MM.YYYY\'}\\\">\\n                            <\\/form>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">form<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-form\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">input<\\/span> <span class=\\\"attribute\\\">type<\\/span>=<span class=\\\"value\\\">\\\"text\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-datepicker<\\/span>=<span class=\\\"value\\\">\\\"{format:\'DD.MM.YYYY\'}\\\"<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">form<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <p>This is an example of how to set options via attribute:<\\/p>\\n\\n                            <pre><code class=\\\"ini\\\"><span class=\\\"setting\\\">data-uk-datepicker=<span class=\\\"value\\\"><span class=\\\"string\\\">\\\"{weekstart:0, format:\'DD.MM.YYYY\'}\\\"<\\/span><\\/span><\\/span><\\/code><\\/pre>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>weekstart<\\/code><\\/td>\\n                                            <td>integer (0..6)<\\/td>\\n                                            <td>1<\\/td>\\n                                            <td>Start of the week<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>i18n<\\/code><\\/td>\\n                                            <td>JSON object<\\/td>\\n                                            <td>{ months:[\'January\',...], weekdays:[\'Sun\',..,\'Sat\'] }<\\/td>\\n                                            <td>Language string definitions<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>format<\\/code><\\/td>\\n                                            <td>any combination of DD, MM and YYYY<\\/td>\\n                                            <td>\'YYYY-MM-DD\'<\\/td>\\n                                            <td>Date format string<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>offsettop<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>5<\\/td>\\n                                            <td>Offset to the input value<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>minDate<\\/code><\\/td>\\n                                            <td>bool (false to ignore the option)<br>\\n                                                string (date as in <code>format<\\/code>)<br>\\n                                                integer (offset in days from current date)                                            <\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Min. date<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>maxDate<\\/code><\\/td>\\n                                            <td>bool (false to ignore the option)<br>\\n                                                string (date as in <code>format<\\/code>)<br>\\n                                                integer (offset in days from current date)                                            <\\/td>\\n                                            \\n                                            <td>false<\\/td>\\n                                            <td>Max. date<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos<\\/code><\\/td>\\n                                            <td>\'auto\', \'top\', \'bottom\'<\\/td>\\n                                            <td>\'auto\'<\\/td>\\n                                            <td>Position of the datepicker<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Init element manually<\\/h3>\\n\\n                            <pre><code class=\\\"javascript\\\"><span class=\\\"keyword\\\">var<\\/span> datepicker = UIkit.datepicker(element, { <span class=\\\"comment\\\">\\/* options *\\/<\\/span> });<\\/code><\\/pre>\\n\\n                            <h3>Events<\\/h3>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Name<\\/th>\\n                                            <th>Parameter<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>show.uk.datepicker<\\/code><\\/td>\\n                                            <td>event<\\/td>\\n                                            <td>On datepicker dropdown show<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>hide.uk.datepicker<\\/code><\\/td>\\n                                            <td>event<\\/td>\\n                                            <td>On datepicker dropdown hide<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>update.uk.datepicker<\\/code><\\/td>\\n                                            <td>event<\\/td>\\n                                            <td>On calendar rendering<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:54:11+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:54:11+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"322\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('438', '65', '1', '', '2017-09-14 14:38:22', '413', '11969', 'dcb56b082abab61bec497cdb588ac492d190d467', '{\"id\":65,\"asset_id\":529,\"title\":\"Tooltip\",\"alias\":\"tooltip\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Easily create a nicely looking tooltip.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To apply this component, add the <code>data-uk-tooltip<\\/code> attribute to an element. You also need to add a title attribute, whose value will represent your tooltip\'s text.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <p>\\n                                <button class=\\\"uk-button\\\" data-uk-tooltip=\\\"\\\" title=\\\"Bazinga!\\\">Hover me<\\/button>\\n                                <span data-uk-tooltip=\\\"\\\" title=\\\"Bazinga!\\\">Hover me<\\/span>\\n                            <\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">button<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-button\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-tooltip<\\/span> <span class=\\\"attribute\\\">title<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">button<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">span<\\/span> <span class=\\\"attribute\\\">data-uk-tooltip<\\/span> <span class=\\\"attribute\\\">title<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">span<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"alignment\\\"><a href=\\\"#alignment\\\" class=\\\"uk-link-reset\\\">Alignment<\\/a><\\/h2>\\n\\n                            <p>Add one of the following options to the <code>data-uk-tooltip<\\/code> attribute to adjust the tooltip\'s alignment.<\\/p>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Attribute<\\/th>\\n                                            <th>Description<\\/th>\\n                                            <th>Example<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>pos:\'top\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the top.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'top\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'top-left\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the top left.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'top-left\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'top-right\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the top right.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'top-right\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'bottom\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the bottom.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'bottom\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'bottom-left\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the bottom left.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'bottom-left\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'bottom-right\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the bottom right.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'bottom-right\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'left\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the left.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'left\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos:\'right\'<\\/code><\\/td>\\n                                            <td>Aligns the tooltip to the right.<\\/td>\\n                                            <td><button class=\\\"uk-button\\\" data-uk-tooltip=\\\"{pos:\'right\'}\\\" title=\\\"Bazinga!\\\">Hover me<\\/button><\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">button<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-button\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-tooltip<\\/span>=<span class=\\\"value\\\">\\\"{pos:\'bottom-left\'}\\\"<\\/span> <span class=\\\"attribute\\\">title<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">button<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <p>This is an example of how to set options via attribute:<\\/p>\\n\\n                            <pre><code class=\\\"ini\\\"><span class=\\\"setting\\\">data-uk-tooltip=<span class=\\\"value\\\"><span class=\\\"string\\\">\\\"{pos:\'bottom-left\'}\\\"<\\/span><\\/span><\\/span><\\/code><\\/pre>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>offset<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>5<\\/td>\\n                                            <td>Offset to the source element<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>pos<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'top\'<\\/td>\\n                                            <td>Tooltip position<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>animation<\\/code><\\/td>\\n                                            <td>boolean<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Fade in tooltip<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>delay<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>0<\\/td>\\n                                            <td>Delay tooltip show in ms<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>cls<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'\'<\\/td>\\n                                            <td>Custom class to add on show<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>activeClass<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'uk-active\'<\\/td>\\n                                            <td>Toggled active class<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:53:03+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:53:03+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"329\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('439', '66', '1', '', '2017-09-14 14:38:22', '413', '16648', '7ab784e4ed38397d97d6445e8f46dc1ca240632e', '{\"id\":66,\"asset_id\":530,\"title\":\"Sticky\",\"alias\":\"sticky\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Make elements remain at the top of the viewport, like a sticky navbar.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To create an element that remains at the top of the viewport when scrolling down the site, add the <code>data-uk-sticky<\\/code> attribute to that element.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-sticky-placeholder\\\" style=\\\"height: 52px; margin: 0px;\\\"><div class=\\\"uk-panel uk-panel-box\\\" data-uk-sticky=\\\"{boundary:\'#define-an-offset\'}\\\" style=\\\"margin: 0px;\\\">Stick to the top<\\/div><\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\" style=\\\"margin-top: 230px;\\\">Markup<\\/h3>\\n\\n                            <pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"define-an-offset\\\"><a href=\\\"#define-an-offset\\\" class=\\\"uk-link-reset\\\">Define an offset<\\/a><\\/h2>\\n\\n                            <p>You can also position the element below the viewport edge. For example, add the <code>data-uk-sticky=\\\"{top:100}\\\"<\\/code> attribute to create a margin of 100px.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-sticky-placeholder\\\" style=\\\"height: 52px; margin: 0px;\\\"><div class=\\\"uk-panel uk-panel-box\\\" data-uk-sticky=\\\"{top:100,boundary:\'#add-a-delay\'}\\\" style=\\\"margin: 0px;\\\">Stick 100px below the top<\\/div><\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\" style=\\\"margin-top: 230px;\\\">Markup<\\/h3>\\n\\n                            <pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{top:100}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"add-a-delay\\\"><a href=\\\"#add-a-delay\\\" class=\\\"uk-link-reset\\\">Add a delay<\\/a><\\/h2>\\n\\n                            <p>To add a delay to the element, so it becomes sticky only after scrolling a specified distance, you need to add a negative offset to the data attribute, e.g. <code>data-uk-sticky=\\\"{top:-200}\\\"<\\/code>. You can also add an animation from the <a href=\\\"animation.html\\\">Animation component<\\/a> in order to have the sticky element reappear smoothly.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-sticky-placeholder\\\" style=\\\"height: 52px; margin: 0px;\\\"><div class=\\\"uk-panel uk-panel-box uk-panel-box-primary\\\" data-uk-sticky=\\\"{top:-100, animation: \'uk-animation-slide-top\', boundary:\'#responsive-behavior\'}\\\" style=\\\"margin: 0px;\\\">Stick at the top but only after 100px scrolling<\\/div><\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\" style=\\\"margin-top: 230px;\\\">Markup<\\/h3>\\n\\n                            <pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{top:-200, animation: \'uk-animation-slide-top\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"responsive-behavior\\\"><a href=\\\"#responsive-behavior\\\" class=\\\"uk-link-reset\\\">Responsive behavior<\\/a><\\/h2>\\n\\n                            <p>You also have the possibility of disabling the sticky behavior for different devices by adding a breakpoint option to the data attribute, e.g. <code>data-uk-sticky=\\\"{media: 640}\\\"<\\/code>. Additionaly you can use any valid media query.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n                            <pre><code class=\\\"xml\\\"><span class=\\\"comment\\\">&lt;!-- This is basically a shortcode to define a min-width --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{media: 640}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n\\n<span class=\\\"comment\\\">&lt;!-- This is a media string using the min-width and orientation properties --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{media: \'(min-width: 640px) and (orientation: landscape)\'}&gt;...&lt;\\/div&gt;<\\/span><\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"sticky-boundary\\\"><a href=\\\"#sticky-boundary\\\" class=\\\"uk-link-reset\\\">Sticky boundary<\\/a><\\/h2>\\n\\n                            <p>You can define the boundary of a sticky element by setting the <code>boundary<\\/code> parameter. This keeps the sticky element within the dimensions of the boundary element.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin uk-grid uk-grid-match\\\">\\n                                <div class=\\\"uk-width-1-2\\\">\\n                                    <div class=\\\"uk-panel uk-panel-box uk-panel-box-secondary\\\" style=\\\"height:300px;\\\">\\n                                        <div class=\\\"uk-sticky-placeholder\\\" style=\\\"height: 52px; margin: 0px;\\\"><div class=\\\"uk-panel uk-panel-box\\\" data-uk-sticky=\\\"{boundary:true}\\\" style=\\\"margin: 0px;\\\">Sticky bound to parent container<\\/div><\\/div>\\n                                    <\\/div>\\n                                <\\/div>\\n                                <div class=\\\"uk-width-1-2\\\">\\n                                    <div class=\\\"uk-panel uk-panel-box uk-panel-box-secondary\\\">\\n                                        <div class=\\\"uk-sticky-placeholder\\\" style=\\\"height: 52px; margin: 0px;\\\"><div class=\\\"uk-panel uk-panel-box\\\" data-uk-sticky=\\\"{boundary:\'#boundary\'}\\\" style=\\\"margin: 0px;\\\">Sticky as long as bondary element is in view<\\/div><\\/div>\\n                                        <div id=\\\"boundary\\\" class=\\\"uk-panel uk-panel-box\\\" style=\\\"margin-top:50px;\\\">Boundary element<\\/div>\\n                                    <\\/div>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\" style=\\\"margin-top: 230px;\\\">Markup<\\/h3>\\n\\n                            <pre><code class=\\\"xml\\\"><span class=\\\"comment\\\">&lt;!-- Bind sticky to its parent element --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{boundary: true}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n\\n<span class=\\\"comment\\\">&lt;!-- Bind sticky to any element --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-sticky<\\/span>=<span class=\\\"value\\\">\\\"{boundary: \'#my-id\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <div id=\\\"javascript-options-container\\\" class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>top<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>0<\\/td>\\n                                            <td>Top offset whent sticky should be triggered<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>animation<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'\'<\\/td>\\n                                            <td>UIkit animation class<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>clsinit<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>uk-sticky-init<\\/td>\\n                                            <td>Init class when the element is sticky for the first time<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>clsactive<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>uk-active<\\/td>\\n                                            <td>Active class to add, when element is sticky<\\/td>\\n                                        <\\/tr>\\n                                        \\n                                        <tr>\\n                                            <td><code>clsinactive<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'\'<\\/td>\\n                                            <td>Class to add, when element is not sticky<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>getWidthFrom<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'\'<\\/td>\\n                                            <td>Css selector where to get the width from in sticky mode. By default it takes the width from the created wrapper element.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>media<\\/code><\\/td>\\n                                            <td>integer \\/ string<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Condition for the active status with a width as integer (e.g. 640) or a css media query<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>target<\\/code><\\/td>\\n                                            <td>boolean<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Make sure that a sticky element is not over a targeted element via location hash on dom-ready.<\\/td>\\n                                        <\\/tr>\\n                                        \\n                                        <tr>\\n                                            <td><code>showup<\\/code><\\/td>\\n                                            <td>boolean<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Show sticky element only when scrolling up.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>boundary<\\/code><\\/td>\\n                                            <td>mixed<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Set to <code>true<\\/code> to bind sticky to the parent or a Css selector to bind sticky to a specific element.<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Init element manually<\\/h3>\\n\\n                            <pre><code class=\\\"javascript\\\"><span class=\\\"keyword\\\">var<\\/span> sticky = UIkit.sticky(element, { <span class=\\\"comment\\\">\\/* options *\\/<\\/span> });<\\/code><\\/pre>\\n\\n                            <h3>Events<\\/h3>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Name<\\/th>\\n                                            <th>Parameter<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>active.uk.sticky<\\/code><\\/td>\\n                                            <td>event<\\/td>\\n                                            <td>Element getting sticky<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>inactive.uk.sticky<\\/code><\\/td>\\n                                            <td>event<\\/td>\\n                                            <td>Element leaving sticky mode<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:51:21+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:51:21+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"3\",\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"422\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('440', '67', '1', '', '2017-09-14 14:38:22', '413', '20873', 'df544cbc0e48830f8dbac1cf2a5d32a3af727d60', '{\"id\":67,\"asset_id\":531,\"title\":\"Parallax\",\"alias\":\"parallax\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Animate CSS properties depending on the scroll position of the document.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To apply this component, add the <code>data-uk-parallax<\\/code> attribute to a container element. Add an option with the desired animation target value for each CSS property you want to animate.<\\/p>\\n\\n                            <div class=\\\"uk-margin uk-text-contrast uk-text-center uk-flex uk-flex-center uk-flex-middle\\\" data-uk-parallax=\\\"{bg: \'-200\'}\\\" style=\\\"height: 350px; background-image: url(http:\\/\\/getuikit.com\\/docs\\/images\\/placeholder_800x400_2.jpg); background-size: 1223px 612px; background-position: 50% 0px; background-repeat: no-repeat;\\\">\\n                                <div class=\\\"uk-width-medium-1-2\\\">\\n                                    <h1 class=\\\"uk-text-contrast\\\">Heading<\\/h1>\\n                                    <p class=\\\"uk-text-large\\\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{bg: \'-200\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"options\\\"><a href=\\\"#options\\\" class=\\\"uk-link-reset\\\">Options<\\/a><\\/h2>\\n\\n                            <p>UIkit provides a number of options that you can add to the <code>data-uk-parallax<\\/code> attribute:<\\/p>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>x<\\/code><\\/td>\\n                                            <td>Animate translateX in pixels.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>xp<\\/code><\\/td>\\n                                            <td>Animate translateX in percent.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>y<\\/code><\\/td>\\n                                            <td>Animate translateY in pixels.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>yp<\\/code><\\/td>\\n                                            <td>Animate translateY in percent.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>bg<\\/code><\\/td>\\n                                            <td>Animate a background image.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>bgp<\\/code><\\/td>\\n                                            <td>Animate a background image in percent.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>rotate<\\/code><\\/td>\\n                                            <td>Animate rotation clockwise in degree.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>scale<\\/code><\\/td>\\n                                            <td>Animate scaling.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>color<\\/code><\\/td>\\n                                            <td>Animate color (needs start and stop value).<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>background-color<\\/code><\\/td>\\n                                            <td>Animate background-color (needs start and stop value).<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>border-color<\\/code><\\/td>\\n                                            <td>Animate border color (needs start and stop value).<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>opacity<\\/code><\\/td>\\n                                            <td>Animate the opacity.<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <p><span class=\\\"uk-badge\\\">NOTE<\\/span> You can basically animate any CSS property that has a single value, like width and height, by adding it to the attribute.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{y: \'-200\', opacity: \'0\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h3 id=\\\"start-stop-value\\\"><a href=\\\"#start-stop-value\\\" class=\\\"uk-link-reset\\\">Start and stop values<\\/a><\\/h3>\\n\\n                            <p>Properties are always animated from the current value to the target value which you set in the option. However, you can also define a start value yourself. This is done by passing a string to the option which contains two values separated by comma.<\\/p>\\n\\n                            <p><span class=\\\"uk-badge\\\">NOTE<\\/span> Some properties, like colors, require a start and a stop value!<\\/p>\\n\\n                            <h4 class=\\\"tm-article-subtitle\\\">Markup<\\/h4>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{x: \'-100,100\', \'background-color\': \'#EBF7FD,#FFF1F0\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"nested-animation\\\"><a href=\\\"#nested-animation\\\" class=\\\"uk-link-reset\\\">Nested animation<\\/a><\\/h2>\\n\\n                            <p>Using different animations for nested elements is a simple task. Just create another container within the first parallax container and add your options to a new <code>data-uk-parallax<\\/code> attribute.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin uk-text-contrast uk-text-center uk-flex uk-flex-center uk-flex-middle\\\" data-uk-parallax=\\\"{bg: -200}\\\" style=\\\"height: 350px; background-image: url(http:\\/\\/getuikit.com\\/docs\\/images\\/placeholder_800x400_1.jpg); background-size: 1223px 612px; background-position: 50% 0px; background-repeat: no-repeat;\\\">\\n                                <div class=\\\"uk-width-medium-1-2\\\" data-uk-parallax=\\\"{opacity: \'0,1\', scale: \'0,1\'}\\\" style=\\\"transform: scale(0); opacity: 0;\\\">\\n                                    <h1 class=\\\"uk-text-contrast\\\">Heading<\\/h1>\\n                                    <p class=\\\"uk-text-large\\\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{bg: -200}\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{opacity: \'0,1\', scale: \'0,1\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"target-option\\\"><a href=\\\"#target-option\\\" class=\\\"uk-link-reset\\\">Target Option<\\/a><\\/h2>\\n\\n                            <p>Usually, the animation lasts as long as the element itself is in the viewport. To start and stop the animation based on the viewport visibility of another element, use the <code>target<\\/code> option. This can be helpful when using nested animations.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin uk-text-contrast uk-text-center uk-flex uk-flex-center uk-flex-middle\\\" data-uk-parallax=\\\"{bg: -200}\\\" style=\\\"height: 350px; background-image: url(http:\\/\\/getuikit.com\\/docs\\/images\\/placeholder_800x400_2.jpg); background-size: 1223px 612px; background-position: 50% 0px; background-repeat: no-repeat;\\\">\\n                                <div class=\\\"uk-width-medium-1-2\\\" data-uk-parallax=\\\"{opacity: \'0,1\', scale: \'0,1\', target: \'#target-option\'}\\\" style=\\\"transform: scale(0); opacity: 0;\\\">\\n                                    <h1 class=\\\"uk-text-contrast\\\">Heading<\\/h1>\\n                                    <p class=\\\"uk-text-large\\\">This text is animated as long as the headline \\\"Target Option\\\" is in the viewport.<\\/p>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">id<\\/span>=<span class=\\\"value\\\">\\\"target-id\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{target: \'#target-id\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"velocity\\\"><a href=\\\"#velocity\\\" class=\\\"uk-link-reset\\\">Velocity<\\/a><\\/h2>\\n\\n                            <p>To adjust the easing of the animation, add the <code>velocity<\\/code> option.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div id=\\\"test-velocity\\\" class=\\\"uk-margin uk-text-contrast uk-text-center uk-flex uk-flex-center uk-flex-middle\\\" style=\\\"height: 350px; background-image: url(\'images\\/placeholder_800x400_3.jpg\'); background-size: cover;\\\">\\n                                <div class=\\\"uk-grid uk-flex-center uk-flex-middle\\\">\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'0.04\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">0.04<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'0.2\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">0.2<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'0.6\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">0.6<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'1\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">1<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'2\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">2<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'3\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">3<\\/div><\\/div>\\n                                    <div><div class=\\\"uk-panel uk-panel-box\\\" data-uk-parallax=\\\"{target:\'#test-velocity\', y: \'150\', velocity: \'4\', viewport: \'0.9\'}\\\" style=\\\"transform: translate3d(0px, 0px, 0px);\\\">4<\\/div><\\/div>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{velocity: \'0.5\'}\\\"<\\/span>&gt;<\\/span>\\n    ...\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"viewport\\\"><a href=\\\"#viewport\\\" class=\\\"uk-link-reset\\\">Viewport<\\/a><\\/h2>\\n\\n                            <p>Using the <code>viewport<\\/code> option, the animation duration can be adjusted. With the value <code>1<\\/code> or <code>false<\\/code> the animation lasts as long as the element is in the viewport. Setting it to <code>0.5<\\/code>, for example, animates the property only in the first half of the viewport.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin uk-text-contrast uk-text-center uk-flex uk-flex-center uk-flex-middle\\\" data-uk-parallax=\\\"{bg: -200}\\\" style=\\\"height: 350px; background-image: url(http:\\/\\/getuikit.com\\/docs\\/images\\/placeholder_800x400_1.jpg); background-size: 1223px 612px; background-position: 50% 0px; background-repeat: no-repeat;\\\">\\n                                <div class=\\\"uk-width-medium-1-2\\\" data-uk-parallax=\\\"{opacity: \'0,1\', scale: \'0,1\', viewport: \'0.5\'}\\\" style=\\\"transform: scale(0); opacity: 0;\\\">\\n                                    <h1 class=\\\"uk-text-contrast\\\">Heading<\\/h1>\\n                                    <p class=\\\"uk-text-large\\\">This text is animated until it reaches the middle of the viewport.<\\/p>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-parallax<\\/span>=<span class=\\\"value\\\">\\\"{viewport: \'0.5\'}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>velocity<\\/code><\\/td>\\n                                            <td>float<\\/td>\\n                                            <td>0.5<\\/td>\\n                                            <td>Animation velocity during scrolling<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>target<\\/code><\\/td>\\n                                            <td>mixed<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Element dimension reference for animation duration.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>viewport<\\/code><\\/td>\\n                                            <td>float (0 to 1)<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Animation range depending on the viewport.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>media<\\/code><\\/td>\\n                                            <td>integer \\/ string<\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Condition for the active status with a width as integer (e.g. 640) or a css media query<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Init element manually<\\/h3>\\n\\n                            <pre><code class=\\\"javascript\\\"><span class=\\\"keyword\\\">var<\\/span> parallax = UIkit.parallax(element, { <span class=\\\"comment\\\">\\/* options *\\/<\\/span> });<\\/code><\\/pre>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:48:47+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:48:47+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"395\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0'),
('441', '68', '1', '', '2017-09-14 14:38:22', '413', '107725', '911a90f559842f7f0b52be26bd29b8ee3ed08c18', '{\"id\":68,\"asset_id\":532,\"title\":\"Slideset\",\"alias\":\"slideset\",\"introtext\":\"<p class=\\\"uk-article-lead\\\">Create sets and groups of items, allowing to loop through the sets.<\\/p>\\n\\n                            <h2 id=\\\"usage\\\"><a href=\\\"#usage\\\" class=\\\"uk-link-reset\\\">Usage<\\/a><\\/h2>\\n\\n                            <p>To apply this component, add the <code>data-uk-slideset<\\/code> attribute to a container element. Add the <code>default<\\/code> option to the <code>data-uk-slideset<\\/code> attribute, to adjust the number of items within a set.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin\\\" data-uk-slideset=\\\"{default: 4}\\\">\\n                                <div class=\\\"uk-slidenav-position uk-margin\\\">\\n                                    <ul class=\\\"uk-slideset uk-grid uk-flex-center uk-grid-width-1-4\\\">\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:1\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoyL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:2\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDozL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:3\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo0L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NDwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:4\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo1L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:5\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo2L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:6\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo3L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:7\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo4L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+ODwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:8\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo5L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+OTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:9\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxMC9zaXplOjEwMApDcmVhdGVkIHdpdGggSG9sZGVyLmpzIDIuNS4yLgpMZWFybiBtb3JlIGF0IGh0dHA6Ly9ob2xkZXJqcy5jb20KKGMpIDIwMTItMjAxNSBJdmFuIE1hbG9waW5za3kgLSBodHRwOi8vaW1za3kuY28KLS0+PGRlZnMvPjxyZWN0IHdpZHRoPSI2MDAiIGhlaWdodD0iNDAwIiBmaWxsPSIjMEQ4RkRCIi8+PGc+PHRleHQgeD0iMjI1Ljg0Mzc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTA8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:10\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                    <\\/ul>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-previous\\\" data-uk-slideset-item=\\\"previous\\\"><\\/a>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-next\\\" data-uk-slideset-item=\\\"next\\\"><\\/a>\\n                                <\\/div>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{default: 4}\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-grid uk-slideset\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span> <span class=\\\"attribute\\\">alt<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span> <span class=\\\"attribute\\\">alt<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        ...\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"navigations\\\"><a href=\\\"#navigations\\\" class=\\\"uk-link-reset\\\">Navigations<\\/a><\\/h2>\\n\\n                            <p>To navigate through your slides, just use the <code>uk-slideset-nav<\\/code> class. This will dynamically create a navigation depending on the number of existing slides.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{default: 4}\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-grid uk-slideset\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slideset-nav\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <p>To switch to the adjacent slides, use the <code>data-uk-slideset-item<\\/code> attribute and set the attribute to <code>next<\\/code> and <code>previous<\\/code>. The elements with the <code>data-uk-slideset-item<\\/code> attribute need to be inside the <code>data-uk-slideset<\\/code> container.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{default: 4}\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-grid uk-slideset\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span> <span class=\\\"attribute\\\">href<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span><span class=\\\"attribute\\\">data-uk-slideset-item<\\/span>=<span class=\\\"value\\\">\\\"previous\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span> <span class=\\\"attribute\\\">href<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span><span class=\\\"attribute\\\">data-uk-slideset-item<\\/span>=<span class=\\\"value\\\">\\\"next\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h3 id=\\\"slide-dot-nav\\\"><a href=\\\"#slide-dot-nav\\\" class=\\\"uk-link-reset\\\">Slidenav and Dotnav<\\/a><\\/h3>\\n\\n                            <p>You can use any of the other UIkit components to navigate through a Slideset. For example the <a href=\\\"slidenav.html\\\">Slidenav<\\/a> and <a href=\\\"dotnav.html\\\">Dotnav<\\/a> can be used to style the slideset navigations as you can see below.<\\/p>\\n\\n                            <h4 class=\\\"tm-article-subtitle\\\">Example<\\/h4>\\n\\n                            <div class=\\\"uk-margin\\\" data-uk-slideset=\\\"{default: 4}\\\">\\n                                <div class=\\\"uk-slidenav-position uk-margin\\\">\\n                                    <ul class=\\\"uk-slideset uk-grid uk-flex-center uk-grid-width-1-4\\\">\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:1\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoyL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:2\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDozL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:3\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo0L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NDwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:4\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo1L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:5\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo2L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:6\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo3L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:7\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo4L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+ODwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:8\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo5L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+OTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:9\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxMC9zaXplOjEwMApDcmVhdGVkIHdpdGggSG9sZGVyLmpzIDIuNS4yLgpMZWFybiBtb3JlIGF0IGh0dHA6Ly9ob2xkZXJqcy5jb20KKGMpIDIwMTItMjAxNSBJdmFuIE1hbG9waW5za3kgLSBodHRwOi8vaW1za3kuY28KLS0+PGRlZnMvPjxyZWN0IHdpZHRoPSI2MDAiIGhlaWdodD0iNDAwIiBmaWxsPSIjMEQ4RkRCIi8+PGc+PHRleHQgeD0iMjI1Ljg0Mzc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTA8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:10\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                    <\\/ul>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-previous\\\" data-uk-slideset-item=\\\"previous\\\"><\\/a>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-next\\\" data-uk-slideset-item=\\\"next\\\"><\\/a>\\n                                <\\/div>\\n                                <ul class=\\\"uk-slideset-nav uk-dotnav uk-flex-center\\\"><li data-uk-slideset-item=\\\"0\\\" class=\\\"uk-active\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"1\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"2\\\"><a><\\/a><\\/li><\\/ul>\\n                            <\\/div>\\n\\n                            <h4 class=\\\"tm-article-subtitle\\\">Markup<\\/h4>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{default: 4}\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slidenav-position\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-grid uk-slideset\\\"<\\/span>&gt;<\\/span>\\n            <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n            <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span> <span class=\\\"attribute\\\">href<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slidenav uk-slidenav-previous\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-slideset-item<\\/span>=<span class=\\\"value\\\">\\\"previous\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span> <span class=\\\"attribute\\\">href<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slidenav uk-slidenav-next\\\"<\\/span> <span class=\\\"attribute\\\">data-uk-slideset-item<\\/span>=<span class=\\\"value\\\">\\\"next\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slideset-nav uk-dotnav uk-flex-center\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"responsive\\\"><a href=\\\"#responsive\\\" class=\\\"uk-link-reset\\\">Responsive items<\\/a><\\/h2>\\n\\n                            <p>The slideset supports media query based items visibility. Just add a breakpoint option, like <code>small<\\/code>, <code>medium<\\/code>, <code>large<\\/code> to the <code>data-uk-slideset<\\/code> attribute. Add the number of items you want to display from the breakpoint upwards.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin\\\" data-uk-slideset=\\\"{small: 2, medium: 4, large: 6}\\\">\\n                                <div class=\\\"uk-slidenav-position uk-margin\\\">\\n                                    <ul class=\\\"uk-slideset uk-grid uk-flex-center uk-grid-width-1-1 uk-grid-width-large-1-6 uk-grid-width-medium-1-4 uk-grid-width-small-1-2\\\">\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:1\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoyL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:2\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDozL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:3\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo0L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NDwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:4\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo1L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:5\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo2L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:6\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo3L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:7\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo4L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+ODwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:8\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo5L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+OTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:9\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxMC9zaXplOjEwMApDcmVhdGVkIHdpdGggSG9sZGVyLmpzIDIuNS4yLgpMZWFybiBtb3JlIGF0IGh0dHA6Ly9ob2xkZXJqcy5jb20KKGMpIDIwMTItMjAxNSBJdmFuIE1hbG9waW5za3kgLSBodHRwOi8vaW1za3kuY28KLS0+PGRlZnMvPjxyZWN0IHdpZHRoPSI2MDAiIGhlaWdodD0iNDAwIiBmaWxsPSIjMEQ4RkRCIi8+PGc+PHRleHQgeD0iMjI1Ljg0Mzc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTA8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:10\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                    <\\/ul>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-previous\\\" data-uk-slideset-item=\\\"previous\\\"><\\/a>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-next\\\" data-uk-slideset-item=\\\"next\\\"><\\/a>\\n                                <\\/div>\\n                                <ul class=\\\"uk-slideset-nav uk-dotnav uk-flex-center\\\"><li data-uk-slideset-item=\\\"0\\\" class=\\\"uk-active\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"1\\\"><a><\\/a><\\/li><\\/ul>\\n                            <\\/div>\\n\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{small: 2, medium: 4, large: 6}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"animations\\\"><a href=\\\"#animations\\\" class=\\\"uk-link-reset\\\">Animations<\\/a><\\/h2>\\n\\n                            <p>There is a batch of animations which can be used to display the next set of items. Just add the <code>animation<\\/code> option to the <code>data-uk-slideset<\\/code> and set it to the desired animation. The animation duration can also be adjusted by using the <code>duration<\\/code> option.<\\/p>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Animation<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>fade<\\/code><\\/td>\\n                                            <td>The items fade in and out.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>scale<\\/code><\\/td>\\n                                            <td>The items scale up and down.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>slide-horizontal<\\/code><\\/td>\\n                                            <td>The items slide to the side.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>slide-vertical<\\/code><\\/td>\\n                                            <td>The items slide vertically.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>slide-top<\\/code><\\/td>\\n                                            <td>The items slide to and from the top.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>slide-bottom<\\/code><\\/td>\\n                                            <td>The items slide to and from the bottom.<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <select id=\\\"slideset-animation\\\">\\n                                <option value=\\\"fade\\\">fade<\\/option>\\n                                <option value=\\\"scale\\\">scale<\\/option>\\n                                <option value=\\\"slide-horizontal\\\">slide-horizontal<\\/option>\\n                                <option value=\\\"slide-vertical\\\">slide-vertical<\\/option>\\n                                <option value=\\\"slide-top\\\">slide-top<\\/option>\\n                                <option value=\\\"slide-bottom\\\">slide-bottom<\\/option>\\n                            <\\/select>\\n\\n                            <div class=\\\"uk-margin\\\" data-uk-slideset=\\\"{small: 2, medium: 4}\\\">\\n                                <div class=\\\"uk-slidenav-position uk-margin\\\">\\n                                    <ul class=\\\"uk-slideset uk-grid uk-flex-center uk-grid-width-1-1 uk-grid-width-medium-1-4 uk-grid-width-small-1-2\\\">\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:1\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoyL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:2\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDozL3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:3\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo0L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NDwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:4\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo1L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:5\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo2L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:6\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo3L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+NzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:7\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo4L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+ODwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:8\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDo5L3NpemU6MTAwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyNjIuOTIxODc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+OTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:9\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDoxMC9zaXplOjEwMApDcmVhdGVkIHdpdGggSG9sZGVyLmpzIDIuNS4yLgpMZWFybiBtb3JlIGF0IGh0dHA6Ly9ob2xkZXJqcy5jb20KKGMpIDIwMTItMjAxNSBJdmFuIE1hbG9waW5za3kgLSBodHRwOi8vaW1za3kuY28KLS0+PGRlZnMvPjxyZWN0IHdpZHRoPSI2MDAiIGhlaWdodD0iNDAwIiBmaWxsPSIjMEQ4RkRCIi8+PGc+PHRleHQgeD0iMjI1Ljg0Mzc1IiB5PSIyNDQuNyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMDBwdCI+MTA8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:10\\/size:100\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                    <\\/ul>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-previous\\\" data-uk-slideset-item=\\\"previous\\\"><\\/a>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-next\\\" data-uk-slideset-item=\\\"next\\\"><\\/a>\\n                                <\\/div>\\n                                <ul class=\\\"uk-slideset-nav uk-dotnav uk-flex-center\\\"><li data-uk-slideset-item=\\\"0\\\" class=\\\"uk-active\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"1\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"2\\\"><a><\\/a><\\/li><\\/ul>\\n                            <\\/div>\\n\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>=<span class=\\\"value\\\">\\\"{animation: \'scale\', duration: 200}\\\"<\\/span>&gt;<\\/span>...<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"filter\\\"><a href=\\\"#filter\\\" class=\\\"uk-link-reset\\\">Filter<\\/a><\\/h2>\\n\\n                            <p>You can also filter your slideset so that only particular items will be displayed. To do so, add the <code>data-uk-filter<\\/code> attribute to each control to define the category you want to filter. Then you also need to add the <code>data-uk-filter<\\/code> attribute to each slideset item to define what category the item belongs to.<\\/p>\\n\\n                            <p><span class=\\\"uk-badge\\\">NOTE<\\/span> The controls can be included in the slideset or referenced by adding the <code>controls<\\/code> option to the <code>data-uk-slideset<\\/code> attribute and passing the id to the option.<\\/p>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Example<\\/h3>\\n\\n                            <div class=\\\"uk-margin\\\" data-uk-slideset=\\\"{animation: \'scale\', medium:4}\\\">\\n                                <ul class=\\\"uk-subnav uk-subnav-pill\\\">\\n                                    <li data-uk-filter=\\\"\\\" class=\\\"uk-active\\\"><a>All<\\/a><\\/li>\\n                                    <li data-uk-filter=\\\"filter-a\\\"><a>Filter A<\\/a><\\/li>\\n                                    <li data-uk-filter=\\\"filter-b\\\"><a>Filter B<\\/a><\\/li>\\n                                <\\/ul>\\n                                <div class=\\\"uk-slidenav-position uk-margin\\\">\\n                                    <ul class=\\\"uk-slideset uk-grid uk-flex-center uk-grid-width-1-1 uk-grid-width-medium-1-4\\\">\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDEKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+MTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 1\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDIKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+MjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 2\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDMKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+MzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 3\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"\\\" class=\\\"uk-active\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDQKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+NDwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 4\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDUKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+NTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 5\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDYKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+NjwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 6\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDcKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+NzwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 7\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDgKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+ODwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 8\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDkKQ3JlYXRlZCB3aXRoIEhvbGRlci5qcyAyLjUuMi4KTGVhcm4gbW9yZSBhdCBodHRwOi8vaG9sZGVyanMuY29tCihjKSAyMDEyLTIwMTUgSXZhbiBNYWxvcGluc2t5IC0gaHR0cDovL2ltc2t5LmNvCi0tPjxkZWZzLz48cmVjdCB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgZmlsbD0iIzBEOEZEQiIvPjxnPjx0ZXh0IHg9IjIyNS42NTYyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+RmlsdGVyPC90ZXh0Pjx0ZXh0IHg9IjMzNC40NTMxMjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkE8L3RleHQ+PHRleHQgeD0iMjM2Ljc1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMzMCIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+OTwvdGV4dD48L2c+PC9zdmc+\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 9\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-a\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvc2t5L2F1dG8vdGV4dDpGaWx0ZXIgQSBcbiBJdGVtIDEwCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMwRDhGREIiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6I0ZGRkZGRjtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5BPC90ZXh0Pjx0ZXh0IHg9IjIyNS42MjUiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojRkZGRkZGO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkl0ZW08L3RleHQ+PHRleHQgeD0iMzE4Ljg3NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiNGRkZGRkY7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+MTA8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter A \\\\n Item 10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/sky\\/auto\\/text:Filter A \\\\n Item 10\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSAxCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjE8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 1 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 1\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSAyCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjI8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 2 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 2\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSAzCkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjM8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 3 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 3\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA0CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjQ8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 4 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 4\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA1CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjU8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 5 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 5\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA2CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjY8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 6 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 6\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA3CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjc8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 7 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 7\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA4CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjg8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 8 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 8\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSA5CkNyZWF0ZWQgd2l0aCBIb2xkZXIuanMgMi41LjIuCkxlYXJuIG1vcmUgYXQgaHR0cDovL2hvbGRlcmpzLmNvbQooYykgMjAxMi0yMDE1IEl2YW4gTWFsb3BpbnNreSAtIGh0dHA6Ly9pbXNreS5jbwotLT48ZGVmcy8+PHJlY3Qgd2lkdGg9IjYwMCIgaGVpZ2h0PSI0MDAiIGZpbGw9IiMzOURCQUMiLz48Zz48dGV4dCB4PSIyMjUuNjU2MjUiIHk9IjE5MS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPkZpbHRlcjwvdGV4dD48dGV4dCB4PSIzMzQuNDUzMTI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5CPC90ZXh0Pjx0ZXh0IHg9IjIzNi43NSIgeT0iMjM1LjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+SXRlbTwvdGV4dD48dGV4dCB4PSIzMzAiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjk8L3RleHQ+PC9nPjwvc3ZnPg==\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 9 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 9\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                        <li data-uk-filter=\\\"filter-b\\\" style=\\\"display: none;\\\"><img src=\\\"data:image\\/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI\\/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjAwIiBoZWlnaHQ9IjQwMCIgdmlld0JveD0iMCAwIDYwMCA0MDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjwhLS0KU291cmNlIFVSTDogaG9sZGVyLmpzLzYwMHg0MDAvdmluZS9hdXRvL3RleHQ6RmlsdGVyIEIgXG4gSXRlbSAxMApDcmVhdGVkIHdpdGggSG9sZGVyLmpzIDIuNS4yLgpMZWFybiBtb3JlIGF0IGh0dHA6Ly9ob2xkZXJqcy5jb20KKGMpIDIwMTItMjAxNSBJdmFuIE1hbG9waW5za3kgLSBodHRwOi8vaW1za3kuY28KLS0+PGRlZnMvPjxyZWN0IHdpZHRoPSI2MDAiIGhlaWdodD0iNDAwIiBmaWxsPSIjMzlEQkFDIi8+PGc+PHRleHQgeD0iMjI1LjY1NjI1IiB5PSIxOTEuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5GaWx0ZXI8L3RleHQ+PHRleHQgeD0iMzM0LjQ1MzEyNSIgeT0iMTkxLjIiIHN0eWxlPSJmaWxsOiMxRTI5MkM7Zm9udC13ZWlnaHQ6Ym9sZDtmb250LWZhbWlseTpBcmlhbCwgSGVsdmV0aWNhLCBPcGVuIFNhbnMsIHNhbnMtc2VyaWYsIG1vbm9zcGFjZTtmb250LXNpemU6MzBwdCI+QjwvdGV4dD48dGV4dCB4PSIyMjUuNjI1IiB5PSIyMzUuMiIgc3R5bGU9ImZpbGw6IzFFMjkyQztmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZTozMHB0Ij5JdGVtPC90ZXh0Pjx0ZXh0IHg9IjMxOC44NzUiIHk9IjIzNS4yIiBzdHlsZT0iZmlsbDojMUUyOTJDO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjMwcHQiPjEwPC90ZXh0PjwvZz48L3N2Zz4=\\\" width=\\\"600\\\" height=\\\"400\\\" alt=\\\"Filter B \\\\n Item 10 [600x400]\\\" data-src=\\\"holder.js\\/600x400\\/vine\\/auto\\/text:Filter B \\\\n Item 10\\\" data-holder-rendered=\\\"true\\\"><\\/li>\\n                                    <\\/ul>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-previous\\\" data-uk-slideset-item=\\\"previous\\\"><\\/a>\\n                                    <a href=\\\"#\\\" class=\\\"uk-slidenav uk-slidenav-next\\\" data-uk-slideset-item=\\\"next\\\"><\\/a>\\n                                <\\/div>\\n                                <ul class=\\\"uk-slideset-nav uk-dotnav uk-flex-center\\\"><li data-uk-slideset-item=\\\"0\\\" class=\\\"uk-active\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"1\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"2\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"3\\\"><a><\\/a><\\/li><li data-uk-slideset-item=\\\"4\\\"><a><\\/a><\\/li><\\/ul>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Markup<\\/h3>\\n\\n<pre><code class=\\\"xml\\\"><span class=\\\"comment\\\">&lt;!-- The controls are included in the Slideset --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-a\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-b\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-grid uk-slideset\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-a\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-b\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span>\\n\\n<span class=\\\"comment\\\">&lt;!-- The controls are outside the Slideset --&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">id<\\/span>=<span class=\\\"value\\\">\\\"my-id\\\"<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-a\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-b\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">a<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n\\n<span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">div<\\/span> <span class=\\\"attribute\\\">data-uk-slideset<\\/span>\\\"{<span class=\\\"attribute\\\">controls:<\\/span> \'#<span class=\\\"attribute\\\">my-id<\\/span>\'}\\\"&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">ul<\\/span> <span class=\\\"attribute\\\">class<\\/span>=<span class=\\\"value\\\">\\\"uk-slideset\\\"<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-a\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n        <span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">li<\\/span> <span class=\\\"attribute\\\">data-uk-filter<\\/span>=<span class=\\\"value\\\">\\\"filter-b\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;<span class=\\\"title\\\">img<\\/span> <span class=\\\"attribute\\\">src<\\/span>=<span class=\\\"value\\\">\\\"\\\"<\\/span>&gt;<\\/span><span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">li<\\/span>&gt;<\\/span>\\n    <span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">ul<\\/span>&gt;<\\/span>\\n<span class=\\\"tag\\\">&lt;\\/<span class=\\\"title\\\">div<\\/span>&gt;<\\/span><\\/code><\\/pre>\\n\\n                            <hr class=\\\"uk-article-divider\\\">\\n\\n                            <h2 id=\\\"javascript-options\\\"><a href=\\\"#javascript-options\\\" class=\\\"uk-link-reset\\\">JavaScript options<\\/a><\\/h2>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Option<\\/th>\\n                                            <th>Possible value<\\/th>\\n                                            <th>Default<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>default<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>1<\\/td>\\n                                            <td>Default visible items in a set<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>small<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>null<\\/td>\\n                                            <td>Visible items in a set at small breakpoint<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>medium<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>null<\\/td>\\n                                            <td>Visible items in a set at medium breakpoint<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>large<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>null<\\/td>\\n                                            <td>Visible items in a set at large breakpoint<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>xlarge<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>null<\\/td>\\n                                            <td>Visible items in a set at xlarge breakpoint<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>animation<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'fade\'<\\/td>\\n                                            <td>Animation name<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>duration<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>200<\\/td>\\n                                            <td>Animation duration in ms<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>delay<\\/code><\\/td>\\n                                            <td>integer<\\/td>\\n                                            <td>100<\\/td>\\n                                            <td>Animation delay between items in a set<\\/td>\\n                                        <\\/tr>\\n                                        \\n                                        <tr>\\n                                            <td><code>filter<\\/code><\\/td>\\n                                            <td>string<\\/td>\\n                                            <td>\'\'<\\/td>\\n                                            <td>Items filter<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>autoplay<\\/code><\\/td>\\n                                            <td>false<\\/td>\\n                                            <td>Defines whether or not the slideset items should switch automatically.<\\/td>\\n                                        <\\/tr>\\n                                        \\n                                        <tr>\\n                                            <td><code>pauseOnHover<\\/code><\\/td>\\n                                            <td>true<\\/td>\\n                                            <td>Pause autoplay when hovering a slideset.<\\/td>\\n                                        <\\/tr>\\n                                        <tr>\\n                                            <td><code>autoplayInterval<\\/code><\\/td>\\n                                            <td>7000<\\/td>\\n                                            <td>Defines the timespan between switching slideset items.<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\\n\\n                            <h3 class=\\\"tm-article-subtitle\\\">Init element manually<\\/h3>\\n\\n                            <pre><code class=\\\"javascript\\\"><span class=\\\"keyword\\\">var<\\/span> slideset = UIkit.slideset(element, { <span class=\\\"comment\\\">\\/* options *\\/<\\/span> });<\\/code><\\/pre>\\n\\n                            <h3>Events<\\/h3>\\n\\n                            <div class=\\\"uk-overflow-container\\\">\\n                                <table class=\\\"uk-table uk-table-striped uk-text-nowrap\\\">\\n                                    <thead>\\n                                        <tr>\\n                                            <th>Name<\\/th>\\n                                            <th>Parameter<\\/th>\\n                                            <th>Description<\\/th>\\n                                        <\\/tr>\\n                                    <\\/thead>\\n                                    <tbody>\\n                                        <tr>\\n                                            <td><code>show.uk.slideset<\\/code><\\/td>\\n                                            <td>event, set<\\/td>\\n                                            <td>On set show<\\/td>\\n                                        <\\/tr>\\n                                    <\\/tbody>\\n                                <\\/table>\\n                            <\\/div>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":8,\"created\":\"2015-12-02T11:45:33+00:00\",\"created_by\":414,\"created_by_alias\":\"\",\"modified\":\"2017-09-14 14:38:22\",\"modified_by\":414,\"checked_out\":0,\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2015-12-02T11:45:33+00:00\",\"publish_down\":\"-0001-11-30T00:00:00+00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"j2product\\\":{\\\"product_enabled\\\":0,\\\"item_sku\\\":\\\"\\\",\\\"item_price\\\":0,\\\"special_price\\\":0,\\\"item_shipping\\\":0},\\\"item_tax\\\":0,\\\"item_metrics\\\":{\\\"item_length\\\":0,\\\"item_width\\\":0,\\\"item_height\\\":0,\\\"item_length_class_id\\\":0,\\\"item_weight\\\":0,\\\"item_weight_class_id\\\":0},\\\"item_cart_text\\\":\\\"\\\"}\",\"version\":\"2\",\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"391\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', '0');
