_This note is for developers of the AMP PHP Library only. You don't need to read it if you are a consumer of the library_

_Prerequisites_: You should have cloned and installed for development the [Lullabot fork](https://github.com/Lullabot/amphtml) of the [ampproject/amphtml](https://github.com/ampproject/amphtml). Please be sure to switch to the `php-validator-generated` branch. Follow the instructions under "Building a Custom Validator" [here](https://github.com/Lullabot/amphtml/tree/php-validator-generated/validator) and run [`python build.py`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/build.py) when in `cd`-ed in the `validator` folder in your console.

#### What is the [`validator-generated.php`](https://github.com/Lullabot/amp-library/blob/master/src/Spec/validator-generated.php) file in this directory and how is it created?

The [AMP HTML](https://www.ampproject.org/) standard is a complicated set of rules that specifies for each HTML tag (e.g. `<script>`) what attributes (and values) it can _can_ have or _must_ have, what are its permissible parent or ancestor tags and so forth. This is summarized in the [protocol](https://developers.google.com/protocol-buffers/) buffer [specification](https://github.com/ampproject/amphtml/blob/master/validator/validator-main.protoascii). 

Google has written a [validator](https://github.com/ampproject/amphtml/blob/master/validator/validator.js) in JavaScript (we will often refer to this validator as the "canonical validator"). The job of this validator is to report problems with AMP HTML standard compliance on HTML documents you feed it. The canonical validator does not understand the protocol buffer [specification](https://github.com/ampproject/amphtml/blob/master/validator/validator-main.protoascii) referred to above. So this `.protoascii` file must be converted to JavaScript objects to be of any use to the main [validator](https://github.com/ampproject/amphtml/blob/master/validator/validator.js) code. This happens when `python build.py` is executed when you're `cd`ed in the [validator folder](https://github.com/ampproject/amphtml/tree/master/validator). The code that is eventually executed here is [`validator_gen.py`](https://github.com/ampproject/amphtml/blob/master/validator/validator_gen.py)

Our [AMP PHP library](https://github.com/Lullabot/amp-library) is a ported subset of the canonical validator. Our validator is obviously written in PHP. Now, we need to consume a _representation_ of the [specification](https://github.com/ampproject/amphtml/blob/master/validator/validator-main.protoascii) analogous to how the canonical JavaScript validator does. This is precisely what [`validator-generated.php`](https://github.com/Lullabot/amp-library/blob/master/src/Spec/validator-generated.php) is: a representation of the `.protoascii` AMP HTML specification. Our PHP validator code consumes this PHP code to build an internal set of objects and classes corresponing to the various tags and attributes in HTML (and what these tags and attributes are "allowed"). These objects and classes are then used by the PHP validator code.

So when you're using the Lullabot fork of [ampproject/amphtml](https://github.com/ampproject/amphtml) and run [`python build.py`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/build.py) (this file is customized in our fork), it, in turn runs file [`validator_gen_php.py`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/validator_gen_php.py). _This_ is the python file that generates the representation in PHP (this file is _only_ available in our fork)

Specifically when [`build.py`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/build.py) is run, it runs [`validator_gen_php.py`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/validator_gen_php.py) which in turns outputs [`validator-generated.php`](https://github.com/Lullabot/amphtml/blob/php-validator-generated/validator/validator_gen_php.py) in the `validator/dist` folder. We simply copy this `validator-generated.php` file into the AMP PHP library `src/Spec` folder. Once this is done, there is no active dependency on the [ampproject/amphtml](https://github.com/ampproject/amphtml) project to run the AMP PHP library. You would only regenerate this file infrequently when you want to synchronize our PHP validator with the canonical validator. Note that this method allows our validator to "auto-magically" pick up new rules for tags when it gets a fresh version of `validator-generated.php`. Of course, this is not perfect for all cases -- sometimes there is no alternative to actually changing our validator code if the canonical validator has picked up some more complicated changes.
