<?php
/**
 * @package         Content Templater
 * @version         8.5.4
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2020 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Object\CMSObject as JObject;
use Joomla\CMS\Toolbar\Toolbar as JToolbar;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Plugin\System\ContentTemplater\Buttons as CT_Buttons;

/**
 ** Plugin that places the button
 */
class PlgButtonContentTemplaterHelper
	extends \RegularLabs\Library\EditorButtonHelper
{
	/**
	 * Display the button
	 *
	 * @param string $editor_name
	 * @param string $content
	 *
	 * @return JObject|null A button object
	 */
	public function render($editor_name)
	{
		$data = CT_Buttons::get($editor_name);

		if (empty($data))
		{
			return null;
		}

		RL_Document::loadEditorButtonDependencies();
		JHtml::_('bootstrap.popover');

		RL_Document::script('contenttemplater/script.min.js', '8.5.4');
		RL_Document::style('contenttemplater/button.min.css', '8.5.4');

		$name = 'rl_ct_button-' . ($editor_name);

		$buttons = [];

		foreach ($data as $button)
		{
			$btn = new JObject;

			$btn->modal   = $button->modal;
			$btn->class   = $button->class . ' rl_button_contenttemplater rl_button_contenttemplater_' . ($button->id ?: 'main');
			$btn->text    = $button->text;
			$btn->name    = $button->name . ' ' . $name;
			$btn->link    = $button->link;
			$btn->onclick = $button->onclick ? $button->onclick . 'return false;' : '';
			$btn->options = $button->options;

			$buttons[] = $btn;
		}


		return $buttons;
	}
}
