<?php
/**
 * @package         Dummy Content
 * @version         7.3.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2020 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed as JAccessExceptionNotallowed;
use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Language as RL_Language;
use RegularLabs\Library\Parameters as RL_Parameters;
use RegularLabs\Library\RegEx as RL_RegEx;
use RegularLabs\Plugin\System\DummyContent\Diacritics as DC_Diacritics;
use RegularLabs\Plugin\System\DummyContent\Image as DC_Image;
use RegularLabs\Plugin\System\DummyContent\Text as DC_Text;
use RegularLabs\Plugin\System\DummyContent\WordList as DC_WordList;

require_once JPATH_PLUGINS . '/system/dummycontent/vendor/autoload.php';

$params = RL_Parameters::getInstance()->getPluginParams('dummycontent');

if (RL_Document::isClient('site'))
{
	if ( ! $params->enable_frontend)
	{
		throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
	}
}

(new PlgButtonDummyContentPopup)->render($params);

class PlgButtonDummyContentPopup
{
	var $params  = null;
	var $helpers = [];

	public function render(&$params)
	{
		$this->params = $params;

		if (JFactory::getApplication()->input->getInt('generate_content'))
		{
			$this->generateContent();

			return;
		}

		$this->showForm();
	}

	function generateContent()
	{
		$type  = JFactory::getApplication()->input->getCmd('type', $this->params->type);
		$count = JFactory::getApplication()->input->getInt('count', isset($this->params->{$type . '_count'}) ? $this->params->{$type . '_count'} : 5);


		switch ($type)
		{
			case 'paragraphs':
				$text = DC_Text::paragraphs((int) $count);
				break;
			case 'sentences':
				$text = DC_Text::sentences((int) $count);
				break;
			case 'words':
				$text = DC_Text::words((int) $count);
				break;
			case 'list':
				$type = JFactory::getApplication()->input->getCmd('list_type', $this->params->list_type);
				$text = DC_Text::alist((int) $count, $type);
				break;
			case 'title':
				$text = DC_Text::title((int) $count);
				break;
			case 'heading':
				$text = DC_Text::heading((int) $count);
				break;
			case 'email':
				$text = DC_Text::email();
				break;
			case 'image':
				$text = $this->generateImage();
				break;
			case 'kitchensink':
			default:
				$text = DC_Text::kitchensink();
				break;
		}

		echo $text;
		die();
	}

	function generateImage()
	{
		$options          = (object) [];
		$options->width   = JFactory::getApplication()->input->getCmd('width', $this->params->image_width);
		$options->height  = JFactory::getApplication()->input->getCmd('height', $this->params->image_height);
		$options->service = JFactory::getApplication()->input->getCmd('image_service', $this->params->image_service);

		return DC_Image::render($options);
	}

	function showForm()
	{
		// load the admin language file

		RL_Language::load('plg_system_regularlabs');
		RL_Language::load('plg_editors-xtd_dummycontent');
		RL_Language::load('plg_system_dummycontent');

		RL_Document::loadPopupDependencies();

		$editor = JFactory::getApplication()->input->getString('name', 'text');
		// Remove any dangerous character to prevent cross site scripting
		$editor = RL_RegEx::replace('[\'\";\s]', '', $editor);

		$default_type = strtolower($this->params->type);

		$types = [
			'kitchensink' => 'icon-archive',
			'paragraphs'  => 'icon-paragraph-left',
			'sentences'   => 'icon-menu-3',
			'words'       => 'icon-grid-2',
			'list'        => 'icon-list-2',
			'title'       => 'icon-minus-2',
			'heading'     => 'icon-tag',
			'email'       => 'icon-envelope',
		];
		?>
		<div class="header">
			<div class="container-fluid">
				<h1 class="page-title">
					<span class="icon-reglab icon-dummycontent"></span>
					<?php echo JText::_('DUMMYCONTENT'); ?>
				</h1>
			</div>
		</div>

		<div class="subhead">
			<div class="container-fluid">
				<div class="row-fluid">
					<div class="btn-toolbar" id="toolbar">
						<div class="btn-wrapper">
							<div class="btn-group" id="toolbar-apply">
								<button href="#" onclick="RegularLabsDummyContent.insertContent();return false;" class="btn btn-small btn-success">
									<span class="icon-reglab icon-dummycontent"></span> <?php echo JText::_('DC_INSERT_CONTENT') ?>
								</button>
							</div>

							<div class="btn-group" id="toolbar-apply">
								<button href="#" onclick="RegularLabsDummyContent.insertTag();return false;" class="btn btn-small btn-primary">
									{...} <?php echo JText::_('DC_INSERT_TAG') ?>
								</button>
							</div>

							<div class="btn-group" id="toolbar-cancel">
								<button href="#" onclick="window.parent.SqueezeBox.close();" class="btn btn-small">
									<span class="icon-cancel "></span> <?php echo JText::_('JCANCEL') ?>
								</button>
							</div>

							<?php if (RL_Document::isClient('administrator') && JFactory::getUser()->authorise('core.admin', 1)) : ?>
								<div class="btn-wrapper" id="toolbar-options">
									<button onclick="window.open('index.php?option=com_plugins&filter_folder=system&filter_search=<?php echo JText::_('DUMMYCONTENT') ?>');"
									        class="btn btn-small">
										<span class="icon-options"></span> <?php echo JText::_('JOPTIONS') ?>
									</button>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div style="margin-bottom: 20px"></div>

		<div class="container-fluid container-main">
			<form action="" method="post" name="adminForm" id="adminForm">

				<div class="form-vertical row-fluid">
					<div class="span6">
						<h3 class="page-header">
							<?php echo JText::_('DC_CONTENT_TYPE'); ?>
						</h3>

						<br>

						<div class="control-group">

							<div class="controls">
								<fieldset id="type" class="radio">
									<input type="radio" id="type_default" class="toggler" name="type"
									       value="default" checked="checked">
									<label for="type_default">
										<span class="icon-star"></span>
										<?php echo JText::_('JDEFAULT'); ?>
										<span class="ghosted">
											[ <?php echo JText::_('DC_' . strtoupper($default_type)); ?> ]
										</span>
									</label>

									<br>

									<?php foreach ($types as $type => $icon) : ?>
										<input type="radio" id="type_<?php echo $type; ?>" class="toggler" name="type"
										       value="<?php echo $type; ?>">
										<label for="type_<?php echo $type; ?>">
											<span class="<?php echo $icon; ?>"></span>
											<?php echo JText::_('DC_' . strtoupper($type)); ?>
										</label>
									<?php endforeach; ?>
								</fieldset>
							</div>
						</div>
					</div>

					<div class="span6">
						<h3 class="page-header">
							<?php echo JText::_('JOPTIONS'); ?>
						</h3>

						<br>

						<div rel="type_paragraphs" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="paragraphs_count-lbl" for="paragraphs_count" class="control-label">
									<?php echo JText::_('DC_PARAGRAPHS_COUNT'); ?>
								</label>

								<div class="controls">
									<select name="paragraphs_count" id="paragraphs_count" class="input-mini">
										<option value="1" <?php echo $this->params->paragraphs_count == 1 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J1'); ?>
										</option>
										<option value="2" <?php echo $this->params->paragraphs_count == 2 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J2'); ?>
										</option>
										<option value="3" <?php echo $this->params->paragraphs_count == 3 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J3'); ?>
										</option>
										<option value="4" <?php echo $this->params->paragraphs_count == 4 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J4'); ?>
										</option>
										<option value="5" <?php echo $this->params->paragraphs_count == 5 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J5'); ?>
										</option>
										<option value="6" <?php echo $this->params->paragraphs_count == 6 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J6'); ?>
										</option>
										<option value="7" <?php echo $this->params->paragraphs_count == 7 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J7'); ?>
										</option>
										<option value="8" <?php echo $this->params->paragraphs_count == 8 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J8'); ?>
										</option>
										<option value="9" <?php echo $this->params->paragraphs_count == 9 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J9'); ?>
										</option>
										<option value="10" <?php echo $this->params->paragraphs_count == 10 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J10'); ?>
										</option>
									</select>
								</div>
							</div>

							<hr>
						</div>

						<div rel="type_sentences" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="paragraphs_count-lbl" for="sentences_count" class="control-label">
									<?php echo JText::_('DC_SENTENCES_COUNT'); ?>
								</label>

								<div class="controls">
									<input type="text" name="sentences_count" id="sentences_count" class="input-mini"
									       value="<?php echo $this->params->sentences_count; ?>">
								</div>
							</div>

							<hr>
						</div>

						<div rel="type_words" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="paragraphs_count-lbl" for="words_count" class="control-label">
									<?php echo JText::_('DC_WORDS_COUNT'); ?>
								</label>

								<div class="controls">
									<input type="text" name="words_count" id="words_count" class="input-mini" value="<?php echo $this->params->words_count; ?>">
								</div>
							</div>

							<hr>
						</div>

						<div rel="type_list" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="list_count-lbl" for="words_count" class="control-label">
									<?php echo JText::_('DC_LIST_ITEM_COUNT'); ?>
								</label>

								<div class="controls">
									<select name="list_count" id="list_count">
										<option value="random" <?php echo $this->params->list_count == 'random' ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('RL_RANDOM'); ?>
										</option>
										<option value="2" <?php echo $this->params->list_count == 2 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J2'); ?>
										</option>
										<option value="3" <?php echo $this->params->list_count == 3 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J3'); ?>
										</option>
										<option value="4" <?php echo $this->params->list_count == 4 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J4'); ?>
										</option>
										<option value="5" <?php echo $this->params->list_count == 5 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J5'); ?>
										</option>
										<option value="6" <?php echo $this->params->list_count == 6 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J6'); ?>
										</option>
										<option value="7" <?php echo $this->params->list_count == 7 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J7'); ?>
										</option>
										<option value="8" <?php echo $this->params->list_count == 8 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J8'); ?>
										</option>
										<option value="9" <?php echo $this->params->list_count == 9 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J9'); ?>
										</option>
										<option value="10" <?php echo $this->params->list_count == 10 ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('J10'); ?>
										</option>
									</select>
								</div>
							</div>
							<div class="control-group">
								<label id="list_type-lbl" for="words_count" class="control-label">
									<?php echo JText::_('DC_LISTTYPE'); ?>
								</label>

								<div class="controls">
									<select name="list_type" id="list_type">
										<option value="" <?php echo $this->params->list_type == 'random' ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('RL_RANDOM'); ?>
										</option>
										<option value="ol" <?php echo $this->params->list_type == 'ol' ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('DC_ORDERED'); ?>
										</option>
										<option value="ul" <?php echo $this->params->list_type == 'ul' ? 'selected="selected"' : ''; ?>>
											<?php echo JText::_('DC_UNORDERED'); ?>
										</option>
									</select>
								</div>
							</div>

							<hr>
						</div>

						<div rel="type_title" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="title_count-lbl" for="title_count" class="control-label">
									<?php echo JText::_('DC_TITLE_WORD_COUNT'); ?>
								</label>

								<div class="controls">
									<input type="text" name="title_count" id="title_count" class="input-mini" value="5">
								</div>
							</div>

							<hr>
						</div>

						<div rel="type_heading" class="toggle_div" style="display:none;">
							<div class="control-group">
								<label id="heading_count-lbl" for="heading_count" class="control-label">
									<?php echo JText::_('DC_HEADING_WORD_COUNT'); ?>
								</label>

								<div class="controls">
									<input type="text" name="heading_count" id="heading_count" class="input-mini" value="5">
								</div>
							</div>

							<hr>
						</div>

				</div>

				<div style="clear:both;"></div>

				<input type="hidden" name="name" value="<?php echo $editor; ?>">
			</form>
		</div>

		<script type="text/javascript">
			(function($) {
				RegularLabsDummyContent = {
					insertContent: function() {
						let params = [];

						const type = $('input[name="type"]:checked').val();

						if (type != 'default') {
							params.push('type="' + $('input[name="type"]:checked').val() + '"');
						}

						switch ($('input[name="type"]:checked').val()) {
							case 'paragraphs':
								params.push('count="' + $('[name="paragraphs_count"]').val() + '"');
								break;
							case 'sentences':
								params.push('count="' + $('[name="sentences_count"]').val() + '"');
								break;
							case 'words':
								params.push('count="' + $('[name="words_count"]').val() + '"');
								break;
							case 'list':
								let list_count = $('[name="list_count"]').val() || 'random';
								let list_type  = $('[name="list_type"]').val() || 'random';

								params.push('count="' + $('[name="list_count"]').val() + '"');
								params.push('listtype="' + list_type + '"');
								break;
							case 'title':
								params.push('count="' + $('[name="title_count"]').val() + '"');
								break;
							case 'heading':
								params.push('count="' + $('[name="heading_count"]').val() + '"');
								break;
						}


						var url = 'index.php?rl_qp=1&folder=plugins.editors-xtd.dummycontent&file=popup.php&generate_content=1&' + params.join('&');
						RegularLabsScripts.loadajax(url, 'window.parent.jInsertEditorText( data, \'<?php echo $editor; ?>\' );window.parent.SqueezeBox.close();');

					},

					insertTag: function() {
						const params = [];

						const type = $('input[name="type"]:checked').val();

						switch (type) {
							case 'paragraphs':
							case 'sentences':
							case 'words':
							case 'title':
							case 'heading':
								params.push(type + '="' + $('[name="' + type + '_count"]').val() + '"');
								break;
							case 'list':
								let list_count = $('[name="list_count"]').val() || 'random';
								let list_type  = $('[name="list_type"]').val() || 'random';

								if (list_count != 'random') {
									params.push('list="' + list_count + '"');
								}

								params.push('listtype="' + list_type + '"');
								break;
						}


						if (type != 'default') {
							if (!params.length || params[0].indexOf(type + '="') !== 0) {
								params.unshift('type="' + type + '"');
							}
						}

						str = '{' + ('<?php echo $this->params->tag; ?> ' + params.join(' ')).trim() + '}';

						window.parent.jInsertEditorText(str, '<?php echo $editor; ?>');
						window.parent.SqueezeBox.close();
					},

					initDivs: function() {
						$('.toggler').click(function() {
							RegularLabsDummyContent.toggleDivs();
						});
						RegularLabsDummyContent.toggleDivs();
					},

					toggleDivs: function() {
						$('div.toggle_div').each(function(i, el) {
							el = $(el);
							if (el.attr('rel').substr(0, 4) == 'not_') {
								if ($('#' + el.attr('rel').substr(4) + ':checked').val()) {
									el.slideUp();
									return true;
								}

								el.slideDown();
								return true;
							}

							if ($('#' + el.attr('rel') + ':checked').val()) {
								el.slideDown();
								return true;
							}

							el.slideUp();
						});
					}
				};

				$(document).ready(function() {
					RegularLabsDummyContent.initDivs();
				});
			})
			(jQuery);
		</script>
		<?php
	}
}
