/* Copyright (C) 42theme.com, http://themeforest.net/user/42theme/portfolio?ref=42theme */

jQuery(function($) {

    var config = $('html').data('config') || {};

    // Social buttons
    $('article[data-permalink]').socialButtons(config);
    
    // Hide preloader
    jQuery(window).on('load', function () {
        var preloader = jQuery(".t42-preloader");
        var spinner   = preloader.find('.t42-spinner');
        spinner.fadeOut(100);
        preloader.delay(350).fadeOut(200);
        jQuery("html, body").css("overflow", "visible");
        
        // Home Page Tabs ajustments
        setTimeout(function () {
            jQuery(window).trigger('resize');
        }, 1000);
    });
    
    // fadeOut for page out
    jQuery(window).on('beforeunload', function(){
        var preloader = jQuery(".t42-preloader");
        var spinner   = preloader.find('.t42-spinner');
        preloader.fadeIn(200);
        spinner.delay(350).fadeIn();
    });
    
    // Open external links in new window
    jQuery('a:not([data-uk-lightbox]), #adminForm a').each(function () {
        if (typeof this.href !== typeof undefined && this.href !== false && this.href.trim() !== "" && !(this.href.indexOf("javascript") !=-1) ) { // Element has this attribute
            // Element has this attribute
            var a = new RegExp('/' + window.location.host + '/');
            if (!a.test(this.href)) { // Ссылка другой хост или не васккрипт
                jQuery(this).click(function (event) {
                    event.preventDefault();
                    event.stopPropagation();
                    window.open(this.href, '_blank');
                });
            }
        }
    });
    
    // Trigger focus on search input
    var txt = jQuery('#t42-search-modal .uk-search-field');

    // Focus search input
    jQuery(".t42-search-button").on('click', function () {
        setTimeout(txt.val('').focus.bind(txt), 300);
    });
    
});
