<?php

/**
 * 
 * Bozz — Corporate and Business Responsive Joomla Template, exclusively on Envato Market: http://themeforest.net/user/42theme/portfolio?ref=42theme
 * @encoding     UTF-8
 * @version      1.0.0
 * @copyright    Copyright (C) 2017 42Theme (https://42theme.com). All rights reserved.
 * @license      http://themeforest.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy (hot@42theme.com)
 * @support      support@42theme.com
 * 
 */
 
?>

<article class="uk-article t42-article" <?php if ($permalink) { echo 'data-permalink="'.$permalink.'"'; } ?>>

    <?php if ($image && $image_alignment == 'none') : ?>
        <?php if ($url) : ?>
            <a class="t42-article-featured-image" href="<?php echo $url; ?>" title="<?php echo $image_caption; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>"></a>
        <?php else : ?>
            <div class="t42-article-featured-image">
                <img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <div class="t42-article-content uk-position-relative <?php echo $date ? ' t42-article-date-true' : ''; ?>">

        <?php if ($date) : ?>
        <div class="t42-article-date uk-text-center">
            <?php printf('<span class="t42-article-date-day">'.JHtml::_('date', $date, JText::_('d')).'</span>'.'<span class="t42-article-date-month">'.JHtml::_('date', $date, JText::_('M')).'</span>'); ?>
        </div>
        <?php endif; ?>

        <?php if ($image && $image_alignment != 'none') : ?>

	<div class="uk-grid uk-grid-width-medium-1-2">

		<div <?php echo ($image_alignment == 'right') ? 'class="uk-flex-order-last"' : ''; ?>>

		<?php if ($url) : ?>
			<a href="<?php echo $url; ?>" title="<?php echo $image_caption; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>"></a>
		<?php else : ?>
			<img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
		<?php endif; ?>

		</div>

		<div>

        <?php endif; ?>

                <?php if ($title) : ?>
                    <h1 class="uk-article-title">
                        <?php if ($url && $title_link) : ?>
                            <a href="<?php echo $url; ?>" title="<?php echo $title; ?>"><?php echo $title; ?></a>
                        <?php else : ?>
                            <?php echo $title; ?>
                        <?php endif; ?>
                    </h1>
                <?php endif; ?>

	<?php echo $hook_aftertitle; ?>

	<?php echo $hook_beforearticle; ?>

	<?php if ($article) : ?>
	<div>
		<?php echo $article; ?>
	</div>
	<?php endif; ?>

	<?php if ($tags) : ?>
	<p><?php echo JText::_('TPL_WARP_TAGS').': '.$tags; ?></p>
	<?php endif; ?>

	<?php if ($more) : ?>
	<p>
		<a href="<?php echo $url; ?>" title="<?php echo $title; ?>"><?php echo $more; ?></a>
	</p>
	<?php endif; ?>

	<?php if ($edit) : ?>
	<p><?php echo $edit; ?></p>
	<?php endif; ?>

<?php if ($image && $image_alignment != 'none') : ?>

	</div>
</div>

<?php endif; ?>



	</div>



<?php if ($previous || $next) : ?>
<ul class="uk-pagination">
	<?php if ($previous) : ?>
	<li class="uk-pagination-previous">
		<a href="<?php echo $previous; ?>"><i class="uk-icon-angle-double-left"></i> <?php echo JText::_('JPREV'); ?></a>
	</li>
	<?php endif; ?>

	<?php if ($next) : ?>
	<li class="uk-pagination-next">
		<a href="<?php echo $next; ?>"><?php echo JText::_('JNEXT'); ?> <i class="uk-icon-angle-double-right"></i></a>
	</li>
	<?php endif; ?>
</ul>
<?php endif; ?>

<?php echo $hook_afterarticle; ?>

</article>