<?php
/**
 * 
 * Bozz — Corporate and Business Responsive Joomla Template, exclusively on Envato Market: http://themeforest.net/user/42theme/portfolio?ref=42theme
 * @encoding     UTF-8
 * @version      1.0.0
 * @copyright    Copyright (C) 2017 42Theme (https://42theme.com). All rights reserved.
 * @license      http://themeforest.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy (hot@42theme.com)
 * @support      support@42theme.com
 * 
 */

/*
 * Generate 3-column layout
 */
$config          = $this['config'];
$sidebars        = $config->get('sidebars', array());
$columns         = array('main' => array('width' => 60, 'alignment' => 'right'));
$sidebar_classes = '';

$gcf = function($a, $b = 60) use(&$gcf) {
    return (int) ($b > 0 ? $gcf($b, $a % $b) : $a);
};

$fraction = function($nominator, $divider = 60) use(&$gcf) {
    return $nominator / ($factor = $gcf($nominator, $divider)) .'-'. $divider / $factor;
};

foreach ($sidebars as $name => $sidebar) {
	if (!$this['widgets']->count($name)) {
        unset($sidebars[$name]);
        continue;
    }

    $columns['main']['width'] -= @$sidebar['width'];
    $sidebar_classes .= " t42-{$name}-".@$sidebar['alignment'];
}

if ($count = count($sidebars)) {
	$sidebar_classes .= ' t42-sidebars-'.$count;
}

$columns += $sidebars;
foreach ($columns as $name => &$column) {

    $column['width']     = isset($column['width']) ? $column['width'] : 0;
    $column['alignment'] = isset($column['alignment']) ? $column['alignment'] : 'left';

    $shift = 0;
    foreach (($column['alignment'] == 'left' ? $columns : array_reverse($columns, true)) as $n => $col) {
        if ($name == $n) break;
        if (@$col['alignment'] != $column['alignment']) {
            $shift += @$col['width'];
        }
    }
    $column['class'] = sprintf('t42-%s uk-width-medium-%s%s', $name, $fraction($column['width']), $shift ? ' uk-'.($column['alignment'] == 'left' ? 'pull' : 'push').'-'.$fraction($shift) : '');
    
    if($config->get("sidebars.{$name}.remove_aside_top_margin", '')){
        $column['class'] .= " uk-margin-remove";
    }
}

/*
 * Add grid classes
 */
$positions = array_keys($config->get('grid', array()));
$displays  = array('small', 'medium', 'large');
$grid_classes = array();
$display_classes = array();
$section_classes = array();
foreach ($positions as $position) {

    $grid_classes[$position] = array();
    $grid_classes[$position][] = "t42-{$position} uk-grid";
    $display_classes[$position][] = '';

    if ($this['config']->get("grid.{$position}.divider", false)) {
        $grid_classes[$position][] = 'uk-grid-divider';
    }

    if ($gutter = $this['config']->get("grid.{$position}.gutter", '')) {
        $grid_classes[$position][] = 'uk-grid-' . $gutter;
    }

    $widgets = $this['widgets']->load($position);

    foreach($displays as $display) {
        if (!array_filter($widgets, function($widget) use ($config, $display) { return (bool) $config->get("widgets.{$widget->id}.display.{$display}", true); })) {
            $display_classes[$position][] = "uk-hidden-{$display}";
        }
    }

    $display_classes[$position] = implode(" ", $display_classes[$position]);
    $grid_classes[$position] = implode(" ", $grid_classes[$position]);
    
    //Combine all into one varible
    $section_classes[$position] = $grid_classes[$position] . " " . $display_classes[$position];
}


/*
 * Add block classes
 */
$blocks          = array_keys($config->get('block', array()));
$block_classes   = array();
$block_first     = '';
$nav_class       = '';

foreach ($blocks as $block) {

    $block_classes[$block]  = "t42-block";
    $block_classes[$block] .= $config->get("block.{$block}.block-bg");
    $block_classes[$block] .= $config->get("block.{$block}.block-padding");
    $block_classes[$block] .= $config->get("block.{$block}.content-width");
    $block_classes[$block] .= ($config->get("block.{$block}.block-fullheight")) ? ' uk-height-viewport uk-flex uk-flex-middle' : '';
    $block_classes[$block] .= ($config->get("block.{$block}.block-contrast")) ? ' uk-contrast' : '';

    if ($this['config']->get("block.{$block}.class", false)) {
        $block_classes[$block] .= ' ' . ($this['config']->get("block.{$block}.class"));
    }

    if (!$block_first && $this['widgets']->count($block)) {
        $block_first = $block;

        switch ($config->get("block.{$block}.block-bg")) {
            case ' t42-block-muted':
                $nav_class = 't42-navbar-muted';
                break;

            case ' t42-block-primary uk-contrast':
                $nav_class = 't42-navbar-primary';
                break;

            case ' t42-block-secondary':
                $nav_class = 't42-navbar-secondary';
                break;
        }
    }

}

/*
 * Add body classes
 */
$body_classes  = $sidebar_classes;
$body_classes .= $this['system']->isBlog() ? ' t42-isblog' : ' t42-noblog';
$body_classes .= ' ' . $config->get('page_class');

//Lower case everything
$currentStyle = $this['config']->get('style');
$currentStyle = strtolower($currentStyle);

//Make alphanumeric (removes all other characters)
$currentStyle = preg_replace("/[^a-z0-9_\s-]/", "", $currentStyle);

//Clean up multiple dashes or whitespaces
$currentStyle = preg_replace("/[\s-]+/", " ", $currentStyle);

//Convert whitespaces and underscore to dash
$currentStyle = preg_replace("/[\s_]/", "-", $currentStyle);

$body_classes .= ' style-' . $currentStyle;

// get application
$app = JFactory::getApplication();

// Class for shop
if($app->input->get('option') == 'com_jshopping') {
    $body_classes .= ' jshop';
}

if( ($app->input->get('option') == 'com_jshopping') && ($app->input->get('view') == 'category' ) ) {
    $body_classes .= ' jshop-category';
}

if( ($app->input->get('option') == 'com_jshopping') && ($app->input->get('controller') == 'category' ) ) {
    $body_classes .= ' jshop-product-list';
}

if( ($app->input->get('option') == 'com_jshopping') && ($app->input->get('controller') == 'product' ) ) {
    $body_classes .= ' jshop-product-full';
}

// Class for quix builder
if( ($app->input->get('option') == 'com_quix') && ($app->input->get('view') == 'page' ) ) {
    $body_classes .= ' t42-quix-page';
}

$config->set('body_classes', trim($body_classes));

/*
 * Toolbar classes
 */

$toolbar_classes = "";
if( $this['config']->get("toolbar_full", false) ){ $toolbar_classes .= "t42-toolbar-full"; }

/*
 * Footer classes
 */

$footer_classes = "";
if( $this['config']->get("footer_full", false) ){ $footer_classes .= "t42-footer-full"; }


/*
 * Add social buttons
 */

$body_config = array();
$body_config['twitter']  = (int) $config->get('twitter', 0);
$body_config['plusone']  = (int) $config->get('plusone', 0);
$body_config['facebook'] = (int) $config->get('facebook', 0);
$body_config['style']    = $config->get('style');

$config->set('body_config', json_encode($body_config));

/*
 * Add assets
 */
// add css
$this['asset']->addFile('css', 'css:theme.css');
$this['asset']->addFile('css', 'warp:vendor/highlight/highlight.css');
$this['asset']->addFile('css', 'css:custom.css');

// add scripts
$this['asset']->addFile('js', 'js:uikit.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/autocomplete.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/search.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/slideshow.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/slideshow-fx.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/lightbox.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/sticky.js');
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/grid.js');

//Additional components
if ($this['config']->get('uk_dynamic_grid')=="0"){
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/grid.js');
}

if ($this['config']->get('uk_parallax_grid')=="0"){
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/grid-parallax.js');
}

if ($this['config']->get('uk_slider')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/slider.js');
}

if ($this['config']->get('uk_slideset')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/slideset.js');
}

if ($this['config']->get('uk_parallax')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/parallax.js');
}

if ($this['config']->get('uk_accordion')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/accordion.js');
}

if ($this['config']->get('uk_tooltip')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/tooltip.js');
}

if ($this['config']->get('uk_datepicker')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/datepicker.js');
}

if ($this['config']->get('uk_timepicker')=="0"){ 
    $this['asset']->addFile('js', 'warp:vendor/uikit/js/components/timepicker.js');
}

if ($this['config']->get('smoothscroll')=="0"){ 
    $this['asset']->addFile('js', 'js:SmoothScroll.min.js');
}

$this['asset']->addFile('js', 'js:social.js');
$this['asset']->addFile('js', 'js:theme.js');


if (isset($head)) {
    $this['template']->set('head', implode("\n", $head));
}