<?php
/**
 * 
 * Bozz — Corporate and Business Responsive Joomla Template, exclusively on Envato Market: http://themeforest.net/user/42theme/portfolio?ref=42theme
 * @encoding     UTF-8
 * @version      1.0.0
 * @copyright    Copyright (C) 2017 42Theme (https://42theme.com). All rights reserved.
 * @license      http://themeforest.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy (hot@42theme.com)
 * @support      support@42theme.com
 * 
 */

// get theme configuration
include($this['path']->path('layouts:theme.config.php')); ?>

<!DOCTYPE HTML>
<html lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>"  data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>

<head>
    <?php echo $this['template']->render('head'); ?>
</head>

<body class="<?php echo $this['config']->get('body_classes'); ?>">
    
    <?php if ($this['config']->get('preloader', 'default') != '0') : ?>
        <?php echo $this['template']->render('preloader.'.$this['config']->get('preloader', 'default').''); ?>
    <?php endif; ?>

    <?php if ($this['widgets']->count('toolbar-l + toolbar-r')) : ?>
    <div class="t42-toolbar uk-clearfix uk-hidden-small <?php echo $toolbar_classes; ?>">
        <div class="uk-container uk-container-center">
            <div class="uk-panel">
                
                <?php if ($this['widgets']->count('toolbar-l')) : ?>
                <div class="uk-float-left"><?php echo $this['widgets']->render('toolbar-l'); ?></div>
                <?php endif; ?>

                <?php if ($this['widgets']->count('toolbar-r')) : ?>
                <div class="uk-float-right"><?php echo $this['widgets']->render('toolbar-r'); ?></div>
                <?php endif; ?>
                
            </div>
        </div>
    </div>
    <?php endif; ?>
            
    <?php echo $this['template']->render('header.'.$this['config']->get('navigation_style', 'default').''); ?>

    <?php foreach (array('top-a', 'top-b', 'top-c', 'top-d', 'top-e') as $pos) : ?>
        <?php if ($this['widgets']->count($pos)) : ?>
            <div class="<?php echo "t42-block-".$pos." ".$block_classes[$pos]; ?>">
                <div class="uk-container uk-container-center">
                    <section class="<?php echo $section_classes[$pos]; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin="">
                        <?php echo $this['widgets']->render($pos, array('layout'=>$this['config']->get('grid.'.$pos.'.layout'))); ?>
                    </section>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <?php if ($this['widgets']->count('main-top + main-bottom + sidebar-a + sidebar-b') || $this['config']->get('system_output', true)) : ?>
    <div class="uk-container uk-container-center">
        <div id="t42-middle" class="t42-middle uk-grid" data-uk-grid-match data-uk-grid-margin>

                <?php if ($this['widgets']->count('main-top + main-bottom') || $this['config']->get('system_output', true)) : ?>
                <div class="<?php echo $columns['main']['class'] ?>">

                        <?php if ($this['widgets']->count('main-top')) : ?>
                        <section id="t42-main-top" class="<?php echo $grid_classes['main-top']; echo $display_classes['main-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-top', array('layout'=>$this['config']->get('grid.main-top.layout'))); ?></section>
                        <?php endif; ?>

                        <?php if ($this['config']->get('system_output', true)) : ?>
                        <main id="t42-content" class="t42-content">

                                <?php if ($this['widgets']->count('breadcrumbs')) : ?>
                                <?php echo $this['widgets']->render('breadcrumbs'); ?>
                                <?php endif; ?>

                                <?php echo $this['template']->render('content'); ?>

                        </main>
                        <?php endif; ?>

                        <?php if ($this['widgets']->count('main-bottom')) : ?>
                        <section id="t42-main-bottom" class="<?php echo $grid_classes['main-bottom']; echo $display_classes['main-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-bottom', array('layout'=>$this['config']->get('grid.main-bottom.layout'))); ?></section>
                        <?php endif; ?>

                </div>
                <?php endif; ?>

                <?php foreach($columns as $name => &$column) : ?>
                <?php if ($name != 'main' && $this['widgets']->count($name)) : ?>
                <aside class="<?php echo $column['class'] ?>"><?php echo $this['widgets']->render($name) ?></aside>
                <?php endif ?>
                <?php endforeach ?>

        </div>
    </div>
    <?php endif; ?>

    <?php foreach (array('bottom-a', 'bottom-b', 'bottom-c', 'bottom-d', 'bottom-e') as $pos) : ?>
        <?php if ($this['widgets']->count($pos)) : ?>
            <div class="<?php echo "t42-block-".$pos." ".$block_classes[$pos]; ?>">
                <div class="uk-container uk-container-center">
                    <section class="<?php echo $section_classes[$pos]; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin="">
                        <?php echo $this['widgets']->render($pos, array('layout'=>$this['config']->get('grid.'.$pos.'.layout'))); ?>
                    </section>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <?php if ( $this['widgets']->count('footer') ) : ?>
    <footer id="t42-footer" class="t42-footer <?php echo $footer_classes; ?>">
        <div class="uk-container uk-container-center">
            <?php echo $this['widgets']->render('footer'); ?>
        </div>
    </footer>
    <?php endif; ?>
    
    <?php if ( $this['widgets']->count('debug') ) : ?>
        <?php echo $this['widgets']->render('debug'); ?>
    <?php endif; ?>
    
    <?php echo $this->render('footer'); ?>

    <?php if ($this['widgets']->count('search')) : ?>
        <div id="t42-search-modal" class="uk-modal">
            <div class="uk-modal-dialog uk-modal-dialog-blank uk-grid uk-flex-middle">
                <a href="#" class="uk-modal-close t42-modal-close uk-close"></a>
                <div class="uk-container uk-container-center">
                    <?php echo $this['widgets']->render('search'); ?>
                    <p>Start typing and press Enter to search</p>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this['widgets']->count('offcanvas')) : ?>
    <div id="offcanvas" class="uk-offcanvas">
        <div class="uk-offcanvas-bar"><?php echo $this['widgets']->render('offcanvas'); ?></div>
    </div>
    <?php endif; ?>

</body>
</html>