<?php
/**
 * 
 * Extensions for Quix - Joomla Page Builder, exclusively on Envato Market: http://themeforest.net/user/42theme/portfolio?ref=42theme
 * @encoding     UTF-8
 * @version      1.0.0
 * @copyright    Copyright (C) 2017 42Theme (https://42theme.com). All rights reserved.
 * @license      http://themeforest.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua)
 * @support      support@42theme.com
 * 
 */

    $classes = classNames( "qx-element qx-element-{$type} {$field['class']}", $visibilityClasses, [
      'qx-text-left' => $field['alignment'] === 'left',
      'qx-text-center' => $field['alignment'] === 'center',
      'qx-text-right' => $field['alignment'] === 'right',
      "wow {$field['animation']}" => $field['animation'],
      "qx-hvr-{$field['hover_animation']}" => ($field['animation_apply'] === 'body')
    ]);

    // Animation delay
    $animation_delay = '';
    if( $field['animation'] AND array_key_exists('animation_delay', $field) ){
      $animation_delay = 'data-wow-delay="'. $field['animation_delay'] .'s"';
    }
?>

<!-- t42-element-hoverbox start -->
<div id="<?php echo $id; ?>" class="<?php echo $classes; ?>" <?php echo $animation_delay; ?>>
    <div class="uk-panel mod-what-we-offer">
        <figure class="uk-overlay uk-overlay-hover">
            <img src="<?php echo $field['image']; ?>" alt="<?php echo $field['title']; ?>" width="800" height="750">
            <div class="uk-overlay-panel uk-animation-hover uk-ignore">
                <div>
                    <h3 class="uk-panel-title">
                        
                        <?php if($field['link']['url']): ?>
                        <a href="<?php echo $field['link']['url']; ?>" title="<?php echo $field['title']; ?>">
                        <?php endif; ?>
                            
                            <?php echo $field['title']; ?>
                            <i class="uk-icon-angle-right"></i>
                            
                        <?php if($field['link']['url']): ?>
                        </a>
                        <?php endif; ?>
                        
                    </h3>
                    <div class="uk-animation-slide-bottom">
                        <?php echo $field['content']; ?>
                    </div>
                </div>
            </div>
        </figure>
    </div>
</div>
<!-- t42-element-hoverbox end -->
