<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

class HelixUltimateFeatureContact
{
	private $params;

	public function __construct($params)
	{
		$this->params = $params;
		$this->position = $this->params->get('contact_position', 'top1');
	}

	public function renderFeature()
	{
		$conditions = $this->params->get('contactinfo') && ($this->params->get('contact_phone') || $this->params->get('contact_mobile') || $this->params->get('contact_email') || $this->params->get('contact_time'));

		if($conditions)
		{
			$output = '<ul class="header-info">';

            if($this->params->get('contact_time'))
            {
                $output .= '<li>';
                $output .= '<i class="fa fa-map-marker-alt"></i>';
                $output .= '<h6><span>' . JText::_('Address') . ':</span>
                                    ' . $this->params->get('contact_time') . '</h6>';
                $output .= '</li>';
            }

			if($this->params->get('contact_phone'))
			{
                $output .= '<li>';
                $output .= '<i class="fa fa-phone-alt"></i>';
                $output .= '<h6><span>' . JText::_('Phone') . ':</span>
                                    ' . $this->params->get('contact_phone') . '</h6>';
                $output .= '</li>';
			}

			if($this->params->get('contact_mobile'))
			{
                $output .= '<li>';
                $output .= '<i class="fa fa-phone-alt"></i>';
                $output .= '<h6><span>' . JText::_('Phone') . ':</span>
                                    ' . $this->params->get('contact_mobile') . '</h6>';
                $output .= '</li>';
			}

			if($this->params->get('contact_email'))
			{
                $output .= '<li>';
                $output .= '<i class="fa fa-envelope"></i>';
                $output .= '<h6><span>' . JText::_('Email') . ':</span>
                                    ' . $this->params->get('contact_email') . '</h6>';
                $output .= '</li>';
			}

			$output .= '</ul>';

			return $output;
		}

	}
}
