<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

$data = $displayData;
$offcanvs_position = $displayData->params->get('offcanvas_position', 'right');

$feature_folder_path     = JPATH_THEMES . '/' . $data->template->template . '/features/';

include_once $feature_folder_path.'logo.php';
include_once $feature_folder_path.'social.php';
include_once $feature_folder_path.'contact.php';
include_once $feature_folder_path.'menu.php';

$output  = '';


$output .= '<header id="sp-header">';
$output .= '<div class="container">';
$output .= '<div class="container-inner">';
$output .= '<div class="row">';

$class1 = 'col-8 col-sm-6 col-lg-3';
$class2 = 'col-4 col-sm-6 col-lg-9';

$output .= '<div id="sp-logo" class="col-12">';
$output .= '<div class="d-flex align-items-center justify-content-between">';
$logo    = new HelixUltimateFeatureLogo($data->params);
$output .= $logo->renderFeature();
$output .= '<div class="d-flex align-items-center">';
$contact = new HelixUltimateFeatureContact($data->params);
$output .= $contact->renderFeature();
$output .= '<jdoc:include type="modules" name="logo" style="sp_xhtml" />';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';

$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</header>';

$output .= '<div id="sp-menu">';
$output .= '<div class="container">';
$output .= '<div class="menu-inner">';
$output .= '<div class="sp-column d-flex w-100 align-items-center justify-content-end">';
$menu    = new HelixUltimateFeatureMenu($data->params);
$output .= $menu->renderFeature();
$output .= '<span class="d-md-block d-none"><jdoc:include type="modules" name="menu" style="sp_xhtml" /></span>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';

echo $output;