<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined('_JEXEC') or die;
?>
<div class="apartment-carousel <?php echo $moduleclass_sfx; ?>">
    <div class="slick_slider_normal" data-visible="3" data-itemtablet="2" data-itemmobile="1" data-centermod="1" shownav="1" data-showdot="0">
        <div class="slider slide-content">
            <div class="slide-slick">
                <?php
                $i=0;
                foreach ($list as $item) :
                    $i++;
                    $post_attribs = new JRegistry(json_decode( $item->attribs ));
                    $post_format = $item->params->get( 'post_format', '' );
                    $author = ( $item->created_by_alias ? $item->created_by_alias : $item->author );
                    $attribs1 		= json_decode($item->attribs);
                    $params  = $item->params;

                    $images 		= json_decode($item->images);
                    if(isset($attribs1->spfeatured_image) && $attribs1->spfeatured_image != '') {
                        $imgsize = 'thumbnail';
                        $intro_image = $attribs1->spfeatured_image;
                        $basename = basename($intro_image);
                        $list_image = JPATH_ROOT . '/' . dirname($intro_image) . '/' . JFile::stripExt($basename) . '_'. $imgsize .'.' . JFile::getExt($basename);
                        if(file_exists($list_image)) {
                            $intro_image = JURI::root(true) . '/' . dirname($intro_image) . '/' . JFile::stripExt($basename) . '_'. $imgsize .'.' . JFile::getExt($basename);
                        }
                    } elseif(isset($images->image_intro) && !empty($images->image_intro)) {
                        $intro_image = $images->image_intro;
                    }
                    $commentsAPI = JPATH_SITE . '/components/com_jcomments/jcomments.php';
                    if (file_exists($commentsAPI)) {
                        require_once($commentsAPI);
                        $count = JComments::getCommentsCount($item->id, 'com_content');
                        if ($count > 1) {
                            $text_comment = JText::sprintf('LINK_READ_COMMENTS_MORE', $count);
                        } else {
                            $text_comment = JText::sprintf('LINK_READ_COMMENTS_1', $count);
                        }
                    }
                    if ($params->get('access-view')) :
                        $link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language));
                    else :
                        $menu = JFactory::getApplication()->getMenu();
                        $active = $menu->getActive();
                        $itemId = $active->id;
                        $link = new JUri(JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
                        $link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)));
                    endif;
                    ?>
                    <div class="wrap-item">
                        <div class="item-slick apartment-item text-center">
                            <?php if($i%2!=0) {?>
                                <div class="apartment-img">
                                    <img src="<?php echo $intro_image;?>" alt="Apartment">
                                </div>
                            <?php }?>
                            <div class="apartment-content">
                                <img src="images/apartment/icon1.png" alt="Icon">
                                <h3><a href="<?php echo $link;?>"><?php echo $item->title;?></a></h3>
                                <span>from <?php echo JHtml::_('date', $item->created, 'j F, Y'); ?></span>
                                <p>Aenean vehicula non mauris maximus elementum. Nulla facilisi. </p>
                            </div>
                            <?php if($i%2==0) {?>
                                <div class="apartment-img">
                                    <img src="<?php echo $intro_image;?>" alt="Apartment">
                                </div>
                            <?php }?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="wrap-arrow-slick">
                <div class="arow-slick prev-slick">prev</div>
                <div class="arow-slick next-slick">next</div>
            </div>
        </div>
    </div>
</div>
