<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonArt_articles extends SppagebuilderAddons {

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
        $style = (isset($this->addon->settings->style) && $this->addon->settings->style) ? $this->addon->settings->style : '';

        $catid 			= (isset($this->addon->settings->catid) && $this->addon->settings->catid) ? $this->addon->settings->catid : 0;
        $ordering 		= (isset($this->addon->settings->ordering) && $this->addon->settings->ordering) ? $this->addon->settings->ordering : 'latest';
        $limit 			= (isset($this->addon->settings->limit) && $this->addon->settings->limit) ? $this->addon->settings->limit : 3;
        $columns 		= (isset($this->addon->settings->columns) && $this->addon->settings->columns) ? $this->addon->settings->columns : 3;
        $show_intro 	= (isset($this->addon->settings->show_intro)) ? $this->addon->settings->show_intro : 1;
        $intro_limit 	= (isset($this->addon->settings->intro_limit) && $this->addon->settings->intro_limit) ? $this->addon->settings->intro_limit : 200;
        $show_author 	= (isset($this->addon->settings->show_author)) ? $this->addon->settings->show_author : 1;
        $show_category 	= (isset($this->addon->settings->show_category)) ? $this->addon->settings->show_category : 1;
        $show_date 		= (isset($this->addon->settings->show_date)) ? $this->addon->settings->show_date : 1;
        $show_readmore 	= (isset($this->addon->settings->show_readmore)) ? $this->addon->settings->show_readmore : 1;
        $readmore_text 	= (isset($this->addon->settings->readmore_text) && $this->addon->settings->readmore_text) ? $this->addon->settings->readmore_text : 'Read More';

        $article_helper = JPATH_ROOT . '/components/com_sppagebuilder/helpers/articles.php';
        require_once $article_helper;
        $items = SppagebuilderHelperArticles::getArticles($limit, $ordering, $catid);

        ob_start();
        ?>
        <div class="art_addon_articles layout_<?php echo $style;?>">
        <?php if(count((array) $items)) { ?>
            <div class="sppb-row">
            <?php foreach ($items as $key => $item) {;?>
                <div class="sppb-col-sm-<?php echo round(12 / $columns);?>">
                    <div class="item-article">
                        <div class="post-thumbnail">
                            <?php
                            $image = $item->image_medium;
                            if (isset($image) && $image) {
                                echo '<a href="' . $item->link . '" itemprop="url"><img class="sppb-img-responsive" src="' . $image . '" alt="' . $item->title . '" itemprop="thumbnailUrl"></a>';
                            }
                            ?>
                        </div>
                        <?php if( $show_date ) :?>
                            <div class="entry-date-time">
                                <h4 class="day"><?php echo JHtml::_('date', $item->created, 'd'); ?></h4>
                                <span class="month"><?php echo JHtml::_('date', $item->created, 'M'); ?></span>
                            </div>
                        <?php endif;?>
                        <div class="content">
                            <?php if( $show_category ) :?>
                                <?php
                                $item->catUrl = JRoute::_(ContentHelperRoute::getCategoryRoute($item->catslug));
                                ?>
                                <div class="bottom-info">
                                    <div class="list-categories"><i class="fa fa-folder-open-o"></i> <a
                                                href="<?php echo $item->catUrl;?>" class="categories-name"
                                                tabindex="0"><?php echo $item->category;?></a></div>
                                </div>
                            <?php endif;?>
                            <h4 class="title">
                                <a href="<?php echo $item->link;?>" tabindex="0"><?php echo $item->title;?></a>
                            </h4>
                            <?php if($show_intro) { ?>
                                <div class="introtext">
                                    <?php echo Jhtml::_('string.truncate', ($item->introtext), $intro_limit);?>
                                </div>
                            <?php }?>
                        </div>
                    </div>
                </div>
                <?php
            } ?>
            </div>
        <?php }
        ?>
        </div>
        <?php
        $html = ob_get_clean();
        return $html;
	}
}