/*
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
define("ace/mode/coldfusion",["require","exports","module","ace/lib/oop","ace/mode/xml","ace/mode/javascript","ace/mode/css","ace/tokenizer","ace/mode/coldfusion_highlight_rules"],function(b,c,a){var f=b("../lib/oop");
var d=b("./xml").Mode;var j=b("./javascript").Mode;var e=b("./css").Mode;var h=b("../tokenizer").Tokenizer;var g=b("./coldfusion_highlight_rules").ColdfusionHighlightRules;
var i=function(){d.call(this);var k=new g();this.$tokenizer=new h(k.getRules());this.$embeds=k.getEmbeds();this.createModeDelegates({"js-":j,"css-":e});
};f.inherits(i,d);(function(){this.getNextLineIndent=function(m,k,l){return this.$getIndent(k);};}).call(i.prototype);c.Mode=i;});define("ace/mode/xml",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/xml_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/xml"],function(d,g,c){var h=d("../lib/oop");
var e=d("./text").Mode;var i=d("../tokenizer").Tokenizer;var b=d("./xml_highlight_rules").XmlHighlightRules;var a=d("./behaviour/xml").XmlBehaviour;var f=d("./folding/xml").FoldMode;
var j=function(){this.$tokenizer=new i(new b().getRules());this.$behaviour=new a();this.foldingRules=new f();};h.inherits(j,e);(function(){this.getNextLineIndent=function(m,k,l){return this.$getIndent(k);
};}).call(j.prototype);g.Mode=j;});define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/xml_util","ace/mode/text_highlight_rules"],function(d,c,e){var f=d("../lib/oop");
var g=d("./xml_util");var b=d("./text_highlight_rules").TextHighlightRules;var a=function(){this.$rules={start:[{token:"text",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:"xml_pe",regex:"<\\?.*?\\?>"},{token:"comment",merge:true,regex:"<\\!--",next:"comment"},{token:"xml_pe",regex:"<\\!.*?>"},{token:"meta.tag",regex:"<\\/?",next:"tag"},{token:"text",regex:"\\s+"},{token:"constant.character.entity",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"},{token:"text",regex:"[^<]+"}],cdata:[{token:"text",regex:"\\]\\]>",next:"start"},{token:"text",regex:"\\s+"},{token:"text",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment",regex:".*?-->",next:"start"},{token:"comment",merge:true,regex:".+"}]};
g.tag(this.$rules,"tag","start");};f.inherits(a,b);c.XmlHighlightRules=a;});define("ace/mode/xml_util",["require","exports","module"],function(d,b,e){function c(f){return[{token:"string",regex:'".*?"'},{token:"string",merge:true,regex:'["].*',next:f+"_qqstring"},{token:"string",regex:"'.*?'"},{token:"string",merge:true,regex:"['].*",next:f+"_qstring"}];
}function a(f,g){return[{token:"string",merge:true,regex:".*?"+f,next:g},{token:"string",merge:true,regex:".+"}];}b.tag=function(f,g,h,i){f[g]=[{token:"text",regex:"\\s+"},{token:!i?"meta.tag.tag-name":function(j){if(i[j]){return"meta.tag.tag-name."+i[j];
}else{return"meta.tag.tag-name";}},merge:true,regex:"[-_a-zA-Z0-9:]+",next:g+"_embed_attribute_list"},{token:"empty",regex:"",next:g+"_embed_attribute_list"}];
f[g+"_qstring"]=a("'",g+"_embed_attribute_list");f[g+"_qqstring"]=a('"',g+"_embed_attribute_list");f[g+"_embed_attribute_list"]=[{token:"meta.tag",merge:true,regex:"/?>",next:h},{token:"keyword.operator",regex:"="},{token:"entity.other.attribute-name",regex:"[-_a-zA-Z0-9:]+"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"text",regex:"\\s+"}].concat(c(g));
};});define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(c,f,b){var g=c("../../lib/oop");
var e=c("../behaviour").Behaviour;var i=c("./cstyle").CstyleBehaviour;var h=c("../../token_iterator").TokenIterator;function d(k,l){var j=true;var m=k.type.split(".");
var n=l.split(".");n.forEach(function(o){if(m.indexOf(o)==-1){j=false;return false;}});return j;}var a=function(){this.inherit(i,["string_dquotes"]);this.add("autoclosing","insertion",function(j,l,p,q,r){if(r==">"){var n=p.getCursorPosition();
var m=new h(q,n.row,n.column);var k=m.getCurrentToken();var o=false;if(!k||!d(k,"meta.tag")&&!(d(k,"text")&&k.value.match("/"))){do{k=m.stepBackward();
}while(k&&(d(k,"string")||d(k,"keyword.operator")||d(k,"entity.attribute-name")||d(k,"text")));}else{o=true;}if(!k||!d(k,"meta.tag-name")||m.stepBackward().value.match("/")){return;
}var s=k.value;if(o){var s=s.substring(0,n.column-k.start);}return{text:"></"+s+">",selection:[1,1]};}});this.add("autoindent","insertion",function(j,m,o,p,q){if(q=="\n"){var r=o.getCursorPosition();
var s=p.doc.getLine(r.row);var l=s.substring(r.column,r.column+2);if(l=="</"){var k=this.$getIndent(p.doc.getLine(r.row))+p.getTabString();var n=this.$getIndent(p.doc.getLine(r.row));
return{text:"\n"+k+"\n"+n,selection:[1,k.length,1,k.length]};}}});};g.inherits(a,e);f.XmlBehaviour=a;});define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour"],function(c,a,d){var e=c("../../lib/oop");
var f=c("../behaviour").Behaviour;var b=function(){this.add("braces","insertion",function(h,j,m,p,r){if(r=="{"){var q=m.getSelectionRange();var k=p.doc.getTextRange(q);
if(k!==""){return{text:"{"+k+"}",selection:false};}else{return{text:"{}",selection:[1,1]};}}else{if(r=="}"){var s=m.getCursorPosition();var t=p.doc.getLine(s.row);
var n=t.substring(s.column,s.column+1);if(n=="}"){var g=p.$findOpeningBracket("}",{column:s.column+1,row:s.row});if(g!==null){return{text:"",selection:[1,1]};
}}}else{if(r=="\n"){var s=m.getCursorPosition();var t=p.doc.getLine(s.row);var n=t.substring(s.column,s.column+1);if(n=="}"){var o=p.findMatchingBracket({row:s.row,column:s.column+1});
if(!o){return null;}var i=this.getNextLineIndent(h,t.substring(0,t.length-1),p.getTabString());var l=this.$getIndent(p.doc.getLine(o.row));return{text:"\n"+i+"\n"+l,selection:[1,i.length,1,i.length]};
}}}}});this.add("braces","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);if(!h.isMultiLine()&&i=="{"){var g=m.doc.getLine(h.start.row);var n=g.substring(h.end.column,h.end.column+1);
if(n=="}"){h.end.column++;return h;}}});this.add("parens","insertion",function(h,i,k,m,o){if(o=="("){var n=k.getSelectionRange();var j=m.doc.getTextRange(n);
if(j!==""){return{text:"("+j+")",selection:false};}else{return{text:"()",selection:[1,1]};}}else{if(o==")"){var p=k.getCursorPosition();var q=m.doc.getLine(p.row);
var l=q.substring(p.column,p.column+1);if(l==")"){var g=m.$findOpeningBracket(")",{column:p.column+1,row:p.row});if(g!==null){return{text:"",selection:[1,1]};
}}}}});this.add("parens","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);if(!h.isMultiLine()&&i=="("){var g=m.doc.getLine(h.start.row);var n=g.substring(h.start.column+1,h.start.column+2);
if(n==")"){h.end.column++;return h;}}});this.add("brackets","insertion",function(h,i,k,m,o){if(o=="["){var n=k.getSelectionRange();var j=m.doc.getTextRange(n);
if(j!==""){return{text:"["+j+"]",selection:false};}else{return{text:"[]",selection:[1,1]};}}else{if(o=="]"){var p=k.getCursorPosition();var q=m.doc.getLine(p.row);
var l=q.substring(p.column,p.column+1);if(l=="]"){var g=m.$findOpeningBracket("]",{column:p.column+1,row:p.row});if(g!==null){return{text:"",selection:[1,1]};
}}}}});this.add("brackets","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);if(!h.isMultiLine()&&i=="["){var g=m.doc.getLine(h.start.row);var n=g.substring(h.start.column+1,h.start.column+2);
if(n=="]"){h.end.column++;return h;}}});this.add("string_dquotes","insertion",function(h,k,n,q,u){if(u=='"'||u=="'"){var g=u;var s=n.getSelectionRange();
var l=q.doc.getTextRange(s);if(l!==""){return{text:g+l+g,selection:false};}else{var t=n.getCursorPosition();var w=q.doc.getLine(t.row);var v=w.substring(t.column-1,t.column);
if(v=="\\"){return null;}var p=q.getTokens(s.start.row);var i=0,j;var m=-1;for(var r=0;r<p.length;r++){j=p[r];if(j.type=="string"){m=-1;}else{if(m<0){m=j.value.indexOf(g);
}}if((j.value.length+i)>s.start.column){break;}i+=p[r].value.length;}if(!j||(m<0&&j.type!=="comment"&&(j.type!=="string"||((s.start.column!==j.value.length+i-1)&&j.value.lastIndexOf(g)===j.value.length-1)))){return{text:g+g,selection:[1,1]};
}else{if(j&&j.type==="string"){var o=w.substring(t.column,t.column+1);if(o==g){return{text:"",selection:[1,1]};}}}}}});this.add("string_dquotes","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);
if(!h.isMultiLine()&&(i=='"'||i=="'")){var g=m.doc.getLine(h.start.row);var n=g.substring(h.start.column+1,h.start.column+2);if(n=='"'){h.end.column++;
return h;}}});};e.inherits(b,f);a.CstyleBehaviour=b;});define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(e,f,c){var g=e("../../lib/oop");
var b=e("../../lib/lang");var d=e("../../range").Range;var i=e("./fold_mode").FoldMode;var h=e("../../token_iterator").TokenIterator;var a=f.FoldMode=function(j){i.call(this);
this.voidElements=j||{};};g.inherits(a,i);(function(){this.getFoldWidget=function(l,k,m){var j=this._getFirstTagInLine(l,m);if(j.closing){return k=="markbeginend"?"end":"";
}if(!j.tagName||this.voidElements[j.tagName.toLowerCase()]){return"";}if(j.selfClosing){return"";}if(j.value.indexOf("/"+j.tagName)!==-1){return"";}return"start";
};this._getFirstTagInLine=function(n,o){var m=n.getTokens(o);var l="";for(var k=0;k<m.length;k++){var j=m[k];if(j.type.indexOf("meta.tag")===0){l+=j.value;
}else{l+=b.stringRepeat(" ",j.value.length);}}return this._parseTag(l);};this.tagRe=/^(\s*)(<?(\/?)([-_a-zA-Z0-9:!]*)\s*(\/?)>?)/;this._parseTag=function(j){var k=this.tagRe.exec(j);
var l=this.tagRe.lastIndex||0;this.tagRe.lastIndex=0;return{value:j,match:k?k[2]:"",closing:k?!!k[3]:false,selfClosing:k?!!k[5]||k[2]=="/>":false,tagName:k?k[4]:"",column:k[1]?l+k[1].length:l};
};this._readTagForward=function(l){var k=l.getCurrentToken();if(!k){return null;}var m="";var n;do{if(k.type.indexOf("meta.tag")===0){if(!n){var n={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()};
}m+=k.value;if(m.indexOf(">")!==-1){var j=this._parseTag(m);j.start=n;j.end={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()+k.value.length};
l.stepForward();return j;}}}while(k=l.stepForward());return null;};this._readTagBackward=function(m){var l=m.getCurrentToken();if(!l){return null;}var n="";
var k;do{if(l.type.indexOf("meta.tag")===0){if(!k){k={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()+l.value.length};}n=l.value+n;if(n.indexOf("<")!==-1){var j=this._parseTag(n);
j.end=k;j.start={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()};m.stepBackward();return j;}}}while(l=m.stepBackward());return null;};this._pop=function(k,j){while(k.length){var l=k[k.length-1];
if(!j||l.tagName==j.tagName){return k.pop();}else{if(this.voidElements[j.tagName]){return;}else{if(this.voidElements[l.tagName]){k.pop();continue;}else{return null;
}}}}};this.getFoldWidgetRange=function(o,m,r){var l=this._getFirstTagInLine(o,r);if(!l.match){return null;}var p=l.closing||l.selfClosing;var q=[];var s;
if(!p){var n=new h(o,r,l.column);var j={row:r,column:l.column+l.tagName.length+2};while(s=this._readTagForward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;
s.end.column-=2;return d.fromPoints(s.start,s.end);}else{continue;}}if(s.closing){this._pop(q,s);if(q.length==0){return d.fromPoints(j,s.start);}}else{q.push(s);
}}}else{var n=new h(o,r,l.column+l.match.length);var k={row:r,column:l.column};while(s=this._readTagBackward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;
s.end.column-=2;return d.fromPoints(s.start,s.end);}else{continue;}}if(!s.closing){this._pop(q,s);if(q.length==0){s.start.column+=s.tagName.length+2;return d.fromPoints(s.start,k);
}}else{q.push(s);}}}};}).call(a.prototype);});define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(b,a,c){var e=b("../../range").Range;
var d=a.FoldMode=function(){};(function(){this.foldingStartMarker=null;this.foldingStopMarker=null;this.getFoldWidget=function(h,g,i){var f=h.getLine(i);
if(this.foldingStartMarker.test(f)){return"start";}if(g=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(f)){return"end";}return"";
};this.getFoldWidgetRange=function(g,f,h){return null;};this.indentationBlock=function(l,p,g){var o=/\S/;var q=l.getLine(p);var j=q.search(o);if(j==-1){return;
}var h=g||q.length;var m=l.getLength();var n=p;var i=p;while(++p<m){var f=l.getLine(p).search(o);if(f==-1){continue;}if(f<=j){break;}i=p;}if(i>n){var k=l.getLine(i).length;
return new e(n,h,i,k);}};this.openingBracketBlock=function(j,l,k,h,f){var m={row:k,column:h+1};var g=j.$findClosingBracket(l,m,f);if(!g){return;}var i=j.foldWidgets[g.row];
if(i==null){i=this.getFoldWidget(j,g.row);}if(i=="start"&&g.row>m.row){g.row--;g.column=j.getLine(g.row).length;}return e.fromPoints(m,g);};}).call(d.prototype);
});define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(d,f,b){var h=d("../lib/oop");
var e=d("./text").Mode;var i=d("../tokenizer").Tokenizer;var g=d("./javascript_highlight_rules").JavaScriptHighlightRules;var k=d("./matching_brace_outdent").MatchingBraceOutdent;
var c=d("../range").Range;var a=d("../worker/worker_client").WorkerClient;var l=d("./behaviour/cstyle").CstyleBehaviour;var m=d("./folding/cstyle").FoldMode;
var j=function(){this.$tokenizer=new i(new g().getRules());this.$outdent=new k();this.$behaviour=new l();this.foldingRules=new m();};h.inherits(j,e);(function(){this.toggleCommentLines=function(n,t,u,q){var s=true;
var v=/^(\s*)\/\//;for(var r=u;r<=q;r++){if(!v.test(t.getLine(r))){s=false;break;}}if(s){var o=new c(0,0,0,0);for(var r=u;r<=q;r++){var w=t.getLine(r);
var p=w.match(v);o.start.row=r;o.end.row=r;o.end.column=p[0].length;t.replace(o,p[1]);}}else{t.indentRows(u,q,"//");}};this.getNextLineIndent=function(t,p,r){var o=this.$getIndent(p);
var s=this.$tokenizer.getLineTokens(p,t);var u=s.tokens;var n=s.state;if(u.length&&u[u.length-1].type=="comment"){return o;}if(t=="start"||t=="regex_allowed"){var q=p.match(/^.*(?:\bcase\b.*\:|[\{\(\[])\s*$/);
if(q){o+=r;}}else{if(t=="doc-start"){if(n=="start"||t=="regex_allowed"){return"";}var q=p.match(/^\s*(\/?)\*/);if(q){if(q[1]){o+=" ";}o+="* ";}}}return o;
};this.checkOutdent=function(p,n,o){return this.$outdent.checkOutdent(n,o);};this.autoOutdent=function(n,o,p){this.$outdent.autoOutdent(o,p);};this.createWorker=function(n){var o=new a(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");
o.attachToDocument(n.getDocument());o.on("jslint",function(r){var s=[];for(var q=0;q<r.data.length;q++){var p=r.data[q];if(p){s.push({row:p.line-1,column:p.character-1,text:p.reason,type:"warning",lint:p});
}}n.setAnnotations(s);});o.on("narcissus",function(p){n.setAnnotations([p.data]);});o.on("terminate",function(){n.clearAnnotations();});return o;};}).call(j.prototype);
f.Mode=j;});define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/unicode","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(d,c,f){var h=d("../lib/oop");
var a=d("../unicode");var e=d("./doc_comment_highlight_rules").DocCommentHighlightRules;var b=d("./text_highlight_rules").TextHighlightRules;var g=function(){var j=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document","invalid.deprecated":"__parent__|__count__|escape|unescape|with|__proto__|debugger",keyword:"const|yield|import|get|setbreak|case|catch|continue|default|delete|do|else|finally|for|function|if|in|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|","storage.type":"const|let|var|function","invalid.illegal":"class|enum|extends|super|export|implements|private|public|interface|package|protected|static","constant.language":"null|Infinity|NaN|undefined",},"identifier");
var l="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield";var i="[a-zA-Z\\$_\u00a1-\uffff][a-zA-Z\d\\$_\u00a1-\uffff]*\\b";var k="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)";
this.$rules={start:[{token:"comment",regex:/\/\/.*$/},e.getStartRule("doc-start"),{token:"comment",merge:true,regex:/\/\*/,next:"comment"},{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0[xX][0-9a-fA-F]+\b/},{token:"constant.numeric",regex:/[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+i+")(\\.)(prototype)(\\.)("+i+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"constant.language.boolean",regex:/(?:true|false)\b/},{token:"keyword",regex:"(?:"+l+")\\b",next:"regex_allowed"},{token:["punctuation.operator","support.function"],regex:/(\.)(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:opzzzz|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:["punctuation.operator","support.function.dom"],regex:/(\.)(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:["punctuation.operator","support.constant"],regex:/(\.)(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|timeEnd|assert)\b/},{token:j,regex:i},{token:"keyword.operator",regex:/!|\$|%|&|\*|\-\-|\-|\+\+|\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\|\||\?\:|\*=|%=|\+=|\-=|&=|\^=|\b(?:in|instanceof|new|delete|typeof|void)/,next:"regex_allowed"},{token:"punctuation.operator",regex:/\?|\:|\,|\;|\./,next:"regex_allowed"},{token:"paren.lparen",regex:/[\[({]/,next:"regex_allowed"},{token:"paren.rparen",regex:/[\])}]/},{token:"keyword.operator",regex:/\/=?/,next:"regex_allowed"},{token:"comment",regex:/^#!.*$/},{token:"text",regex:/\s+/}],regex_allowed:[e.getStartRule("doc-start"),{token:"comment",merge:true,regex:"\\/\\*",next:"comment_regex_allowed"},{token:"comment",regex:"\\/\\/.*$"},{token:"string.regexp",regex:"\\/",next:"regex",merge:true},{token:"text",regex:"\\s+"},{token:"empty",regex:"",next:"start"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/\\w*",next:"start",merge:true},{token:"invalid",regex:/\{\d+,?(?:\d+)?}[+*]|[+*^$?][+*]|\?\?/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+,?(?:\d+)?}|[+*]\?|[(|)$^+*?]/},{token:"string.regexp",regex:/{|[^\[\\{()$^+*?\/]+/,merge:true},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class",merge:true},{token:"empty",regex:"",next:"start"}],regex_character_class:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex",merge:true},{token:"constant.language.escape",regex:"-",},{token:"string.regexp.charachterclass",regex:/[^\]\-\\]+/,merge:true},{token:"empty",regex:"",next:"start"}],function_arguments:[{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:"[, ]+",merge:true},{token:"punctuation.operator",regex:"$",merge:true},{token:"empty",regex:"",next:"start"}],comment_regex_allowed:[{token:"comment",regex:".*?\\*\\/",merge:true,next:"regex_allowed"},{token:"comment",merge:true,regex:".+"}],comment:[{token:"comment",regex:".*?\\*\\/",merge:true,next:"start"},{token:"comment",merge:true,regex:".+"}],qqstring:[{token:"constant.language.escape",regex:k},{token:"string",regex:'[^"\\\\]+',merge:true},{token:"string",regex:"\\\\$",next:"qqstring",merge:true},{token:"string",regex:'"|$',next:"start",merge:true}],qstring:[{token:"constant.language.escape",regex:k},{token:"string",regex:"[^'\\\\]+",merge:true},{token:"string",regex:"\\\\$",next:"qstring",merge:true},{token:"string",regex:"'|$",next:"start",merge:true}]};
this.embedRules(e,"doc-",[e.getEndRule("start")]);};h.inherits(g,b);c.JavaScriptHighlightRules=g;});define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,b,e){var f=c("../lib/oop");
var a=c("./text_highlight_rules").TextHighlightRules;var d=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},{token:"comment.doc",merge:true,regex:"\\s+"},{token:"comment.doc",merge:true,regex:"TODO"},{token:"comment.doc",merge:true,regex:"[^@\\*]+"},{token:"comment.doc",merge:true,regex:"."}]};
};f.inherits(d,a);d.getStartRule=function(g){return{token:"comment.doc",merge:true,regex:"\\/\\*(?=\\*)",next:g};};d.getEndRule=function(g){return{token:"comment.doc",merge:true,regex:"\\*\\/",next:g};
};b.DocCommentHighlightRules=d;});define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,b,d){var e=c("../range").Range;
var a=function(){};(function(){this.checkOutdent=function(f,g){if(!/^\s+$/.test(f)){return false;}return/^\s*\}/.test(g);};this.autoOutdent=function(k,l){var g=k.getLine(l);
var h=g.match(/^(\s*\})/);if(!h){return 0;}var i=h[1].length;var j=k.findMatchingBracket({row:l,column:i});if(!j||j.row==l){return 0;}var f=this.$getIndent(k.getLine(j.row));
k.replace(new e(l,0,l,i-1),f);};this.$getIndent=function(f){var g=f.match(/^(\s+)/);if(g){return g[1];}return"";};}).call(a.prototype);b.MatchingBraceOutdent=a;
});define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");
var f=b("../../range").Range;var g=b("./fold_mode").FoldMode;var e=a.FoldMode=function(){};d.inherits(e,g);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;
this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.getFoldWidgetRange=function(o,k,p){var q=o.getLine(p);var m=q.match(this.foldingStartMarker);
if(m){var l=m.index;if(m[1]){return this.openingBracketBlock(o,m[1],p,l);}var n=o.getCommentFoldRange(p,l+m[0].length);n.end.column-=2;return n;}if(k!=="markbeginend"){return;
}var m=q.match(this.foldingStopMarker);if(m){var l=m.index+m[0].length;if(m[2]){var n=o.getCommentFoldRange(p,l);n.end.column-=2;return n;}var j={row:p,column:l};
var h=o.$findOpeningBracket(m[1],j);if(!h){return;}h.column++;j.column--;return f.fromPoints(h,j);}};}).call(e.prototype);});define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/folding/cstyle"],function(c,e,b){var g=c("../lib/oop");
var d=c("./text").Mode;var h=c("../tokenizer").Tokenizer;var f=c("./css_highlight_rules").CssHighlightRules;var j=c("./matching_brace_outdent").MatchingBraceOutdent;
var a=c("../worker/worker_client").WorkerClient;var k=c("./folding/cstyle").FoldMode;var i=function(){this.$tokenizer=new h(new f().getRules(),"i");this.$outdent=new j();
this.foldingRules=new k();};g.inherits(i,d);(function(){this.foldingRules="cStyle";this.getNextLineIndent=function(p,m,o){var l=this.$getIndent(m);var q=this.$tokenizer.getLineTokens(m,p).tokens;
if(q.length&&q[q.length-1].type=="comment"){return l;}var n=m.match(/^.*\{\s*$/);if(n){l+=o;}return l;};this.checkOutdent=function(n,l,m){return this.$outdent.checkOutdent(l,m);
};this.autoOutdent=function(l,m,n){this.$outdent.autoOutdent(m,n);};this.createWorker=function(l){var m=new a(["ace"],"ace/mode/css_worker","Worker");m.attachToDocument(l.getDocument());
m.on("csslint",function(n){var o=[];n.data.forEach(function(p){o.push({row:p.line-1,column:p.col-1,text:p.message,type:p.type,lint:p});});l.setAnnotations(o);
});return m;};}).call(i.prototype);e.Mode=i;});define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(d,b,e){var f=d("../lib/oop");
var g=d("../lib/lang");var a=d("./text_highlight_rules").TextHighlightRules;var c=function(){var q=this.createKeywordMapper({"support.type":"animation-fill-mode|alignment-adjust|alignment-baseline|animation-delay|animation-direction|animation-duration|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|animation|appearance|azimuth|backface-visibility|background-attachment|background-break|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|background|baseline-shift|binding|bleed|bookmark-label|bookmark-level|bookmark-state|bookmark-target|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|border|bottom|box-align|box-decoration-break|box-direction|box-flex-group|box-flex|box-lines|box-ordinal-group|box-orient|box-pack|box-shadow|box-sizing|break-after|break-before|break-inside|caption-side|clear|clip|color-profile|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|crop|cue-after|cue-before|cue|cursor|direction|display|dominant-baseline|drop-initial-after-adjust|drop-initial-after-align|drop-initial-before-adjust|drop-initial-before-align|drop-initial-size|drop-initial-value|elevation|empty-cells|fit|fit-position|float-offset|float|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|font|grid-columns|grid-rows|hanging-punctuation|height|hyphenate-after|hyphenate-before|hyphenate-character|hyphenate-lines|hyphenate-resource|hyphens|icon|image-orientation|image-rendering|image-resolution|inline-box-align|left|letter-spacing|line-height|line-stacking-ruby|line-stacking-shift|line-stacking-strategy|line-stacking|list-style-image|list-style-position|list-style-type|list-style|margin-bottom|margin-left|margin-right|margin-top|margin|mark-after|mark-before|mark|marks|marquee-direction|marquee-play-count|marquee-speed|marquee-style|max-height|max-width|min-height|min-width|move-to|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|orphans|outline-color|outline-offset|outline-style|outline-width|outline|overflow-style|overflow-x|overflow-y|overflow|padding-bottom|padding-left|padding-right|padding-top|padding|page-break-after|page-break-before|page-break-inside|page-policy|page|pause-after|pause-before|pause|perspective-origin|perspective|phonemes|pitch-range|pitch|play-during|position|presentation-level|punctuation-trim|quotes|rendering-intent|resize|rest-after|rest-before|rest|richness|right|rotation-point|rotation|ruby-align|ruby-overhang|ruby-position|ruby-span|size|speak-header|speak-numeral|speak-punctuation|speak|speech-rate|stress|string-set|table-layout|target-name|target-new|target-position|target|text-align-last|text-align|text-decoration|text-emphasis|text-height|text-indent|text-justify|text-outline|text-shadow|text-transform|text-wrap|top|transform-origin|transform-style|transform|transition-delay|transition-duration|transition-property|transition-timing-function|transition|unicode-bidi|vertical-align|visibility|voice-balance|voice-duration|voice-family|voice-pitch-range|voice-pitch|voice-rate|voice-stress|voice-volume|volume|white-space-collapse|white-space|widows|width|word-break|word-spacing|word-wrap|z-index","support.function":"rgb|rgba|url|attr|counter|counters","support.constant":"absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero","support.constant.color":"aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow","support.constant.fonts":"arial|century|comic|courier|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace"},"text",true);
var o="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";var l="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var i="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";
var h=[{token:"comment",merge:true,regex:"\\/\\*",next:"ruleset_comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+o+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:["constant.numeric"],regex:"([0-9]+)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:l},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:i},{token:q,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"}];
var p=g.copyArray(h);p.unshift({token:"paren.rparen",regex:"\\}",next:"start"});var k=g.copyArray(h);k.unshift({token:"paren.rparen",regex:"\\}",next:"media"});
var n=[{token:"comment",merge:true,regex:".+"}];var m=g.copyArray(n);m.unshift({token:"comment",regex:".*?\\*\\/",next:"start"});var r=g.copyArray(n);r.unshift({token:"comment",regex:".*?\\*\\/",next:"media"});
var j=g.copyArray(n);j.unshift({token:"comment",regex:".*?\\*\\/",next:"ruleset"});this.$rules={start:[{token:"comment",merge:true,regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"string",regex:"@.*?{",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"}],media:[{token:"comment",merge:true,regex:"\\/\\*",next:"media_comment"},{token:"paren.lparen",regex:"\\{",next:"media_ruleset"},{token:"string",regex:"\\}",next:"start"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"}],comment:m,ruleset:p,ruleset_comment:j,media_ruleset:k,media_comment:r};
};f.inherits(c,a);b.CssHighlightRules=c;});define("ace/mode/coldfusion_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/text_highlight_rules","ace/mode/xml_util"],function(c,d,b){var g=c("../lib/oop");
var e=c("./css_highlight_rules").CssHighlightRules;var f=c("./javascript_highlight_rules").JavaScriptHighlightRules;var a=c("./text_highlight_rules").TextHighlightRules;
var i=c("./xml_util");var h=function(){this.$rules={start:[{token:"text",merge:true,regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:"xml_pe",regex:"<\\?.*?\\?>"},{token:"comment",merge:true,regex:"<\\!--",next:"comment"},{token:"meta.tag",regex:"<(?=s*script)",next:"script"},{token:"meta.tag",regex:"<(?=s*style)",next:"style"},{token:"meta.tag",regex:"<\\/?",next:"tag"},{token:"text",regex:"\\s+"},{token:"text",regex:"[^<]+"}],cdata:[{token:"text",regex:"\\]\\]>",next:"start"},{token:"text",merge:true,regex:"\\s+"},{token:"text",merge:true,regex:".+"}],comment:[{token:"comment",regex:".*?-->",next:"start"},{token:"comment",merge:true,regex:".+"}]};
i.tag(this.$rules,"tag","start");i.tag(this.$rules,"style","css-start");i.tag(this.$rules,"script","js-start");this.embedRules(f,"js-",[{token:"comment",regex:"\\/\\/.*(?=<\\/script>)",next:"tag"},{token:"meta.tag",regex:"<\\/(?=script)",next:"tag"}]);
this.embedRules(e,"css-",[{token:"meta.tag",regex:"<\\/(?=style)",next:"tag"}]);};g.inherits(h,a);d.ColdfusionHighlightRules=h;});