/*
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
define("ace/mode/lua",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/lua_highlight_rules","ace/range"],function(d,f,b){var g=d("../lib/oop");
var e=d("./text").Mode;var h=d("../tokenizer").Tokenizer;var a=d("./lua_highlight_rules").LuaHighlightRules;var c=d("../range").Range;var i=function(){this.$tokenizer=new h(new a().getRules());
};g.inherits(i,e);(function(){var l={"function":1,then:1,"do":1,"else":1,elseif:1,repeat:1,end:-1,until:-1,};var k=["else","elseif","end","until"];function j(o){var p=0;
for(var n in o){var m=o[n];if(m.type=="keyword"){if(m.value in l){p+=l[m.value];}}else{if(m.type=="paren.lparen"){p++;}else{if(m.type=="paren.rparen"){p--;
}}}}if(p<0){return -1;}else{if(p>0){return 1;}else{return 0;}}}this.getNextLineIndent=function(q,n,o){var m=this.$getIndent(n);var s=0;var p=this.$tokenizer.getLineTokens(n,q);
var r=p.tokens;if(q=="start"){s=j(r);}if(s>0){return m+o;}else{if(s<0&&m.substr(m.length-o.length)==o){if(!this.checkOutdent(q,n,"\n")){return m.substr(0,m.length-o.length);
}}}return m;};this.checkOutdent=function(o,m,n){if(n!="\n"&&n!="\r"&&n!="\r\n"){return false;}if(m.match(/^\s*[\)\}\]]$/)){return true;}var p=this.$tokenizer.getLineTokens(m.trim(),o).tokens;
if(!p||!p.length){return false;}return(p[0].type=="keyword"&&k.indexOf(p[0].value)!=-1);};this.autoOutdent=function(n,q,u){var r=q.getLine(u-1);var p=this.$getIndent(r).length;
var m=this.$tokenizer.getLineTokens(r,"start").tokens;var o=q.getTabString().length;var t=p+o*j(m);var s=this.$getIndent(q.getLine(u)).length;if(s<t){return;
}q.outdentRows(new c(u,0,u+2,0));};}).call(i.prototype);f.Mode=i;});define("ace/mode/lua_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,b,e){var f=c("../lib/oop");
var a=c("./text_highlight_rules").TextHighlightRules;var d=function(){var l=("break|do|else|elseif|end|for|function|if|in|local|repeat|return|then|until|while|or|and|not");
var o=("true|false|nil|_G|_VERSION");var j=("string|xpcall|package|tostring|print|os|unpack|require|getfenv|setmetatable|next|assert|tonumber|io|rawequal|collectgarbage|getmetatable|module|rawset|math|debug|pcall|table|newproxy|type|coroutine|_G|select|gcinfo|pairs|rawget|loadstring|ipairs|_VERSION|dofile|setfenv|load|error|loadfile|sub|upper|len|gfind|rep|find|match|char|dump|gmatch|reverse|byte|format|gsub|lower|preload|loadlib|loaded|loaders|cpath|config|path|seeall|exit|setlocale|date|getenv|difftime|remove|time|clock|tmpname|rename|execute|lines|write|close|flush|open|output|type|read|stderr|stdin|input|stdout|popen|tmpfile|log|max|acos|huge|ldexp|pi|cos|tanh|pow|deg|tan|cosh|sinh|random|randomseed|frexp|ceil|floor|rad|abs|sqrt|modf|asin|min|mod|fmod|log10|atan2|exp|sin|atan|getupvalue|debug|sethook|getmetatable|gethook|setmetatable|setlocal|traceback|setfenv|getinfo|setupvalue|getlocal|getregistry|getfenv|setn|insert|getn|foreachi|maxn|foreach|concat|sort|remove|resume|yield|status|wrap|create|running|__add|__sub|__mod|__unm|__concat|__lt|__index|__call|__gc|__metatable|__mul|__div|__pow|__len|__eq|__le|__newindex|__tostring|__mode|__tonumber");
var p=("string|package|os|io|math|debug|table|coroutine");var v="";var s=("setn|foreach|foreachi|gcinfo|log10|maxn");var u=this.createKeywordMapper({keyword:l,"support.function":j,"invalid.deprecated":s,"constant.library":p,"constant.language":o,"invalid.illegal":v,"variable.language":"this"},"identifier");
var q="";var n="(?:(?:[1-9]\\d*)|(?:0))";var i="(?:0[xX][\\dA-Fa-f]+)";var k="(?:"+n+"|"+i+")";var t="(?:\\.\\d+)";var g="(?:\\d+)";var m="(?:(?:"+g+"?"+t+")|(?:"+g+"\\.))";
var r="(?:"+m+")";var h=[];this.$rules={start:[{token:"comment",regex:q+"\\-\\-\\[\\[.*\\]\\]"},{token:"comment",regex:q+"\\-\\-\\[\\=\\[.*\\]\\=\\]"},{token:"comment",regex:q+"\\-\\-\\[\\={2}\\[.*\\]\\={2}\\]"},{token:"comment",regex:q+"\\-\\-\\[\\={3}\\[.*\\]\\={3}\\]"},{token:"comment",regex:q+"\\-\\-\\[\\={4}\\[.*\\]\\={4}\\]"},{token:"comment",regex:q+"\\-\\-\\[\\={5}\\=*\\[.*\\]\\={5}\\=*\\]"},{token:"comment",regex:q+"\\-\\-\\[\\[.*$",merge:true,next:"qcomment"},{token:"comment",regex:q+"\\-\\-\\[\\=\\[.*$",merge:true,next:"qcomment1"},{token:"comment",regex:q+"\\-\\-\\[\\={2}\\[.*$",merge:true,next:"qcomment2"},{token:"comment",regex:q+"\\-\\-\\[\\={3}\\[.*$",merge:true,next:"qcomment3"},{token:"comment",regex:q+"\\-\\-\\[\\={4}\\[.*$",merge:true,next:"qcomment4"},{token:function(y){var x=/\-\-\[(\=+)\[/,w;
if((w=x.exec(y))!=null&&(w=w[1])!=undefined){h.push(w.length);}return"comment";},regex:q+"\\-\\-\\[\\={5}\\=*\\[.*$",merge:true,next:"qcomment5"},{token:"comment",regex:"\\-\\-.*$"},{token:"string",regex:q+"\\[\\[.*\\]\\]"},{token:"string",regex:q+"\\[\\=\\[.*\\]\\=\\]"},{token:"string",regex:q+"\\[\\={2}\\[.*\\]\\={2}\\]"},{token:"string",regex:q+"\\[\\={3}\\[.*\\]\\={3}\\]"},{token:"string",regex:q+"\\[\\={4}\\[.*\\]\\={4}\\]"},{token:"string",regex:q+"\\[\\={5}\\=*\\[.*\\]\\={5}\\=*\\]"},{token:"string",regex:q+"\\[\\[.*$",merge:true,next:"qstring"},{token:"string",regex:q+"\\[\\=\\[.*$",merge:true,next:"qstring1"},{token:"string",regex:q+"\\[\\={2}\\[.*$",merge:true,next:"qstring2"},{token:"string",regex:q+"\\[\\={3}\\[.*$",merge:true,next:"qstring3"},{token:"string",regex:q+"\\[\\={4}\\[.*$",merge:true,next:"qstring4"},{token:function(y){var x=/\[(\=+)\[/,w;
if((w=x.exec(y))!=null&&(w=w[1])!=undefined){h.push(w.length);}return"string";},regex:q+"\\[\\={5}\\=*\\[.*$",merge:true,next:"qstring5"},{token:"string",regex:q+'"(?:[^\\\\]|\\\\.)*?"'},{token:"string",regex:q+"'(?:[^\\\\]|\\\\.)*?'"},{token:"constant.numeric",regex:r},{token:"constant.numeric",regex:k+"\\b"},{token:u,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\/|%|\\#|\\^|~|<|>|<=|=>|==|~=|=|\\:|\\.\\.\\.|\\.\\."},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]\\)\\}]"},{token:"text",regex:"\\s+"}],qcomment:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment1:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\=\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment2:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={2}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment3:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={3}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment4:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={4}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment5:[{token:function(A){var z=/\](\=+)\]/,B=this.rules.qcomment5[0],w;
B.next="start";if((w=z.exec(A))!=null&&(w=w[1])!=undefined){var y=w.length,x;if((x=h.pop())!=y){h.push(x);B.next="qcomment5";}}return"comment";},regex:"(?:[^\\\\]|\\\\.)*?\\]\\={5}\\=*\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qstring:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring1:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\=\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring2:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={2}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring3:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={3}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring4:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={4}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring5:[{token:function(A){var z=/\](\=+)\]/,B=this.rules.qstring5[0],w;
B.next="start";if((w=z.exec(A))!=null&&(w=w[1])!=undefined){var y=w.length,x;if((x=h.pop())!=y){h.push(x);B.next="qstring5";}}return"string";},regex:"(?:[^\\\\]|\\\\.)*?\\]\\={5}\\=*\\]",next:"start"},{token:"string",merge:true,regex:".+"}]};
};f.inherits(d,a);b.LuaHighlightRules=d;});